<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.restore">
	<div  data-ng-controller="selectRestoreDestinationHostController">
		<div class="setup-title">
		<!-- the title must be changed for vm folder path -->
			<h1><span data-ng-if="!server.browseForFolderPath"><cv:msg key="label.selectRestoreDestination" bundle="restore" /></span>
				<span data-ng-if="server.browseForFolderPath"><cv:msg key="placeholder.selectVmFolderPath" bundle="restoreJs" /></span>
			</h1>
		</div>
		<div class="margin-10" data-ng-if="showClustersNotSupportedForLiveSyncIO||showTestBootMessage">
			<cv-please-note data-ng-if="showClustersNotSupportedForLiveSyncIO && !isRegularPolicyAppType" header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.clustersNotSupportedForLiveSyncIOMsg" bundle="restoreJs" />'></cv-please-note>
			<cv-please-note data-ng-if="showTestBootMessage" header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.bootMessageForBLR" bundle="restoreJs" />'></cv-please-note>
		</div>
		<div class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="selectVmForm" novalidate cv-submit="select()" autocomplete="off" class="selectVmForm">
				<cv-vm-destinations
					selected-content='selectionStore'
					server-id="{{server.clientId}}"
					tree-data='treeDataSelection'
					selectable-type="{{server.browseForFolderPath ? 'FOLDER' :server.selectableType?server.selectableType: 'SERVER'}}"
					single-selection-mode="{{multiSelectMode ? '' : 'true'}}"
					hide-grouping="true"
					server-name="{{server.serverName}}"
					username="{{server.username}}"
					password="{{server.password}}"
					proxy-id="{{server.proxyId}}"
					vendor="{{server.vendor}}"
					browse-for-folder-path={{server.browseForFolderPath}}
					destination-host={{server.destinationHost}}
					selectable-types='server.selectableTypes'>
				</cv-vm-destinations>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="selectRestoreDestinationHostModal_button_#7970" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="selectRestoreDestinationHostModal_button_#1177" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>