<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.restore">
	<div  data-ng-controller="selectRestoreAvailabilityZoneController">
		<div class="setup-title">
			<h1><cv:msg key="label.selectAvailabilityZone" bundle="restore" /></h1>
		</div>
		<div class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="selectVmForm" novalidate cv-submit="select()" autocomplete="off" class="selectVmForm">
				<cv-availability-zones
					selected-content='selectionStore'
					server-id="{{server.clientId}}"
					selectable-type="SERVER"
					single-selection-mode="true"
					hide-grouping="true"
					server-name="{{server.serverName}}"
					username="{{server.username}}"
					password="{{server.password}}"
					vendor="{{server.vendor}}"
					region="{{server.region}}"
	                mode="{{server.mode}}"
	                zone="{{server.zone}}">
				</cv-availability-zones>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="selectRestoreAvailabilityZoneModal_button_#3526" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="selectRestoreAvailabilityZoneModal_button_#8871" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>