<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
</script>
<script type="text/ng-template" id="storage">
	<div class="form-group" >
		<label class="col-xs-12 col-sm-5" for="storage"><cv-help-text help-text="help.storage" help-label="label.storage"></cv-help-text></label>
		<div class="col-xs-12 col-sm-7">
			<isteven-multi-select
				id="storage"
				name="storage"
				class="isteven-multi-select"
				input-model="model.storagePool"
				output-model="model.copy.primary.storage"
				item-label="name"
				button-label="name"
				tick-property="selected"
				selection-mode="single"
				max-labels="1"
				group-property="msGroup"
				translation="localLang"
				on-item-click="onPrimaryStorageSelect()"
				on-close="populateData()">
			</isteven-multi-select>
			<span class="help-block" data-ng-if="model.storageErrorMessage">
				<cv:msg key="error.selectStorage" bundle="storage" />
			</span>
		</div>
	</div>
</script>
	<!-- Recovery Options -->
	<div data-ng-if="!model.hideHeader">
		<h4><cv:msg key="label.recoveryOptions" bundle="vmsJs" /></h4>
	</div>
		<div class="form-group">
			<label class="col-xs-12 col-sm-5" for="recoveryTypes"><cv:msg
					key="label.recoveryType" bundle="vmsJs"></cv:msg></label>
			<div class="col-xs-12 col-sm-7">
				<isteven-multi-select id="selectRecoveryOptions_isteven-multi-select_#1569"  input-model="model.recoveryTypes" 
							output-model="outputRecoveryTypeArr" button-label="name"
							item-label="name" tick-property="selected"
							class="isteven-multi-select user-group-select"
							helper-elements="filter" selection-mode="single"
							on-close="populateData()">
				</isteven-multi-select>
				<div class="text-left">
					<div
						data-ng-switch="model.type.id">
						<div data-ng-switch-when="1">
							<span class="dark-gray-help-text"><cv:msg key="label.recoveryLiveDescription"
								bundle="vmsJs"></cv:msg></span>
						</div>
						<div data-ng-switch-when="4">
							<span class="dark-gray-help-text"><cv:msg key="label.recoveryGrangularDescription"
								bundle="vmsJs"></cv:msg></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div data-ng-switch="model.type.id">
			<div data-ng-switch-when="4">
				<!-- div class="form-group">
					<label class="col-xs-12 col-sm-5">Recommended settings</label>
					<div class="col-xs-12 col-sm-7">
						<select name="recommendedGranularRecoverySettings" id="recommendedGranularRecoverySettings"
						data-ng-options="type.name for type in model.recommendedGranularRecoverySettings"
						data-ng-model="model.recommendedRecoverySettings" data-ng-change="changeRecommendedSettings()">
					</select>
					</div>
				</div -->
				<!-- rp stores -->
				<div class="form-group">
					<label class="col-xs-12 col-sm-5"><cv-help-text help-text="help.rpStore" help-label="label.rpStore"></cv-help-text></label>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group">
							<isteven-multi-select id="selectRecoveryOptions_isteven-multi-select_#1717" input-model="rpStoreList" data-ng-if= "(rpStoreList && (rpStoreList.length > 0))" 
								output-model="model.rpStore" button-label="rpStoreName"
								item-label="rpStoreName" tick-property="selected"
								class="isteven-multi-select user-group-select"
								helper-elements="filter" selection-mode="single"
								on-close="populateData()"  translation="localLang">
							</isteven-multi-select>
							<span class="input-group-btn">
								<a class="recover-point-store-upload glyphicon glyphicon-plus margin-left-10" data-ng-click="showAddRPStoreModal()" title='<cv:msg key="label.createRPStore" bundle="vmsJs"/>'></a>
							</span>
						</div>
						<span class="help-block" data-ng-if="model.rpStoreErrorMessage"><i class="ion-alert-circled" ></i>{{model.rpStoreErrorMessage}}</span>
					</div>
				</div>
				<div data-ng-if="::enableSimplifiedLiveSync">
					<div data-ng-include="'storage'"> </div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<h4><cv:msg key="label.recoveryPointIntervals" bundle="blrJs"/></h4>
					</div>
				</div>
				<!-- crash consistent recovery points interval -->
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<input id="useCcrp" name="useCcrp" type="checkbox"
										data-ng-change="populateData()"
										data-ng-model="model.useCcrp"/>
						<label for="useCcrp"><cv:msg key="label.ccrpInterval" bundle="blrJs"></cv:msg></label>
					</div>
					<div class="col-xs-12 col-sm-7" data-ng-disabled="!model.useCcrp">
						<div class="float-left width-auto">
							<cv-time-relative-picker picker-id="pickerCCRPIntervalValue" seconds="model.ccrpIntervalValue" is-disabled="!model.useCcrp" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useCcrp,model.ccrpIntervalValue)">
								<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="areCCRPAndACRPValuesSame">
							<i class="ion-alert-circled" ></i><cv:msg key="error.sameValueForCCRPAndACRP" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="areCCRPAndACRPBothOptionsUnchecked">
							<i class="ion-alert-circled" ></i><cv:msg key="error.ccrpAndACRPBothOptionsUnchecked" bundle="blrJs"></cv:msg>
						</span>
					</div>
				</div>
				<!-- app consistent recovery points interval -->
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<input id="useAcrp" name="useAcrp" type="checkbox"
									data-ng-change="populateData()"
									data-ng-model="model.useAcrp"/>
						<label for="useAcrp"><cv:msg key="label.acrpInterval" bundle="blrJs"></cv:msg></label>
					</div>
					<div class="col-xs-12 col-sm-7" data-ng-disabled="!model.useAcrp">
						<div class="float-left width-auto">
						<cv-time-relative-picker picker-id="pickerAcrpIntervalValue" seconds="model.acrpIntervalValue" is-disabled="!model.useAcrp" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useAcrp,model.acrpIntervalValue)">
								<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="areCCRPAndACRPValuesSame">
							<i class="ion-alert-circled" ></i><cv:msg key="error.sameValueForCCRPAndACRP" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="areCCRPAndACRPBothOptionsUnchecked">
							<i class="ion-alert-circled" ></i><cv:msg key="error.ccrpAndACRPBothOptionsUnchecked" bundle="blrJs"></cv:msg>
						</span>
					</div>
				</div>

				<div class="form-group">
					<div class="col-xs-12">
						<h4><cv:msg key="label.recoveryPointRetention" bundle="blrJs"/></h4>
					</div>
				</div>

				<!-- Change journal retention interval -->
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<label for="useRpRetention"><cv:msg key="label.rpRetention" bundle="blrJs"></cv:msg></label>
					</div>
					<div class="col-xs-12 col-sm-7">
						<div class="float-left width-auto">
							<cv-time-relative-picker picker-id="pickerRpRetentionValue" seconds="model.rpRetentionValue" is-disabled="!model.useRpRetention" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useRpRetention,model.rpRetentionValue)">
							<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="maxJournalRetentionExceeded">
							<i class="ion-alert-circled" ></i><cv:msg key="error.maxJournalRetentionExceeded" bundle="blrJs"></cv:msg>
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<input id="useRpMerge" name="useRpMerge" type="checkbox"
										data-ng-change="populateData()"
										data-ng-model="model.useRpMerge"/>
						<label for="useRpMerge"><cv:msg key="label.mergeRecoveryPoints" bundle="blrJs"/></label>
					</div>
				</div>
				<!-- merge recovery points older than -->
				<div class="form-group padding-left-20" data-ng-if="model.useRpMerge">
					<div class="col-xs-12 col-sm-5">
						<label for="useRpMergeDelay">
<%-- 								<cv-help-component ng-cloak help-text="<cv:msg key="info.rpMergeDelay" bundle="blrJs"></cv:msg>" help-placement="right"></cv-help-component> --%>
							<cv-help-text help-label="<cv:msg key='label.rpMergeDelay' bundle='blrJs' />" help-text="'<cv:msg key='info.rpMergeDelay' bundle='blrJs' />'"></cv-help-text>
						</label>
					</div>
					<div class="col-xs-12 col-sm-7"  data-ng-disabled="!model.useRpMerge">
						<div class="float-left width-auto">
							<cv-time-relative-picker picker-id="pickerRpMergeDelayValue" seconds="model.rpMergeDelayValue" is-disabled="!model.useRpMerge" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useRpMerge,model.rpMergeDelayValue)">
							<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="invalidMergeOlderThan">
							<i class="ion-alert-circled" ></i>{{invalidMergeOlderThanMsg}}
						</span>
					</div>
				</div>
				<!-- recovery point interval at the end of retention -->
				<div class="form-group padding-left-20" data-ng-if="model.useRpMerge">
					<div class="col-xs-12 col-sm-5">
						<label for="useMaxRpInterval"><cv:msg key="label.maxRpInterval" bundle="blrJs"></cv:msg></label>
					</div>
					<div class="col-xs-12 col-sm-7" data-ng-disabled="!model.useRpMerge">
						<div class="float-left width-auto">
						<cv-time-relative-picker picker-id="pickerMaxRpIntervalValue" seconds="model.maxRpIntervalValue" is-disabled="!model.useRpMerge" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useRpMerge,model.maxRpIntervalValue)">
							<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
						<span class="help-block" data-ng-show="invalidRPIntervalAtEndOfRetention">
							<i class="ion-alert-circled" ></i>{{invalidRPIntervalAtEndOfRetentionMsg}}
						</span>
					</div>
				</div>
				<!-- switch to live recovery if rp store is offline for more than -->
				<div class="form-group">
					<div class="col-xs-12 col-sm-5">
						<input id="useMaxRpStoreOfflineTime" name="useMaxRpStoreOfflineTime" type="checkbox"
										data-ng-change="populateData()"
										data-ng-model="model.useMaxRpStoreOfflineTime"/>
						<label for="useMaxRpStoreOfflineTime"><cv:msg key="label.maxRpStoreOfflineTime" bundle="blrJs"></cv:msg></label>
					</div>
					<div class="col-xs-12 col-sm-7" data-ng-disabled="!model.useMaxRpStoreOfflineTime">
						<div class="float-left width-auto">
							<cv-time-relative-picker picker-id="pickerMaxRpStoreOfflineTimeValue" seconds="model.maxRpStoreOfflineTimeValue" is-disabled="!model.useMaxRpStoreOfflineTime" validation-func="this.timePickerValueChanged(pickerId,seconds)"></cv-time-relative-picker>
						</div>
						<span class="help-block" data-ng-show="isInvalidValue(model.useMaxRpStoreOfflineTime,model.maxRpStoreOfflineTimeValue)">
							<i class="ion-alert-circled" ></i><cv:msg key="error.onlyPositiveValues" bundle="blrJs"></cv:msg>
						</span>
					</div>
				</div>
				<!-- prune and merge changes during off peak time only -->
				<div class="form-group">
					<div class="col-xs-12">
						<input id="useOffPeakSchedule" name="useOffPeakSchedule" type="checkbox"
										data-ng-change="populateData()"
										data-ng-model="model.useOffPeakSchedule"/>
						<label for="useOffPeakSchedule"><cv:msg key="label.useOffPeakSchedule" bundle="blrJs"></cv:msg></label>
					</div>
				</div>
			</div>

			<div data-ng-switch-when="1">
				<div data-ng-if="::enableSimplifiedLiveSync">
					<div data-ng-include="'storage'"> </div>
				</div>
			</div>
</div>