<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="pageHeader.addVirtualNetwork" bundle="restore"/></h1>
</div>
<span class="{{addVirtualNetworkCtrl.errorMessage.type}} serverMessage">{{addVirtualNetworkCtrl.azureErrorMessage.message}}</span>
<form id="createNetworkInterface"  name="createNetworkInterfaceForm" novalidate
	data-cv-submit="addVirtualNetworkCtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper">
	<div class="modal-body">
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="networkName"><cv:msg key="label.networkName" bundle="restore" /></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<input type="text" name="networkName" id="networkName" data-ng-model="addVirtualNetworkCtrl.model.name" required />
				<div class="help-block" data-ng-if="cv.createNetworkInterfaceForm.needsAttention(createNetworkInterfaceForm.networkName)">
					<i class="ion-alert-circled" ></i><cv:msg key="error.networkName" bundle="restore"/>
				</div>
			</div>
		</div>
		<!-- To be determined if we need user enter subnetName
			<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="subnetName"><cv:msg key="label.subnetName" bundle="restore" /></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<input type="text" name="subnetName" id="subnetName" data-ng-model="addVirtualNetworkCtrl.model.subnetName" required />
				<div class="help-block" data-ng-if="cv.createNetworkInterfaceForm.needsAttention(createNetworkInterfaceForm.subnetName)">
					<i class="ion-alert-circled" ></i><cv:msg key="error.subnetName" bundle="restore"/>
				</div>
			</div>
		</div>
		 -->
		<div class="form-group" id="customization-wrapper">
			<label class="col-xs-12 col-md-5 col-lg-5" for="networkAddress">
				<cv:msg key="label.networkAddress" bundle="restore" />
				<cv-help-component help-text="<cv:msg key="label.networkAddressHelpText" bundle="restore"/>"></cv-help-component>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<input placeholder="___.___.___.___/___"  type="text" data-ng-change="addVirtualNetworkCtrl.parseCIDR(addVirtualNetworkCtrl.model.networkAddress)" name="networkAddress" id="networkAddress" data-ng-model="addVirtualNetworkCtrl.model.networkAddress" data-ng-pattern="addVirtualNetworkCtrl.constant.ipPattern" required />
				<div class="help-block" data-ng-if="cv.createNetworkInterfaceForm.needsAttention(createNetworkInterfaceForm.networkAddress) && createNetworkInterfaceForm.networkAddress.$error.required">
					<i class="ion-alert-circled" ></i><cv:msg key="error.ipAddressSettings.ipAddress" bundle="restore"/>
				</div>
				<div class="help-block" data-ng-if="cv.createNetworkInterfaceForm.needsAttention(createNetworkInterfaceForm.networkAddress) && !createNetworkInterfaceForm.networkAddress.$error.required" >
					<i class="ion-alert-circled" ></i><cv:msg key="error.ipAddressSettings.ipAddress" bundle="restore"/>
				</div>
				<div class="info-help-text" data-ng-if="createNetworkInterfaceForm.networkAddress && !createNetworkInterfaceForm.networkAddress.$error.pattern && !createNetworkInterfaceForm.networkAddress.$error.required">
				{{addVirtualNetworkCtrl.constant.validRangeHelpText}}
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<fmt:bundle basename="localization.messages">
			<button id="addVirtualNetworkAzure_button_#9829" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="addVirtualNetworkCtrl.cancel()"><cv:msg key="Cancel" /></button> 
			<button id="addVirtualNetworkAzure_button_#4278" type="submit" class="btn btn-primary cvBusyOnAjax" > 
					<cv:msg key="Add" />
			</button>
		</fmt:bundle>
	</div>
</form>