<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.restore">
	<div  data-ng-controller="selectRestoreDestinationHostController">
		<div class="setup-title">
			<h1><cv:msg key="label.amiSelection" bundle="restore"/></h1>
		</div>		
		<div class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="selectVmForm" novalidate cv-submit="select()" autocomplete="off" class="selectVmForm">
				<cv-ami
					selected-content='selectionStore'
					server-id="{{server.clientId}}"
					server-name="{{server.serverName}}"
					selectable-type="VM"
					single-selection-mode="true"
					hide-grouping="true"
					availability-zone="{{server.availabilityZone}}"
					vendor="{{server.vendor}}">
				>
				</cv-ami>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="amazonAMISelectionModal_button_#8150" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="amazonAMISelectionModal_button_#2538" type="submit" class="btn btn-primary cvBusyOnAjax" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>