<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>

<div class="text-align-center">
	<div data-ng-if="ruleGrpCtrl.showAddRuleGroupButton">
		<div class="ng-scope flex-detail-header margin-bottom-5">
			<span class="horizontal-button-container">
				<a class="horizontal-link-button" data-ng-click="ruleGrpCtrl.addRule()"><cv:msg key="action.add" bundle="collections"/></a>
			</span>
		</div>
		<hr class="rule-group-divider margin-top-5">
	</div>
	
	<span class="server-message col-xs-12 small text-center" data-ng-if="ruleGrpCtrl.ruleGroupsList.length === 0">
		<cv:msg key="label.noRulesAdded" bundle="messagesJs"/>
	</span>
	
	<div data-ng-repeat="ruleGroup in ruleGrpCtrl.ruleGroupsList track by $index">
		<div class="row">
			<div class="col-sm-3 col-xs-3">
				<label class="no-margin padding-left-15">
					<cv:msg key="label.ruleGroup" bundle="messages"/>
					<a href="" data-ng-click="ruleGrpCtrl.removeRuleGroup($index)" title="Remove\">
						<span class="k-icon k-i-close"></span>
					</a>
				</label>
			</div>
			
			<!-- Header: Add rule and select Match option -->
			<div class="col-sm-9">
				<div class="row no-margin">
					<div class="col-sm-3 col-xs-3 col-sm-offset-4 col-xs-offset-2">
						<label class="no-margin inline-label"><a data-ng-click="ruleGrpCtrl.addRule(null, ruleGroup)"><cv:msg key="label.addRule" bundle="collectionsJs"/></a></label>
					</div>
					<label class="no-margin inline-label margin-right-5"><cv:msg key="label.matchRuleGroupOp" bundle="messages"/>: </label>
					<div class='col-sm-1 col-xs-1 form-group editModalLink rule-group-op'>
						<select ng-disabled="ruleGrpCtrl.scgRuleGroupList.length<=1" 
							class="no-margin margin-top-3 padding-left-0 rule-group-op-select no-float inline-form" 
							data-ng-model="ruleGroup.allOrAnyChildren"
							data-ng-change="ruleGrpCtrl.updateRuleType(ruleGroup, $index)"
							id="{{'ruleGroupOpSelect' + $index}}"
							data-ng-options="option.value as option.label for option in ruleGrpCtrl.ruleGroupTypeList"></select>
						</div>
				</div>	
			</div>
		</div>
		<hr class="no-margin margin-bottom-5 margin-left-15 margin-right-10 rule-group-divider">
		<span class="margin-top-10" data-ng-if="ruleGroup && ruleGroup.children && ruleGroup.children.length == 0">
			<centre>
				<cv:msg key="label.noRulesAdded" bundle="messagesJs"/>
			</centre>
		</span>
		
		<!-- Displaying children rules  -->
		<ul class="margin-left-20 text-left" data-ng-if="ruleGroup && ruleGroup.children && ruleGroup.children.length > 0">			
			<li class="margin-bottom-15 ng-scope" data-ng-repeat="rule in ruleGroup.children track by $index" ng-attr-title="{{rule.readableRule}}">
				<a href="" data-ng-click="ruleGrpCtrl.addRule(rule, ruleGroup)" class="ng-binding">{{rule.readableRule}}</a>
				<span class="delete-row">
					<a href="" data-ng-if="ruleGroup.children.length > 1" 
					data-ng-click="ruleGrpCtrl.removeRuleFromGroup(rule, $index, $parent.$parent.$index)" title="Remove">
						<span class="k-icon k-i-close"></span>
					</a>
				</span>
			</li>
		</ul>
	</div>
</div>
