<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class='form-horizontal edit-users-grid-form padding-bottom-10' id="restoreOptionsGoogleCloudForm">
  <div class="row">
  	<!-- VM list iSteven for restore mode -->
  	<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2' : roGoogleCloudCtrl.mode === 'restore'}">
  		<div class="padding-top-0 remove-border-padding" data-ng-class="{'panel-body' : roGoogleCloudCtrl.mode === 'repGroup'}">
  			<!-- VM List -->
  			<cv-select-vms
			  vm-list="roGoogleCloudCtrl.vmLists"
			  model="roGoogleCloudCtrl.model"
			  ctrl="roGoogleCloudCtrl.ctrl"
			  data-ng-if="roGoogleCloudCtrl.mode === roGoogleCloudCtrl.restore  && roGoogleCloudCtrl.vmLists"
			  selection="{{!roGoogleCloudCtrl.editMode ? 'multiple' : 'single'}}">
			</cv-select-vms>

			<!-- ToDO: chekc for VM Display name -->
			<div data-ng-if="roGoogleCloudCtrl.displayOptionDetails">
				<cv-display-name-azure
					restore-data="roGoogleCloudCtrl.model.selectedVms[0]"
					mode="{{roGoogleCloudCtrl.mode}}"
					ctrl="roGoogleCloudCtrl.ctrl"
					is-multiple-mode="roGoogleCloudCtrl.isMultipleMode"
					display-name-label="roGoogleCloudCtrl.displayNameLabel"
					vendor="roGoogleCloudCtrl.vendor">
				</cv-display-name-azure>

				<!-- Zone -->
				<cv-google-cloud-zone 
					restore-data="roGoogleCloudCtrl.model.selectedVms[0]" 
					ctrl="roGoogleCloudCtrl.ctrl"
					edit-mode="roGoogleCloudCtrl.editMode">
				</cv-google-cloud-zone>

				<!--  Machine Type -->
				<div class="form-group" data-ng-if="roGoogleCloudCtrl.zoneUpdated">
					<label class="col-xs-12 col-md-5" for="vmSizes"><cv:msg key="label.machineType" bundle="restore"></cv:msg></label>
					<div class="col-xs-12 col-md-7">
						<isteven-multi-select
								input-model="roGoogleCloudCtrl.restoreData.vmOptions.vmSizesList"
								output-model="roGoogleCloudCtrl.restoreData.vmOptions.vmSize"
								button-label="formattedName"
								item-label="formattedName"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								id="vmSizes"
								on-item-click="roGoogleCloudCtrl.clickVmSizes(data)"
								max-labels="1"
								helper-elements="filter"
								selection-mode="single"
								translation="localLang"
								>
							</isteven-multi-select>
							<span class="help-block" data-ng-show="roGoogleCloudCtrl.inputAlertFlags.vmSize"><cv:msg key="error.machineType" bundle="restore" /></span>
					</div>
				</div>
				<!-- Network info-->
				<div class="form-group" data-ng-if="roGoogleCloudCtrl.zoneUpdated">
					<cv-google-cloud-network 
						restore-data="roGoogleCloudCtrl.model.selectedVms[0]"
						cross-restore="roGoogleCloudCtrl.crossRestore"
						ctrl="roGoogleCloudCtrl.ctrl">
					</cv-google-cloud-network>
				</div>
				<!--public IP checkbox -->
				<div class="form-group">
					<div class="col-xs-12 col-md-7">
						<input name="createPublicIP" id="createPublicIP" type="checkbox" data-ng-model="roGoogleCloudCtrl.model.selectedVms[0].vmOptions.createPublicIP"> <label for="createPublicIP"><cv:msg
						key="label.externalIP" bundle="restore" /> </label>
					</div>
				</div>
			</div>
		</div>
  	</div>
  </div>
</div>