<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper form-horizontal">
	<form name="rtAmazonForm" novalidate data-cv-submit="rtAmazonCtrl.saveAmazonRT()" autocomplete="off" class="replication-target-form">
	<span data-cv-loading-spinner data-ng-model="rtAmazonCtrl.hideLoading"></span>
		<div class="text-center"><span class="{{rtAmazonCtrl.rtAmazonMessage.type}} serverMessage ">{{rtAmazonCtrl.rtAmazonMessage.message}}</span></div>
			<div class="modal-body" data-ng-show="rtAmazonCtrl.hideLoading">
				<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2' : rtAmazonCtrl.mode != rtAmazonCtrl.replicationTargetMode && !rtAmazonCtrl.enableSimplifiedLiveSync, 'col-xs-12' : rtAmazonCtrl.enableSimplifiedLiveSync}">
					<div  data-ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode">
						<!-- Replication Target name -->
						<div class="form-group" >
							<label class="col-xs-12 col-md-5 col-lg-5" for="replicationTargetName"><cv:msg key="label.replicationTarget" bundle="restoreJs" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="text" id="replicationTargetName" name="replicationTargetName" data-ng-model="rtAmazonCtrl.replicationTargetName" required />
								<span class="help-block" data-ng-show="rtAmazonCtrl.errors.replicationTargetName || cv.rtAmazonForm.needsAttention(rtAmazonForm.replicationTargetName)"><cv:msg key="error.name" bundle="messagesJs"/></span>
							</div>
						 </div>

						 <!--  Destination Hypervisor -->
							<div class="form-group" data-ng-show="!rtAmazonCtrl.bEditMode">
									<label class="col-xs-12 col-md-5 col-lg-5" for="serverId"><cv:msg key="label.destinationServer" bundle="restore" />	</label>
									<div class="col-xs-12 col-md-7 col-lg-7" data-ng-disabled="rtAmazonCtrl.disabledHypervisor">
										<select id="serverId" name="serverId" data-ng-options="hypervisor as hypervisor.name for hypervisor in rtAmazonCtrl.hypervisors"
														data-ng-model="rtAmazonCtrl.selectedHypervisor" data-ng-change="rtAmazonCtrl.destinationServerChanged()" required >
										</select>
										<span class="help-block" data-ng-show="cv.rtAmazonForm.needsAttention(rtAmazonForm.serverId)"><cv:msg key="label.selectServer" bundle="servers"/></span>
									</div>
						   </div>
						<!-- Instance display name : Prefix/Suffix -->
							<div class="form-group">
								<label class="col-xs-12 col-md-5 col-lg-5" for="instanceDisplayName"><cv:msg key="label.instanceDisplayName" bundle="restore"/></label>
								<div class="col-xs-12 col-md-5 col-lg-5">
										<div class="multiple-radio-group">
											<label for="displayNamePrefix"><input id="displayNamePrefix" name="displayNamePrefix" value="PREFIX" data-ng-model="rtAmazonCtrl.prefixSuffixSelector"  type="radio" />
											<span class="block-indent"><cv:msg key="label.prefix" bundle="restore" /></span></label>
										</div>
										<div class="multiple-radio-group">
											<label for="displayNameSuffix"><input id="displayNameSuffix" name="displayNameSuffix" value="SUFFIX" data-ng-model="rtAmazonCtrl.prefixSuffixSelector"  type="radio" />
											<span class="block-indent"><cv:msg key="label.suffix" bundle="restore" /></span></label>
										</div>
								</div>
								<label class="col-xs-12 col-md-5 col-lg-5"></label>
								<div class="col-xs-12 col-md-7 col-lg-7 col-lg-offset-5">
									<input type="text" id="displayNamePrefixSuffix" name="displayNamePrefixSuffix" data-ng-model="rtAmazonCtrl.displayNamePrefixSuffix" placeholder='<cv:msg key="placeholder.prefixSuffixDisplayNameAmazon" bundle="restore" />'/>
									<!-- <span class="help-block" data-ng-show="rtAmazonCtrl.errors.displayNamePrefixSuffix || cv.rtAmazonForm.needsAttention(rtAmazonForm.displayNamePrefixSuffix)"><cv:msg key="error.prefixSuffixDisplayNameAmazon" bundle="restore"/></span>-->
								</div>
							</div>

						<!--  Proxy -->
							<div class="form-group">
									<label class="col-xs-12 col-md-5 col-lg-5" for="destinationProxy"><cv:msg key="label.accessNode" bundle="restore"/></label>
									<div class="col-xs-12 col-md-7 col-lg-7">
										 <cv-select-proxy
											id="destinationProxy"
											name="destinationProxy"
											model="rtAmazonCtrl.model"
											ctrl="rtAmazonCtrl.ctrl"
											selection="single"
											is-replication="!rtAmazonCtrl.isRegularPolicy()"
											automatic-proxy="rtAmazonCtrl.distributeWorkload">
										 </cv-select-proxy>
										<!-- <select id="destinationProxy" name="destinationProxy" data-ng-options="proxy as proxy.clientName for proxy in rtAmazonCtrl.proxyServers  track by proxy.clientId | orderBy: 'clientName'"
														data-ng-model="rtAmazonCtrl.selectedProxyServer" required
														data-ng-change="rtAmazonCtrl.proxyServerChanged()">
										</select> -->
									</div>
						   </div>


						</div>


						<!-- VM list iSteven for restore mode -->
						<div class="form-group" data-ng-if="rtAmazonCtrl.showVMSelect">
							<label class="col-xs-12 col-md-5 col-lg-5" for ="vmSelection"><cv:msg	key="label.virtualMachine" bundle="restore"></cv:msg></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<isteven-multi-select
								    id="vmSelection"
								   	name="vmSelection"
									data-input-model="rtAmazonCtrl.vmList"
									data-output-model="rtAmazonCtrl.selectedVMs"
									data-tick-property="checked"
									data-item-label="name"
									class="isteven-multi-select user-group-select"
									data-button-label="name"
									data-search-property="name"
									data-helper-elements="all none filter"
									data-selection-mode="single"
									translation="rtAmazonCtrl.localLang"
									on-close="rtAmazonCtrl.saveVMListSelection()"
									on-open="rtAmazonCtrl.ctrl.openVmListSelection()"
									on-item-click="rtAmazonCtrl.onItemClickVMListselection(data)"
									></isteven-multi-select>
							</div>
						</div>
						<div class="form-group"  data-ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.restoreMode  && (rtAmazonCtrl.selectedVMs && rtAmazonCtrl.selectedVMs.length > 0 && rtAmazonCtrl.restoreTargetModel)">
									<label data-ng-disabled="disableEditing" class="col-xs-12 col-md-5 col-lg-5" for="vmDisplayName"><cv:msg key="label.changeInstanceDisplayName" bundle="restore"/></label>
									<div class="col-xs-12 col-md-7 col-lg-7">
										<input type="text" name="vmDisplayName" data-ng-disabled="disableEditing" 	data-ng-model="rtAmazonCtrl.selectedVMs[0].newName" required />
										<span class="help-block" data-ng-show="rtAmazonCtrl.errors.vmDisplayName || cv.rtAmazonForm.needsAttention(rtAmazonForm.vmDisplayName)"><cv:msg key="error.displayName" bundle="restore"/></span>
									</div>
						</div>
						<div data-ng-show="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode  || (rtAmazonCtrl.mode === rtAmazonCtrl.restoreMode && (rtAmazonCtrl.selectedVMs && rtAmazonCtrl.selectedVMs.length > 0 && rtAmazonCtrl.restoreTargetModel) )">

					 <div data-ng-disabled="disableEditing">
					<cv-availability-zone
									selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
									selected-availability-zone="rtAmazonCtrl.selectedAvailabilityZone"
									on-after-availability-zone-selected = "rtAmazonCtrl.onAfterAvailabilityZoneSelected(availabilityZone)"
									restore-target-model = "rtAmazonCtrl.restoreTargetModel"
									data-ng-if="rtAmazonCtrl.hideDetails">
					</cv-availability-zone>
					</div>

						<!-- Buckets, network settings and security groups depend on availability zone. So till zone is not selected, no need to show the sections -->
						<cv-amazon-volume-types
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
							selected-availability-zone ="rtAmazonCtrl.selectedAvailabilityZone"
							selected-volume-type = "rtAmazonCtrl.selectedVolumeType"
							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
							data-ng-if="rtAmazonCtrl.showVolumeAndEncType">
						</cv-amazon-volume-types>

						<cv-amazon-encryption-keys
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
							selected-availability-zone ="rtAmazonCtrl.selectedAvailabilityZone"
							selected-encryption-key = "rtAmazonCtrl.selectedEncryptionKey"
							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
							data-ng-if="rtAmazonCtrl.showVolumeAndEncType">
						</cv-amazon-encryption-keys>

						<cv-network-setting
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
							selected-availability-zone ="rtAmazonCtrl.selectedAvailabilityZone"
							selected-network-settings = "rtAmazonCtrl.selectedNetworkSettings"
							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
							auto-security-group-checked = "rtAmazonCtrl.autoSecurityGroupChecked"
							selected-security-groups = "rtAmazonCtrl.selectedSecurityGroups"
							data-ng-if="rtAmazonCtrl.hideDetails">
						</cv-network-setting>

						<!-- removing AWS buckets -->
						<!--
						<div ng-if= "rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode">
						<cv-amazon-buckets
							selected-availability-zone ="rtAmazonCtrl.selectedAvailabilityZone"
							selected-amazon-bucket = "rtAmazonCtrl.selectedAmazonBucket"
							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
							data-ng-if="rtAmazonCtrl.hideDetails">
						</cv-amazon-buckets>
						</div>
						-->
						<cv-instance-types
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
 							auto-instance-type-checked = "rtAmazonCtrl.autoInstanceTypeChecked"
 							selected-instance-type = "rtAmazonCtrl.selectedInstanceType"
 							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
 							data-ng-if="rtAmazonCtrl.hideDetails">
 						</cv-instance-types>
						<!-- This only needs to be during vmw-> aws and an amazon proxy is selected -->
						<div data-ng-if="rtAmazonCtrl.showGuestCredentials">
							<cv-amazon-guest-credentials
 								is-amazon-proxy="rtAmazonCtrl.isAmazonProxy"
 								guest-credentials="rtAmazonCtrl.guestCredentials"
 								data-ng-if="rtAmazonCtrl.hideDetails">
							</cv-amazon-guest-credentials>
						</div>


					<!-- Test fail over Option -->
						<div data-ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode && !rtAmazonCtrl.isRegularPolicy() && !rtAmazonCtrl.hideTestFailoverOptions" data-ng-init="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode">
							<h4 class="form-header" for="testFailOver" >
								<cv:msg key="label.testFailoverOptions" bundle="vmManagementJs" />
							</h4>

							<div class="form-group">
								<label class="col-xs-12 col-md-5 col-lg-5" for="expirationTimeAz"><cv:msg key="label.expirationTime" bundle="restore"/>
							    </label>
						        <div class="col-xs-12 col-md-7 col-lg-7">
									<span>
										<input type="radio" id="expirationTimeHoursAz" name="expirationTimeHoursDaysAz"
											data-ng-model="rtAmazonCtrl.expirationTime" value="Hours"
											data-ng-click="rtAmazonCtrl.expirationTimeClick(rtAmazonCtrl.expirationTime)">
										<label for="expirationTimeInHours">
											<cv:msg key="label.hours" bundle="restore" />
										</label>
										<input type="number"
											id="expirationTimeInHours" name="expirationTimeInHours"
											data-ng-model="rtAmazonCtrl.minutesRetainUntil" min="1"
											max="24" data-ng-click="rtAmazonCtrl.expirationTimeClick('Hours')"
											data-ng-init="rtAmazonCtrl.minutesRetainUntil = (rtAmazonCtrl.minutesRetainUntil > 1 ? rtAmazonCtrl.minutesRetainUntil : 1)">
										<input type="radio" id="expirationTimeDaysAz" name="expirationTimeHoursDaysAz"
											data-ng-model="rtAmazonCtrl.expirationTime"
											class="expirationTime" value="Days"
											data-ng-click="rtAmazonCtrl.expirationTimeClick(rtAmazonCtrl.expirationTime)">
										<label for="expirationTimeInDaysAz" class="expirationTimeLabel">
											<cv:msg key="label.days" bundle="schedule" />
										</label>
										<input type="number" id="expirationTimeInDaysAz" name="expirationTimeInDaysAz"
											data-ng-model="rtAmazonCtrl.daysRetainUntil" min="1" max="999"
											data-ng-change="rtAmazonCtrl.expirationTimeClick('Days')"
											data-ng-init="rtAmazonCtrl.daysRetainUntil = (rtAmazonCtrl.daysRetainUntil > 1 ? rtAmazonCtrl.daysRetainUntil : 1)">
									</span>
						        </div>
							</div>


						<cv-test-network-setting
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
							selected-availability-zone ="rtAmazonCtrl.selectedAvailabilityZone"
							selected-network-settings = "rtAmazonCtrl.selectedTestNetworkSettings"
							restore-target-model = "rtAmazonCtrl.restoreTargetModel"
							auto-security-group-checked = "rtAmazonCtrl.autoTestSecurityGroupChecked">
						</cv-test-network-setting>

						<cv-test-instance-types
							selected-hypervisor = "rtAmazonCtrl.selectedHypervisor"
 							auto-test-instance-type-checked = "rtAmazonCtrl.autoTestInstanceTypeChecked"
 							selected-instance-type = "rtAmazonCtrl.selectedTestInstanceType"
 							restore-target-model = "rtAmazonCtrl.restoreTargetModel">
 						</cv-test-instance-types>


						</div>

						<!-- End Test fail over Option -->

							<h4 class="form-header cursor-pointer push-down" ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode">
							<cv:msg key="label.userMemberShip" bundle="vmManagement"/>
					</h4>
					<div class="form-group" ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode">
						<label class="col-xs-12 col-md-5 col-lg-5" for="usersAndUserGroups"><cv:msg
								key="label.usersAndUserGroups" bundle="restore" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<isteven-multi-select
						   			data-input-model="rtAmazonCtrl.usersAndUserGroups"
						  			data-output-model="rtAmazonCtrl.usersAndUserGroup"
						  			button-label="fullName"
									item-label="fullName"
						   			tick-property="selected"
						   			class="isteven-multi-select user-group-select"
						   			id="usersAndUserGroups"
						   			name="usersAndUserGroups"
						   			search-property="fullName"
						   			max-height="400px"
						   			group-property="header"
						   			selection-mode="multiple">
								</isteven-multi-select>
						</div>
					</div>

				</div>
 			 </div>
		</div>
		<div class="modal-footer" data-ng-if="rtAmazonCtrl.mode === rtAmazonCtrl.replicationTargetMode" data-ng-show="rtAmazonCtrl.hideLoading">
				<button id="restoreOptionsAWS_button_#3784" type="button" class="btn btn-default cvBusyOnAjax " data-ng-click="rtAmazonCtrl.saveAmazonRTCancelled()">
				<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="restoreOptionsAWS_button_#4048" data-ng-if="!rtAmazonCtrl.beditMode" type="submit" class="btn btn-primary cvBusyOnAjax" >
					<cv:msg key="Add" />
				</button>
				<button id="restoreOptionsAWS_button_#6075" data-ng-if="rtAmazonCtrl.beditMode" type="submit" class="btn btn-primary cvBusyOnAjax">
					<cv:msg key="Save" />
				</button>
		</div>
	</form>
</div>
