<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
</script>
<div data-ng-if="browseType === 'vsVolumeBrowse'" class="setup-title">
	<h1>
		<cv:msg key="label.restoreOpts" bundle="restore"></cv:msg>
	</h1>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vmGuid">
<!-- <span id="browseActions" class="page-action-item"> -->
<div data-ng-if="!advancedOptionsVisible()" data-ng-controller="browseOptionsController" class="browse-for-restore no-checkboxes modal-restore-dropdown margin-top-10 text-right"  >
<span class="uib-dropdown" on-toggle="toggled(open)" uib-dropdown>
				      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
				      	{{timeRangeLabel}}<span class="dropdownArrow"></span>
				      </a>
				      <ul uib-dropdown-menu class="dropdown-menu">
				        <li data-ng-if ="!isLatestBackup" data-ng-click="changeDateOption('latest')"><a href=""><cv:msg key="Show_latest_backups" bundle="browse"/></a></li>
				        <li data-ng-click="changeDateOption('date')"><a href=""><cv:msg key="Restore_from_specific_time" bundle="browse"/></a></li>
							<cv:comp name="show.dataRangeDropdownRestore">
								<li data-ng-click="changeDateOption('range')" data-ng-if="showDateRangeDropDown">
									<a href=""><cv:msg key="Restore_from_date_range" bundle="browse"/></a>
								</li>
							</cv:comp>
				      </ul>
</span>
</div>
</div>
<!-- </span> -->

<div class="setup-content padding-bottom-0" data-ng-if="browseType === 'vsVolumeBrowse' && restoreOpt.showRestoreTypeSelector && (!isEndUserLoggedIn || (isEndUserLoggedIn && restoreOpt.targetExist))">
	<div>
		<label><cv:msg key="header.type" bundle="vmsJs"></cv:msg>
			<div  class="company-multi-select">
				<!-- In place -->
				<input class="no-float" id="inPlace" type="radio"
					name="restoreType" value="inPlace"
					data-ng-model="restoreOpt.restoreTypeSelector" ng-change="setRestoreTypeSelector()"/>
					<label for="inPlace"
						class="restore-settings-right-padding inline-label no-margin">
						<cv:msg key="label.restoreInPlace" bundle="restore" />
					</label>
				<!-- Out of place -->
				<input id="outOfPlace" type="radio" name="restoreType"
					value="outOfPlace" data-ng-model="restoreOpt.restoreTypeSelector" ng-change="setRestoreTypeSelector()"/>
					<label for="outOfPlace" class="inline-label no-margin">
						<cv:msg key="label.OOPRestore" bundle="restore" />
					</label>
			</div>
		</label>
	</div>
</div>
 <div data-ng-if="((isOutOfPlaceRestore || showRestoreAsOption) && enableCrossRestore)" class="setup-content padding-bottom-0">
	<label  data-ng-if="!advancedOptionsVisible()"><cv:msg key="label.restoreAs" bundle="browse"></cv:msg>
		<div class="company-multi-select">
				<isteven-multi-select id="restoreVM_isteven-multi-select_#1408"
						input-model="restoreOpt.destinations"
						output-model="selectedRestoreOpt"
						button-label="name"
						item-label="name"
						tick-property="selected"
						selection-mode="single"
						directive-id="destinations"
						class="isteven-multi-select user-group-select single-select"
						helper-elements="filter"
						search-limit="10"
						max-labels="1"
						translation="localLang"
						on-item-click="changeRestoreToVendor(selectedRestoreOpt[0])">
				</isteven-multi-select>
		</div>
	</label>
</div>
<div data-ng-if="browseType==='vsDiskBrowse'" class="setup-title">
	<h1>
		<cv:msg key="label.restoreOpts" bundle="restore"></cv:msg>
	</h1>
</div>
<div data-ng-if="enableSubRestoreTypes" class="bootstrap-wrapper no-padding">
	<div class="form-group margin-right-0 margin-left-0 margin-top-10">
		<div class="col-xs-12">
			<div id="modern-tab" class="tab-3">
				<cv-tabset-component> 
					<cv-tab tabname='<cv:msg key="label.awsAttachVolumeOtherInstance" bundle="restoreJs"/>'
						data-ng-selected="ctrl.subRestoreTypeChange('existingInstance')"
						help-text='<cv:msg key="label.attachVolumeExistingInstanceHelpText" bundle="restoreJs"/>'>
						<div data-ng-controller='vmDiskRestoreOptionsController' class="tabbed-restore-screen-height margin-top-15">
							 <ng-include src = "buildRestoreModalUrl('vmDiskRestore.jsp')"></ng-include>
						</div>
					</cv-tab> 						
					<cv-tab tabname='<cv:msg key="label.awsAttachVolumeMyInstance" bundle="restoreJs"/>'
						data-ng-selected="ctrl.subRestoreTypeChange('myInstance')"
						help-text='<cv:msg key="label.attachVolumeMyInstanceHelpText" bundle="restoreJs"/>'>
						<div data-ng-controller='vmDiskRestoreOptionsController'class="tabbed-restore-screen-height margin-top-15">
							 <ng-include src = "buildRestoreModalUrl('vmDiskRestore.jsp')"></ng-include>
						</div>
					</cv-tab> 
					<cv-tab tabname='<cv:msg key="label.awsAttachVolumeNewInstance" bundle="restoreJs"/>'
						help-text='<cv:msg key="label.attachVolumeNewInstanceHelpText" bundle="restoreJs"/>'
						help-placement="left">
						<div data-ng-controller='vmDiskRestoreAsNewInstanceAWS' class="margin-left-15 margin-right-15 tabbed-restore-screen-height margin-top-15">
							 <ng-include src = "buildRestoreModalUrl('vmDiskAsNewInstanceAWSRestore.jsp')"></ng-include>
						</div>
					</cv-tab>
				</cv-tabset-component>
			</div>
		</div>
	</div>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isVmwareVolumeBrowse()"
	 data-ng-controller='vmFullRestoreVMWareOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreVMWare.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'VCLOUD'"
	 data-ng-controller='vmFullRestoreVcloudOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreVcloud.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'NUTANIX'"
	 data-ng-controller='vmFullRestoreNutanixOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreNutanix.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isAzureVolumeBrowse() && vendor === 'AZURE_V2'"
	 data-ng-controller='vmFullRestoreAzureOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreAzure.jsp')"></ng-include>
</div>
<!-- Added to handle Azure to AzureStack conversion case -->
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isAzureVolumeBrowse() && vendor === 'AZURE_STACK'"
	 data-ng-controller='vmFullRestoreAzureOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreAzure.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isAmazonVolumeBrowse()"
	 data-ng-controller='vmFullRestoreAmazonOptionsController'>
	 <ng-include src= "buildRestoreModalUrl('vmFullRestoreAmazon.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'OPENSTACK'"
	 data-ng-controller='vmFullRestoreOpenStackOptionsController'>
	 <ng-include src= "buildRestoreModalUrl('vmFullRestoreOpenStack.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'REDHAT'"
	  data-ng-controller='vmFullRestoreRedHatController as redHatctrl'>
	 <ng-include src= "buildRestoreModalUrl('vmFullRestoreRedHat.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isMicrosoftVolumeBrowse()"
	 data-ng-controller='vmFullRestoreHyperVOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreHyperV.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vmFileBrowse'"
	 data-ng-controller='vmFileRestoreController'>
	 <ng-include src = "buildRestoreModalUrl('vmFileRestore.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsFileBrowse'"
	 data-ng-controller='fileSystemRestore'>
	 <ng-include src = "buildRestoreModalUrl('fileLevelRestore.jsp')"></ng-include>
</div>
<div data-ng-if="browseType == 'vsDiskBrowse' && !enableSubRestoreTypes"
	 data-ng-controller='vmDiskRestoreOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmDiskRestore.jsp')"></ng-include>
</div>
<!-- AWS Attach disk as new instance restore -->
<div class="{{enableSubRestoreTypes ? 'cross-restore no-padding' : ''}}"
	 data-ng-if="isAWSDiskAsNewInstanceRestore()"
	 data-ng-controller='vmDiskRestoreAsNewInstanceAWS'>
	 <ng-include src = "buildRestoreModalUrl('vmDiskAsNewInstanceAWSRestore.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isOracleCloudVolumeBrowse()"
	 data-ng-controller='vmFullRestoreOracleCloudOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreOracleCloud.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isOracleVMVolumeBrowse()"
	 data-ng-controller='vmFullRestoreOracleVmOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreOracleVM.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'GOOGLE_CLOUD'"
	 data-ng-controller='vmFullRestoreGoogleCloudOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreGoogleCloud.jsp')"></ng-include>
</div>
<div class="{{enableCrossRestore ? 'cross-restore' : ''}}" data-ng-if="isOracleCloudInfrastructureVolumeBrowse()"
	 data-ng-controller='vmFullRestoreOracleCloudInfrastructureOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreOracleCloudInfrastructure.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'ALIBABA_CLOUD'"
	 data-ng-controller='vmFullRestoreAlibabaCloudOptionsController'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreAlibabaCloud.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'REDHAT_OPENSHIFT'"
	 data-ng-controller='vmFullRestoreRedHatOpenShiftOptionsController as vmFullOpenShift'>
	 <ng-include src = "buildRestoreModalUrl('vmFullRestoreRedHatOpenShift.jsp')"></ng-include>
</div>
<div data-ng-if="browseType === 'vsVolumeBrowse' && vendor === 'KUBERNETES'"
	data-ng-controller='vmFullRestoreKubernetesOptionsController as vmFullKubernetes'>
	<ng-include src = "buildRestoreModalUrl('vmFullRestoreKubernetes.jsp')"></ng-include>
</div>
