<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.installProxy" bundle="serversJs"/></h1>
	</div>
	<span class="serverMessage {{proxyModalCtrl.deploymentErrMsg.type}}" data-ng-bind="proxyModalCtrl.deploymentErrMsg.message"></span>
	<span class="serverMessage {{proxyModalCtrl.proxyDeployErrMsg.type}}" data-ng-bind="proxyModalCtrl.proxyDeployErrMsg.message"></span>
	<span class="serverMessage {{proxyModalCtrl.failureMsg.type}}" data-ng-bind="proxyModalCtrl.failureMsg.message"></span>
	<span class="serverMessage {{proxyModalCtrl.authServerMessage.type}}" data-ng-bind="proxyModalCtrl.authServerMessage.message"></span>
	<form name="proxyConfigureDetailsForm" data-cv-submit="proxyModalCtrl.deploy()">
		<div class="bootstrap-wrapper">
			<div class="form-group" id="AccessNode_k8s">
				<label class="col-xs-12 col-md-4 col-lg-4" for="clientNameProxyInput_k8s"><cv:msg key="label.accessNodeName" bundle="restore"/></label>
				<div class="col-xs-12 col-sm-8" data-ng-disabled="proxyModalCtrl.disableDeploy"> 
					<input name="clientNameProxyInput_k8s" id="clientNameProxyInput_k8s" data-ng-model="modalInfo.clientName" type="text" data-ng-change="proxyModalCtrl.removeClientErrMsg()"
					placeholder ="<cv:msg key="label.accessNodeName" bundle="restore" />" required/>
					<span class="help-block" data-ng-show="proxyModalCtrl.missingClientEntry" data-ng-bind="proxyModalCtrl.missingClientEntry"></span>
					<span class="help-block" data-ng-show="proxyModalCtrl.showInvalidClientNameErr" data-ng-bind="proxyModalCtrl.clientNameErrMsg"></span>
					<span class="help-block" data-ng-show="proxyModalCtrl.showInvalidPatternErr" data-ng-bind="proxyModalCtrl.patternErrorMsg"></span>
				</div>
			</div>
			
			<div class="form-group" id="authCode_label">
				<label class="col-xs-12 col-md-4 col-lg-4" for="authCode_labelIST">
					<cv-help-text help-label="label.clientGroups" help-text="'<cv:msg key='label.serverGroupInfo' bundle='vmManagement'/>'" />
				</label>
				<div class="col-xs-12 col-sm-8" data-ng-disabled="proxyModalCtrl.disableDeploy">
					<isteven-multi-select
						input-model="modalInfo.clientGroups"
					  	output-model="modalInfo.clientGroup"
					  	button-label="name"
					  	item-label="name"
					  	selection-mode="single"
		   				tick-property="selected"
		   				class="isteven-multi-select user-group-select"
		   				id="clientGroup"
		   				name="clientGroup"
		   				directive-id="clientGroup"
		   				max-labels="1"
		   				helper-elements="filter"
		   				search-property="name">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="proxyModalCtrl.missingServerGroupEntry" data-ng-bind="proxyModalCtrl.missingServerGroupEntry"></span>
				</div>
			</div>
			<div class="form-group" id="gatewayproxy_conf">
				<label class="col-xs-12 col-md-4 col-lg-4" for="gatewayproxy_conf"><cv:msg key="label.gatewayProxy" bundle="restore"/></label>
				<div class="col-xs-12 col-sm-8" data-ng-disabled="proxyModalCtrl.disableDeploy|| !isAccessNodeSelected">
					<isteven-multi-select
						input-model="modalInfo.gatewayProxyList"
					  	output-model="modalInfo.gatewayProxy"
					  	button-label="clientName"
					  	item-label="clientName"
					  	selection-mode="single"
		   				tick-property="checked"
		   				class="isteven-multi-select user-group-select"
		   				id="gatewayProxy"
		   				name="gatewayProxy"
		   				directive-id="gatewayProxy"
		   				max-labels="1"
		   				helper-elements="filter"
		   				search-property="clientName">
					</isteven-multi-select>
				</div>
			</div>
			
			<div class="form-group" id="DownloadYAML_k8s" data-ng-disabled="proxyModalCtrl.disableOperation">
				<span class="col-xs-12 col-md-4 col-lg-4">
					<a href="" id="downloadYAML_href" name="downloadYAML_href" data-ng-click="proxyModalCtrl.generateConfigFiles()">
						<cv:msg key="label.downloadYAML" bundle="restore" />
					</a>
				</span>
			</div>
			
			<div class="deploy-progress-wrapper" data-ng-if="showDeploymentMsg">
				<span class="serverMessage" data-ng-bind="deploymentMsg"></span>
					<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
			</div>
				
			<div class="button-container full-width">
				<button id="proxyConfigurationModal_button_#6005" type="button" data-ng-click="proxyModalCtrl.cancel()" class="btn btn-default cvBusyOnAjax"> 
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="proxyConfigurationModal_button_#8662" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="proxyModalCtrl.disableOperation || proxyModalCtrl.disableDeploy">
					<cv:msg key="label.deploy" bundle="restore" />
				</button>
			</div>
		</div>
	</form>
	
</div>
