<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.pitFailover" bundle="vmsJs"/></h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body" data-ng-if="pitFailoverController.snapshots && pitFailoverController.snapshots.length==0">
			<label class="col-xs-12 col-sm-12"><cv:msg key="info.pit.snapshotstNotAvailable" bundle="vmsJs"/></label>
		</div>
		<div class="modal-body" data-ng-if="pitFailoverController.snapshots && pitFailoverController.snapshots.length > 0">
			<div class="form-horizontal">
				<form ng-submit="pitFailoverController.submit()">
					
					<div class="form-group" >
						<div class="col-md-3">
							<label for="snapshotTime" class="cv-label"><cv:msg key="label.recoveryPoint" bundle="vmsJs"/></label>
						</div>
						<div class="col-md-9">
							<span data-cv-loading-spinner data-ng-model="pitFailoverController.snapshots"></span>
							<isteven-multi-select
				   				  input-model="pitFailoverController.snapshots"
				   				  output-model="pitFailoverController.selectedSnapshot"
				  				  button-label="timeJob"
								  item-label="timeJob"
				   				  tick-property="selected"
				   				  selection-mode="single"
				   				  class="isteven-multi-select user-group-select"
				   				  id="snapshots"
				   				  name="snapshots"
				   				  search-property="pitFailoverController.servers.time"
				   				  max-height="400px"
				   				  group-property="header"
				   				  helper-elements="filter"
				   				  max-height="200px">
							</isteven-multi-select>
						</div>
					</div>
				</form>
			</div>
			<div>
				<img ng-src="${pageContext.request.contextPath}/common/img/drSteps/pit-failover-steps.png" class="dr4StepsImg"></img>
			</div>
			<div class="dr4StepsTxt">
				<div class="drStepsTxt"><cv:msg key="label.powerOffProductionVM" bundle="dr"/></div>
				<div class="drStepsTxt"><cv:msg key="label.disableLiveSync" bundle="dr"/></div>
				<div class="drStepsTxt"><cv:msg key="label.revertDestVMToTime" bundle="dr"/></div>
				<div class="drStepsTxt"><cv:msg key="label.powerOnDRVM" bundle="dr"/></div>
			</div>
		</div>
	</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="pitFailover_button_#5642" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="pitFailoverController.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="pitFailover_button_#8713" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="pitFailoverController.submit()" ng-disabled="!pitFailoverController.snapshots || pitFailoverController.snapshots.length==0"><cv:msg key="Submit" bundle="messages"/></button> 
		</div>
	</div>
</div>