<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div>
	<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	<div class="modal-header">
		<h3>{{modalOptions.headerText}}</h3>
	</div>
	<div class="modal-body">
	<div data-ng-if="showUndoFailoverOptions === true">
		<div class="checkbox">
				<input type="checkbox" name="discardChanges" id="discardChanges" data-ng-model="discardChanges" data-ng-click="setDiscardChanges()"/>
							<label for="discardChanges" class="cv-label">
								<cv:msg key="label.discardChanges" bundle="vmsJs"/>
						<cv-help-component ng-cloak help-text="<cv:msg key="info.discatdChanges" bundle="vmsJs" />" ></cv-help-component>
							</label>
					<span  data-ng-if="missingDiscardChanges" class="col-xs-12 server-message {{missingDiscardChanges.type}}">{{missingDiscardChanges.message}}</span>
			</div>
		
					</div>
					<div class="margin-bottom-20">
					<cv-please-note data-ng-if="showSourceVMOverwrittenNote" header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="msg.sourceVMOverwrittenAtFailover" bundle="dr"/>'></cv-please-note>
					<cv-please-note data-ng-if="showCustomNote" header='<cv:msg key="action.note" bundle="restoreJs" />' body='{{::customNoteText}}'></cv-please-note>
					</div>
		<p>{{modalOptions.bodyText}}</p>
		<div>
			<img ng-src="{{modalOptions.imgSrc}}" class="{{modalOptions.imgClass}}"></img>
		</div>
		<div>
			<p ng-bind-html="modalOptions.imgText"></p>
		</div>
		<div data-ng-if="modalOptions.additionalConfirm" class="inline-block">
			<cv-checkbox checkbox-model="modalOptions.confirmed" checkbox-label="label.additionalConfirm"></cv-checkbox>
		</div>
	</div>
	<div class="modal-footer">
		<button id="modal_button_#8229" type="button" class="btn btn-default" data-ng-click="modalOptions.close()"> 
	  		{{modalOptions.closeButtonText}}
  		</button>
  		<button id="modal_button_#6362" class="btn btn-primary cvBusyOnAjax" data-ng-click="modalOptions.ok();"  data-ng-disabled="(modalOptions.additionalConfirm ? !modalOptions.confirmed : false) || modalOptions.disableOkButton" data-ng-hide="modalOptions.hideOkButton"> 
  			{{modalOptions.actionButtonText}}
		</button>
	</div>
</div>