	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.frel"></cv:cvMessages>
	</script>

	<fmt:bundle basename="localization.servers">
		<div class="setup-title">
			<h1>{{modalTitle}}</h1>
		</div>
		<div class="setup-content collection">
			<%-- <span class="setupInfo"><fmt:message key="label.editInfo" /></span> --%>
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="editVcloudForm" novalidate data-cv-submit="editVCloud()" autocomplete="off">
				<div class="global-options remove-border-padding">
					<div data-ng-if="serverType=='VMW' && showAction=='showVcloud'">
					<label for="vcloudHostName"><fmt:message key="label.vCloudHostName" />
						<input type="text" name="vcloudHostName" id="vcloudHostName" data-ng-model="model.vcloudHostName" />
						<%-- <span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.vcloudHostName)"><fmt:message key="error.vcloudHostName" /></span> --%>
					</label>
					<label for="vcloudUserName"><fmt:message key="label.userName" />
						<input type="text" name="vcloudUserName" id="vcloudUserName" data-ng-model="model.vcloudUserName"/>
						<%-- <span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.vcloudUserName)"><fmt:message key="error.userName" /></span> --%>
					</label>
					<label for="vcloudPassword"><fmt:message key="label.password" />
						<input type="password" name="vcloudPassword" id="vcloudPassword" data-ng-model="model.vcloudPassword"/>
						<%-- <span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.vcloudPassword)"><fmt:message key="error.password" /></span> --%>
					</label>
					<label for="confirmVcloudPassword"><fmt:message key="label.confirmPassword" />
						<input type="password"  name="confirmVcloudPassword" id="confirmVcloudPassword" data-ng-model="model.confirmPassword"/>
						<!--
							The warning message logic for the confirm pw field below is as follows:
							If the field is blank AND the user has interacted with the field, show a required-field message
							If the field is not blank AND the field does not match the pw field AND the user has interacted with the field, show a does-not-match message
						-->
						<%-- <span class="help-block" data-ng-show="editVcloudForm.confirmVcloudPassword.$error.required && cv.editVcloudForm.needsAttention(editVcloudForm.confirmVcloudPassword)"><fmt:message key="error.confirmNewPassword" /></span> --%>
						<span class="help-block"
							data-ng-show="model.confirmPassword !== model.vcloudPassword"><fmt:message key="error.mismatchedPassword" /></span>
					</label></div>

					<div data-ng-if=" showAction=='showFREL'">
						<label><cv:msg key="label.fbrUnixMA" bundle="servers" />
							<div class="company-multi-select">
								<isteven-multi-select id="manageVcloudDetails_isteven-multi-select_#1244"
									input-model="fbrMAListUnix"
									output-model="model.selectedFbrMAUnix"
									button-label="mediaAgentName"
									item-label="mediaAgentName"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									name="fileRecovery"
									helper-elements="None"
									max-labels="1"
									translation="localLang"
									on-item-click="updateFBRMAUnix()">
								</isteven-multi-select>
							</div>
						</label>
						<div class="text-align-left margin-left-20 margin-top-10" data-ng-if="showFRELDeploy">
							<a href=""
								data-ng-click="startFRELWizard()">
								<cv-help-text  help-label="label.addNew" help-text="help.frelDeploy" class="cursor-pointer">
								</a>
						</div>
					</div>

					<div data-ng-if="showAction=='showMountProxy'">
						<label><cv:msg key="label.mountProxy" bundle="servers" />
							<div class="company-multi-select"><cv-select-proxy model="model" ctrl="ctrl" selection="single" vendor="{{serverType}}" id="proxy1" package-list="51" allow-empty="true">
							</cv-select-proxy></div>
						</label>
					</div>
					<div data-ng-if="isAppAwareEnabled && isAppAwareEnabledVendor && false">
					<%--Guest credentials --%>
					<h4 ><fmt:message key="label.guestCredentials" /></h4>
						<label for="guestCredentials">
							<cv:msg key="label.useGuestCredentials" bundle="servers"/>
							<toggle-control class="guestCredentials" status="model.guestCredentials" data-ng-click="manageCredentials('guest')"
									 title="<cv:msg key="label.useGuestCredentials" bundle="servers"/>"></toggle-control>
						</label>
						<!--Guest Credentials start  -->
					  <div data-ng-if ="model.guestCredentials === 'enabled-activity'">
						 <label for="guestUserName">
						    <cv:msg key="label.userName" bundle="serversJs"/>
						    <input type="text" name="guestUserName" data-ng-model="model.guestUserName" required data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.userName)}"/>
							<span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.guestUserName)">
							<fmt:message key="error.userName" />
							</span>
						  </label>
						   <label for="guestPasssword">
						    <cv:msg key="label.password" bundle="serversJs"/>
						    <input type="password" name="guestPasssword" data-ng-model="model.guestPassword" required data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.guestPasssword)}"/>
							<span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.guestPasssword)">
							<fmt:message key="error.password" /></span>
						  </label>
						   <label for="guestConfirmPasssword">
						    <cv:msg key="label.confirmPassword" bundle="serversJs"/>
						    <input type="password" name="guestConfirmPasssword" data-ng-model="model.guestConfirmPasssword" required data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.guestConfirmPasssword)}"/>
							<span class="help-block"
								data-ng-show="editVcloudForm.guestConfirmPasssword.$error.required && cv.editVcloudForm.needsAttention(editVcloudForm.guestConfirmPasssword)">
								<fmt:message key="error.confirmPassword" />
							</span>
						<%-- 	<span class="help-block"
								data-ng-show="!editVcloudForm.guestConfirmPasssword.$error.required && editVcloudForm.guestConfirmPasssword.$error.cvEquals && cv.editVcloudForm.needsAttention(editVcloudForm.guestConfirmPasssword)">
								<fmt:message key="error.mismatchedPassword" />
							</span> --%>
							<span class="help-block"
							data-ng-show="model.guestConfirmPasssword !== model.guestPassword"><fmt:message key="error.mismatchedPassword" /></span>
						  </label>
					 </div>
					 <%--Application credentials --%>
					 <div data-ng-if="isVsaSSHEnabled && isAppAwareEnabledVendor">
					 	<h4><fmt:message key="label.applicationCredentials" /></h4>
						   <label for="appCredentials">
								<cv:msg key="label.useApplicationCredentials" bundle="servers"/>
								<toggle-control class="appCredentials" status="model.appCredentials" data-ng-click="manageCredentials('app')"
										 title="<cv:msg key="label.useGuestCredentials" bundle="servers"/>"></toggle-control>
						  </label>
						  <!-- Application Credentials -->
						 <div data-ng-if ="model.appCredentials === 'enabled-activity'">
							   <label for="appUserName">
							    <cv:msg key="label.userName" bundle="serversJs"/>
							    <input type="text" name="appUserName" data-ng-model="model.appUserName" required data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.appUserName)}"/>
								 <span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.appUserName)"><fmt:message key="error.userName" /></span>
							  </label>
							   <label for="appPasssword">
							    <cv:msg key="label.password" bundle="serversJs"/>
							    <input type="password" name="appPasssword" data-ng-model="model.appPasssword" required data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.appPasssword)}"/>
								<span class="help-block" data-ng-show="cv.editVcloudForm.needsAttention(editVcloudForm.appPasssword)"><fmt:message key="error.password" /></span>
							  </label>
							   <label for="appConfirmPasssword">
							    <cv:msg key="label.confirmPassword" bundle="serversJs"/>
							    <input type="password" name="appConfirmPasssword" data-ng-model="model.appConfirmPasssword" required   data-ng-class="{'has-error':cv.editVcloudForm.needsAttention(editVcloudForm.appConfirmPasssword)}"/>
								<span class="help-block"
									data-ng-show="editVcloudForm.appConfirmPasssword.$error.required && cv.editVcloudForm.needsAttention(editVcloudForm.appConfirmPasssword)">
									<fmt:message key="error.confirmPassword" />
								</span>
								<%-- <span class="help-block"
									data-ng-show="!editVcloudForm.appConfirmPasssword.$error.required && editVcloudForm.appConfirmPasssword.$error.cvEquals && cv.editVcloudForm.needsAttention(editVcloudForm.appConfirmPasssword)">
									<fmt:message key="error.mismatchedPassword" />
								</span> --%>
								<span class="help-block"
							data-ng-show="model.appConfirmPasssword !== model.appPasssword"><fmt:message key="error.mismatchedPassword" /></span>
							  </label>
					   </div>
                       </div>
                       </div>
				</div>
				<div class="button-container">

					<fmt:bundle basename="localization.messages">
						<button id="manageVcloudDetails_button_#4808" type="button" class="btn btn-default" data-ng-click="cancel()"><fmt:message key="Cancel" /></button>
						<button id="manageVcloudDetails_button_#0784" type="submit" class="btn btn-primary" ><fmt:message key="Save" /></button>
					</fmt:bundle>
				</div>
			</form>
		</div>
	</fmt:bundle>
