<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editOptions" bundle="collectionsJs"/></h1>
</div>
<div class="setup-content collection">
	<div class="{{editOptionsServerMessage.type}} serverMessage">{{editOptionsServerMessage.message}}</div>
	<form name="editOptionsForm" data-cv-submit="saveOptions()" novalidate autocomplete="off" > <!-- class="schedules-form" -->
		<!-- // scrolling div start // -->
		<div>
			<!-- autodetect vm owner ends -->
			<!-- // No. of readers starts // -->
			<div class="modal-wrapper">
				<label for="noOfReaders" class="label"><cv:msg key="label.noOfReaders" bundle="collectionsJs"/></label>
				<div class="inline-wrapper larger-width">
					<input id="noOfReaders" required name="noOfReaders" type="number" min="1" max="50" data-ng-model="noOfReaders"  />
					<span class="help-block" data-ng-show="cv.editOptionsForm.needsAttention(editOptionsForm.noOfReaders)"><cv:msg key="error.readers" bundle="collections"/></span>
				</div>
			</div>
			<!-- // No. of readers ends // -->
			

           <!-- give spacing -->
           <div> &nbsp </div>
			
			<!-- // Virtual Machine Backup Type starts // -->
			<div class="modal-wrapper" data-ng-if="(!isMeditechSystem) && (showVMBackupType()||(showAppaware() && isAppAwareEnabled))">
				<label for="btAppConsistent" class="label"><cv:msg key="label.vmBackupType" bundle="collectionsJs"/></label>
				<div class="inline-wrapper full-width" data-ng-class="{'topMargin':showAppaware()}">
					<div class="frequency ">
					<input  data-ng-if="showAppaware()" type="checkbox" name="btAppAware" id="btAppAware" data-ng-model="fieldData.isAppawareBackUp" />
					<label for="btAppAware" class="tight-line-height" data-ng-if="isAppAwareEnabled && isAppAwareEnabledVendor">
					 <input data-ng-if="!showAppaware()" id="btAppAware" type="radio" name="backupType" value="AppAware" data-ng-model="fieldData.backupType"  value="AppAware" />
						<span class="hanging-indent"><cv:msg bundle="collectionsJs" key="label.appAware"/>
						
						 <a  data-ng-if="(fieldData.backupType=='AppAware'||fieldData.isAppawareBackUp)" class="credential-edit"  title='  <cv:msg key="label.editCredentials" bundle="collectionsJs" />' href=""  data-ng-click="editAppCredentials()" >
						 <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="svg-primary-fill" >
                             <path d="M12.65 10C11.83 7.67 9.61 6 7 6c-3.31 0-6 2.69-6 6s2.69 6 6 6c2.61 0 4.83-1.67 5.65-4H17v4h4v-4h2v-4H12.65zM7 14c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/>
                           </svg> 
                       <!-- <i class="glyphicon glyphicon-pencil"></i> -->
		                                </a>
						
						<br/>
						<span class="smaller-text"><cv:msg bundle="collectionsJs" key="label.appAwareExt"/>
						
						</span></span>
						</label>
                   <div data-ng-if="!showAppaware()">
						<label for="btAppConsistent" class="tight-line-height"><input id="btAppConsistent" type="radio" name=backupType value="APP"
							data-ng-model="fieldData.backupType" />
								<span  class="hanging-indent"><div data-ng-bind-html="appConsistent"></div>
								<span class="smaller-text">{{appConsistentExt}}</span></span>
								
						</label>
						
						
						<label for="btCrashConsistent" class="tight-line-height"><input id="btCrashConsistent" type="radio" name="backupType" value="CRASH"
							data-ng-model="fieldData.backupType" />
						  <span  class="hanging-indent">{{crashConsistent}}<br />
								<span class="smaller-text">{{crashConsistentExt}}</span></span>
						</label>
						
						<label for="btVmCheckpoint" class="tight-line-height" data-ng-if="showVmCheckPointSetting">
					      <input  id="btVmCheckpoint" type="radio" name="backupType" value="VmCheckpoint" data-ng-model="fieldData.backupType"  value="VmCheckpoint" />
						<span class="hanging-indent"><cv:msg bundle="collectionsJs" key="label.VmCheckpointSetting"/><br />
						<span class="smaller-text"><cv:msg bundle="collectionsJs" key="label.VmCheckpointSettingExt"/></span>
						
						</span>
						</label>
						
						
						</div>
					</div>
				</div>
			</div>
			<!-- // Virtual Machine Backup Type ends // -->
           <!-- give spacing -->
           <div> &nbsp </div>
          
			<!-- // Transport Mode for VMWare starts // -->
			
			<div class="modal-wrapper"  data-ng-if="vendor&& (vendor=='VMW' || vendor=='VCLOUD')">
				<label class="label col-sm-5" for="transportMode" ><cv:msg key="label.transportMode" bundle="collectionsJs"/>   </label>
				<div class="col-sm-6">
					<isteven-multi-select
						input-model="transportModeTypes"
						output-model="transportMode.type"
						button-label="name"
						item-label="name"
						tick-property="selected"
						helper-elements="none"
						hide-search-button="true"
						class="isteven-multi-select user-group-select"
						id="transportMode"
						name="transportMode"
						selection-mode="single"
						max-labels="1"
						disable-property="disabled"
						group-property="msGroup">
					</isteven-multi-select>
				</div>
			</div>
		<%-- 	<label data-ng-if="vendor&& vendor=='VMW'"  for="transportMode" class="select-label"><cv:msg key="label.transportMode" bundle="collectionsJs"/>
				<select name="transportMode" id="transportMode" data-ng-options="transportMd.value as transportMd.name for transportMd in transportModeTypes" data-ng-model="transportMode.type" >
				</select>
			</label> --%>
			<!-- // Transport Mode for VMWare ends // -->
			<!-- // Datastore freespace starts // -->
			<div class="modal-wrapper datastoreFreespace" data-ng-if="isFreespaceCheckEditable() && isFreespaceCheckApplicable()" >
				<toggle-control data-ng-click="toggleDatastoreFreespaceCheckCB()" status="datastoreFreespaceCheckStatus" name="datastoreFreespaceCheckCB" id="datastoreFreespaceCheckCB" ></toggle-control>
				<label class="checkbox-label" for="datastoreFreespaceCheckCB"><cv:msg key="label.datastoreFreespaceCheck" bundle="collectionsJs"/></label>
			</div>
			
			
			<div data-ng-if="isFreespaceCheckEditable() && isFreespaceCheckEnabled()" class="modal-wrapper">
				<label for="datastoreFreespaceRequired" class="label"><cv:msg key="label.datastoreFreespaceRequired" bundle="collectionsJs"/></label>
				<div class="inline-wrapper larger-width">
					<input data-ng-disabled="!isFreespaceCheckEnabled()" id="datastoreFreespaceRequired" name="datastoreFreespaceRequired" type="number" min="1" max="100" data-ng-model="fieldData.datastoreFreespaceRequired" /> %
					<span class="help-block" data-ng-show="cv.editOptionsForm.needsAttention(editOptionsForm.datastoreFreespaceRequired)"><cv:msg key="error.freespaceCheck" bundle="collections"/></span>
				</div>
			</div>
			<!-- // Datastore freespace ends // -->
			<div class="button-container">
					<button id="manageOptionsModal_button_#4539" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="collectionsJs"/></button> 
					<button id="manageOptionsModal_button_#5307" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="collectionsJs"/></button> 
			</div>
		</div><!-- // end scrolling div // -->
	</form>
</div>
