
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.job"></cv:cvMessages>
<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div  data-ng-controller="addCollectionController" data-ng-init="initializeFormId('manageCollectionContentForm')">
		<div class="setup-title">
			<h1>{{headerText}}</h1>
		</div>
		<div class="setup-content"><%-- !!! user-edit-content should be replaced with a generic equivalent --%>
			<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="addCollectionForm" novalidate cv-submit="modifyCollectionContent()" autocomplete="off" class="add-collection-form edit-users-grid-form"><%-- !!! edit-users-grid-form should be replaced with a generic equivalent --%>
				<div data-ng-if="isVMDiscoveryServerGroup">
					<label for="serverList" class="select-label add-server"><cv:msg key="label.server" bundle="subscriptions"/>
						<select name="serverList" data-ng-options="server.clientId as server.name for server in VMDiscovery.serverList | orderBy: 'name'" data-ng-model="VMDiscovery.serverId" required
							data-ng-change="changeDiscoveryByServer()">
						</select>
					</label>
				</div>
				<div class="setup-content user-edit-content">
					<div data-ng-if="!isVMDiscoveryServerGroup">
						<cv-tabset-component control="tabControls" data-ng-class="{'hide-tabs': hideTabs}">
							<!-- CONTENT TAB -->
							<cv-tab tabname='<cv:msg key="header.content" bundle="collections"/>'>
								<div data-ng-if="!appGroupCreationEligible">
									<cv-add-vm-content-directive data-ng-if="loaded"  vendor="serverType" 
										selected-content="true" client-id="scId" ctrl="ctrl">
									</cv-add-vm-content-directive>
								</div>
								<centre data-ng-if="!loaded">
									<cv:msg key="Loading" bundle="subscriptions"/>
								</centre>
								<div data-ng-show="appGroupCreationEligible && loaded">
									<cv-grid cv-grid-options="contentGridOptions"></cv-grid>
									<div class="horizontal-button-container bottom">
				 						<ul>
											<li class="horizontal-link-button"><a href="" data-ng-click="openSelectVmsDialog(false)"><span>{{selectionCollectionContentLabel}}</span></a></li>
											<li class="horizontal-link-button"><a href="" data-ng-click="openAddRuleDialog(false)"><span>{{addRuleLabel}}</span></a></li>
										</ul>
									</div>
								</div>
							</cv-tab>
							<!-- FILTERS TAB -->
							<cv-tab tabname='<cv:msg key="header.filters" bundle="collections"/>' data-ng-if="vendor && vendor!=='ORACLE_CLOUD'">
								<cv-grid data-ng-if="loaded" cv-grid-options="filterGridOptions"></cv-grid>
								<div class="horizontal-button-container bottom">
			 						<ul>
										<li class="horizontal-link-button"><a href="" data-ng-click="openSelectVmsDialog(true)"><span>{{selectionCollectionContentLabel}}</span></a></li>
										<li data-ng-if="vendor && vendor!=='KUBERNETES'" class="horizontal-link-button"><a href="" data-ng-click="openAddRuleDialog(true)"><cv:msg key="label.addFilterRule" bundle="collectionsJs" /></a></li>
									</ul>
								</div>
							</cv-tab>
							<!-- DISK FILTERS TAB -->
							<cv-tab tabname='{{diskFilterLabel()}}' data-ng-if="showDiskFilters()" >
								<cv-grid data-ng-if="loaded" cv-grid-options="diskFilterGridOptions"></cv-grid>
								<div class="horizontal-button-container bottom" >
			 						<ul>
										<li class="horizontal-link-button"><a href="" data-ng-click="openAddDiskFilterDialog()"><span data-ng-if="vendor && vendor==='AMAZON'"><cv:msg key="label.addVolumeFilter" bundle="collectionsJs" /></span><span data-ng-if="!vendor || (vendor && vendor!=='AMAZON')"><cv:msg key="label.addDiskFilter" bundle="collectionsJs" /></span></a></li>
									</ul>
								</div>
							</cv-tab>
						</cv-tabset-component>
					</div>
					<div data-ng-if="isVMDiscoveryServerGroup" class="flex-column min-height-450">
						<div data-ng-if="vmAssociationContent && vmAssociationContent.length > 1" class="margin-bottom-10">
							<label for="ruleMatch"><cv:msg key="label.matchCriteria" bundle="clients"></cv:msg>
								<cv-radio-group radio-name="ruleMatch" radio-model="vmAssociationRules.matchCriteria" radio-obj="vmAssociationRules.matchCriteriaList" class="float-right width-60-percentage" on-click="onRuleMatchingRadioChange(data)"></cv-radio-group>
							</label>
						</div>
						<span class="server-message error" data-ng-if="vmAssociationRuleError" data-ng-bind="vmAssociationRuleError"></span>
						<ul data-ng-if="loaded && vmAssociationContent.length > 0" class="margin-left-10 text-left list-style__row flex-grow">
							<li data-ng-repeat="rule in vmAssociationContent" class="cv-flex space-between vsaColumnIcon vsaIcon{{rule.icon}}">
								<a href="" ng-if="isRuleEditable(rule, null, vendor)" data-ng-click="editExistingContent(false, rule)" data-ng-bind="rule.readableRule"></a>
								<span ng-if="!isRuleEditable(rule, null, vendor)" data-ng-bind="rule.readableRule"></span>
								<span class="delete-row margin-right-10" data-ng-if="vmAssociationContent.length>1">
									<a href="" data-ng-click="removeContent(rule)" title="Remove"><span class="k-icon k-i-close"></span></a>
								</span>
							</li>
						</ul>
						<div class="flex-grow margin-top-20 color-dark-gray" data-ng-if="loaded && (!vmAssociationContent || vmAssociationContent.length === 0)" data-ng-bind="emptyContentLabel"></div>
						<div class="horizontal-button-container bottom margin-top-30">
		 					<ul>
								<li class="horizontal-link-button"><a href="" data-ng-click="openAddRuleDialog(false)"><span>{{addRuleLabel}}</span></a></li>
								<li class="horizontal-link-button"><a href="" data-ng-click="openSelectVmsDialog(false)"><span>{{selectionCollectionContentLabel}}</span></a></li>
							</ul>
						</div>
					</div>
					<div class="button-container">
						<fmt:bundle basename="localization.messages">
							<button id="manageCollectionContentModal_button_#7675" type="button" class="float-left btn btn-primary" data-ng-click="openPreviewDialog()"><cv:msg key="label.preview" bundle="collectionsJs"/></button> 
					  		<button id="manageCollectionContentModal_button_#2412" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelModifyCollectionContent()"><fmt:message key="Cancel" /></button> 
					  		<button id="manageCollectionContentModal_button_#0494" type="submit" class="btn btn-primary cvBusyOnAjax" ><fmt:message key="OK" /></button> 
					  	</fmt:bundle>
					</div>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>
