<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div id="restoreNetworkInterface" data-ng-if="gcNetworkCtrl.isReplicationTarget">
	<div>
		<label class="col-xs-12 col-md-5 col-lg-5" for="networkInterface">
			<cv:msg key="label.networkInterface" bundle="restore"/>
		</label>
		<div class="col-xs-12 col-md-7 col-lg-7">
			<div class="input-group">
				<input type="text" readonly name="networkInterface" id="networkInterface" value="{{gcNetworkCtrl.getNetworkInterface()}}" data-ng-required="true"/>
				<span class="input-group-btn">
					<button id="googleCloudNetwork_restore_button" type="button" data-ng-click="gcNetworkCtrl.openNetworkInterfaceDialog(nic)" class="btn btn-default browse-btn">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
				</span>
			</div>
			<span class="help-block" data-ng-show="gcNetworkCtrl.emptyForCrossRestore"> <cv:msg key="error.selectNIC" bundle="restore"/>
			</span>
		</div>
	</div>
</div>
<div id="restoreNetworkInterface" data-ng-if="!gcNetworkCtrl.isReplicationTarget">
	<div data-ng-if="gcNetworkCtrl.crossRestore">
	<div class="col-xs-12">
		<div class="input-group">
			<label for="networkInterface">
				<cv:msg key="label.networkInterface" bundle="restore"/>
				<input type="text" readonly name="networkInterface" id="networkInterface" value="{{gcNetworkCtrl.restoreData.vmOptions.nics[0].name}}\{{gcNetworkCtrl.restoreData.vmOptions.nics[0].subnet}}" data-ng-required="true"/>
				<span class="help-block" data-ng-show="gcNetworkCtrl.emptyForCrossRestore">
					<cv:msg key="error.selectNIC" bundle="restore"/>
				</span>
			</label>
				<span class="input-group-btn">
					<button id="googleCloudNetwork_restore_button" type="button" data-ng-click="gcNetworkCtrl.openNetworkInterfaceDialog(nic)" class="btn btn-default browse-btn">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
				</span>
		</div>
	</div>
	</div>

	<div data-ng-if="!gcNetworkCtrl.crossRestore" data-ng-repeat="nic in gcNetworkCtrl.restoreData.vmOptions.nics">
		<div class="col-xs-12">
			<div class="input-group">
				<label for="networkInterface">
					<cv:msg key="label.networkInterface" bundle="restore"/>
					<input type="text" readonly name="networkInterface" id="networkInterface" value="{{nic.name}}\{{nic.subnet}}" data-ng-required="true"/>
					<span class="help-block" data-ng-show="nic.showError">
						<cv:msg key="error.duplicateNICSelected" bundle="restore"/>
					</span>
					<span class="help-block" data-ng-show="nic.empty">
						<cv:msg key="error.selectNIC" bundle="restore"/>
					</span>
				</label>
				<span class="input-group-btn">
					<button id="googleCloudNetwork_button_#9298" type="button" data-ng-click="gcNetworkCtrl.openNetworkInterfaceDialog(nic)" class="btn btn-default browse-btn"> 
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
				</span>
			</div>
		</div>
	</div>
</div>
