<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.frel"></cv:cvMessages>
</script>


<div class="bootstrap-wrapper no-padding form-horizontal" id="divFrelStepOne">

	<!--	server Message - START -->
	<div class="form-group" data-ng-if="localDataObject.serverMessage.message" id="divServerMessage">
		<div class="col-xs-12">
			<span class="{{localDataObject.serverMessage.type}}" data-ng-bind-html="localDataObject.serverMessage.message"></span>
		</div>
	</div>
	<!--	server Message - END -->


	<!--	All controls - START -->
	<div id="divAllControls">


			<!--	VM Name - START -->
			<div class="form-group" id="divVMName">
				<label for="vmName" class="col-md-3">
				<cv:msg key="label.vmName" bundle="frel" />
				</label>
				<div class="col-md-9">
					<input type="text" autofocus name="vmName" data-ng-model="model.vmName" id="vmName" name="vmName"  maxlength="100" data-ng-pattern="model.alphanumeric" required
					placeholder="<cv:msg key="label.vmName" bundle="frel" />" />
					<span class="help-block" data-ng-show="frelDeployForm.vmName.$dirty && frelDeployForm.vmName.$error.required"><cv:msg key="error.vmName" bundle="frel" /></span>
					<span class="help-block" data-ng-show="frelDeployForm.vmName.$dirty && frelDeployForm.vmName.$error.maxlength"><cv:msg key="error.maxLength" bundle="frel" /></span>
					<span class="help-block" data-ng-show="frelDeployForm.vmName.$dirty && frelDeployForm.vmName.$error.pattern"><cv:msg key="error.alphanumeric" bundle="frel" /></span>
				</div>
			</div>
			<!--	VM Name - END -->


			<!--	Hypervisor Name - START -->
			<div class="form-group margin-bottom-20" id="divHypervisorName">
				<div class="col-md-3" >
					<cv:msg key="label.hypervisorName" bundle="frel"/>
				</div>
				<div class="col-md-9">
					<span data-ng-bind="localDataObject.browseCollection.serverName" ></span>
			  	</div>
			</div>
			<!--	Hypervisor Name - END -->


			<!--	Label destination - START -->
			<div class="form-group col-md-12" id="divSelectLocation">
				<cv:msg key="label.selectLocation" bundle="frel"/>
			</div>
			<!--	Label destination - END -->


			<!--	Browse component - START -->
			<div class="col-md-12 browseTreeScrollbarOverride padding-0" id="divBrowseLocation" data-ng-if="model.isStepOneLoaded">
				<cv-browse-collection-content
					selected-content='model.selectedDestinationLocation.selectedContent'
					server-id="localDataObject.browseCollection.clientId"
					initial-content-browse-view-path='\NONE:VMs'
					hide-grouping="true"
					strict-single-selection-mode="true"
					filter-specific-types="VM"
					hide-search="true"
					error-on-empty-selection="true"
					selectable-types="FOLDER"
					selection-error-str="<cv:msg key="error.selectLocation" bundle="frel" />"
					id="destinationLocation" >
				</cv-browse-collection-content>
			</div>
			<!--	Browse component - END -->



	</div>
	<!--	All controls - END -->

	<!--	Buttons - START -->
	<div class="cv-wizard-default-actions row" id="divButtons">
		<div class="col-xs-12 no-padding ">
			<div class="col-md-2">
	        	<cv-wizard-button data-cv-type="cancel">
	            </cv-wizard-button>
	        </div>
	        <div class="col-md-2  col-md-offset-8">
	            <cv-wizard-button data-cv-type="next"
	            data-cv-disabled="frelDeployForm.vmName.$error.required || frelDeployForm.vmName.$error.maxlength || !model.vCenter ||
	            frelDeployForm.vmName.$error.pattern || model.selectedDestinationLocation.selectedContent.length == 0">
	            </cv-wizard-button>
	        </div>
        </div>
	</div>
	<!--	Buttons - END -->

</div>
