<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.editPlan" bundle="profiles"/></h1>
	</div>
</div>
<div class="setup-content user-edit-content">
	<span class="{{editPlanMessage.type}} serverMessage">{{editPlanMessage.message}}</span>
	<form  name="editPlanForm" novalidate cv-submit="savePlanForCompany()" autocomplete="off" class="edit-plan-grid-container">
		<div data-ng-if="!availablePlnas">
			<uib-accordion close-others="true" class="text-left" >
				<div uib-accordion-group is-open="status.plans" data-ng-show="!isTAdmin || (isReseller && isNotEditingOwnCompany)">
						<uib-accordion-heading>
							<i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': status.plans, 'glyphicon-chevron-right': !status.plans}"></i>
							<cv:msg key="label.profiles" bundle="profiles"/>
						</uib-accordion-heading>
						<cv-grid cv-grid-options="gridOptions"></cv-grid>
				</div>
				<div class='addServerModal editPlanForCompanyModal'  uib-accordion-group is-open="status.defaultPlans">
						<uib-accordion-heading>
							<i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': status.defaultPlans, 'glyphicon-chevron-right': !status.defaultPlans}"></i>
							<cv:msg key="label.defaultPlans" bundle="profiles"/>
						</uib-accordion-heading>
					<div class="cv-modal-wrapper" data-ng-if="selectedServerPlan.length > 0">
						<label class="cv-label"><cv:msg key="label.serverPlan" bundle="profiles" /></label>
						<div class="cv-inline-wrapper">
							<div class="padding-right-20">
								<cv-plan-summary-dropdown
									input-model="selectedServerPlan"
									output-model="defaultServer"
									item-label="'planName'"
									button-label="'planName'"
									tick-property="'selected'"
									max-labels="1"
									show-none="true"
									selection-mode="'single'"
									directive-id="serverDefault"
									helper-elements="'none'"
									on-item-clicked="getPlan(defaultServer[0], 'Server')">
								</cv-plan-summary-dropdown>
							</div>
						</div>
					</div>

					<div class="cv-modal-wrapper" data-ng-if="selectedFsPlan.length > 0">
						<label class="cv-label"><cv:msg key="label.fsPlan" bundle="profiles" /></label>
						<div class="cv-inline-wrapper">
							<div class="padding-right-20">
								<cv-plan-summary-dropdown
									input-model="selectedFsPlan"
									output-model="defaultFs"
									item-label="'planName'"
									button-label="'planName'"
									tick-property="'selected'"
									max-labels="1"
									show-none="true"
									translation="localLang"
									selection-mode="'single'"
									directive-id="FSServerDefault"
									helper-elements="'none'"
									on-item-clicked="getPlan(defaultFs[0], 'FSServer')">
								</cv-plan-summary-dropdown>
							</div>
						</div>
					</div>
					<div class="cv-modal-wrapper" data-ng-if="selectedDbPlan.length > 0">
						<label class="cv-label"><cv:msg key="label.dbPlan" bundle="profiles" /></label>
						<div class="cv-inline-wrapper">
							<div class="padding-right-20">
								<cv-plan-summary-dropdown
									input-model="selectedDbPlan"
									output-model="defaultDb"
									item-label="'planName'"
									button-label="'planName'"
									tick-property="'selected'"
									max-labels="1"
									show-none="true"
									translation="localLang"
									selection-mode="'single'"
									directive-id="databaseDefault"
									helper-elements="'none'"
									on-item-clicked="getPlan(defaultDb[0], 'Database')">
								</cv-plan-summary-dropdown>
							</div>
						</div>
					</div>
					
					<div class="cv-modal-wrapper" data-ng-if="selectedLaptopPlan.length > 0">
						<label class="cv-label"><cv:msg key="label.laptopPlan" bundle="profiles" /></label>
						<div class="cv-inline-wrapper">
							<div class="padding-right-20">
								<cv-plan-summary-dropdown
									input-model="selectedLaptopPlan"
									output-model="defaultLaptop"
									item-label="'planName'"
									button-label="'planName'"
									tick-property="'selected'"
									max-labels="1"
									show-none="true"
									translation="localLang"
									selection-mode="'single'"
									directive-id="LaptopDefault"
									helper-elements="'none'"
									on-item-clicked="getPlan(defaultLaptop[0], 'Laptop')">
								</cv-plan-summary-dropdown>
							</div>
						</div>
					</div>
					<div data-ng-if="showAlwaysActivateLaptop && defaultLaptop && defaultLaptop.length > 0 && defaultLaptop[0].planId !== -1" class="form-group enable-extended-retention-area padding-left-20">
						 <toggle-control class="extended-retention-toggle alwaysActivateWithDefaultPlanToggle" status="alwaysActivateWithDefaultPlanToggle" data-ng-click="toggleActivateWithDefaultPlan()"></toggle-control>
						<label class="extended-retention-label"><cv-help-text help-label="label.alwaysActivateDefaultPlan" help-text="label.alwaysActivateDefaultPlan.helpText"/></label>
					</div>
				</div>
			</uib-accordion>
			<div data-ng-if="showDonotAskMeOption" class="padding-top-10">
				<input type="checkbox" name="doNotAskMeAgain" id="doNotAskMeAgain" data-ng-model="doNotAskMeAgainBoolean" data-ng-click="modifyDoNotAskMeAgainBoolean()"class="ng-pristine ng-untouched ng-valid">
				<label class="checkbox-label" for="doNotAskMeAgain"><cv-help-text help-label="label.doNotAskMeAgain" help-text="label.doNotAskMeAgainToolTip" use-icon=true/>
				</label>
			</div>
		</div>

		<div class="button-container padding-top-10">
			  	<button id="editPlanForCompany_button_#5039" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="subscriptions" /></button>
			  	<button id="editPlanForCompany_button_#5401" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="plans.length>0"><cv:msg key="action.save" bundle="subscriptions" /></button>
		</div>
	</form>
</div>
