<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.editSites" bundle="subscriptions"/></h1>
	</div>
</div>
<div class="setup-content remove-top-padding server-plan smaller-inputs">
	<span class="{{editDomainMessage.type}} serverMessage">{{editDomainMessage.message}}</span>
	<form  name="editDomainForm" novalidate cv-submit="saveDomainForCompany()" autocomplete="off" class="">
		<div class="global-options remove-border-padding ">
			<label data-ng-if="!tenantAdmin || (isReseller && isNotOwnCompany)" for="primaryDomainName"><cv:msg key="label.primarySiteName" bundle="subscriptions" />
					<input class="margin-right-20" type="text" name="primaryDomainName" id="primaryDomainName" data-ng-model="model.primaryDomainName"  data-ng-pattern="domainRegex"/>
					<span class="help-block" data-ng-show="cv.editDomainForm.needsAttention(editDomainForm.primaryDomainName)"><cv:msg key="error.domainName" bundle="users" /></span>
			</label>
		</div>
		<label class = "margin-top-10" for="secondaryDomainName"><cv:msg key="label.secondarySite" bundle="subscriptions" />
		<a id="secondaryDomainName" class="float-right margin-right-20" data-ng-click="addSecondaryDomain()" href="javascript:void(0);"><cv:msg key="label.addAdditionalSite" bundle="subscriptions"/></a>
		</label>
		
		<div data-ng-if="model.additionalDomainList.length > 0" class="limit-modal-height min-height-60">
			<ul class="users-list__user padding-5" data-ng-repeat="domain in model.additionalDomainList track by $index">
				<li>
					<label for="{{domain.id}}">
							<cv:msg key="label.siteName" bundle="users" /> {{$index + 1}}
							<span class="delete-row line-height-2"><a href="javascript:void(0);" data-ng-click="removeDomain(domain)" title="<cv:msg key='label.removeContent' bundle='collectionsJs'/>"></a></span>
							<input type="text" name="{{domain.id}}" id="{{domain.id}}" data-ng-model="domain.value" required data-ng-pattern="domainRegex" />
							<span class="help-block" data-ng-show="!domain.value && cv.editDomainForm.needsAttention(editDomainForm.{{domain.id}})"><cv:msg key="error.domainName" bundle="users" /> or <a href="javascript:void(0);" data-ng-click="removeDomain(domain)" class="lower-case"><cv:msg key='label.removeContent' bundle='collectionsJs'/></a></span>
					</label>
				</li>
			</ul>
		</div>
		<span class="empty-message info-place-holder" data-ng-if="model.additionalDomainList.length === 0"><cv:msg key="info.noSecondarySite" bundle="subscriptions" /></span>
		<div class="button-container">
		  		<button id="editDomainForCompany_button_#8381" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="subscriptions" /></button> 
		  		<button id="editDomainForCompany_button_#0914" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="subscriptions" /></button> 
		</div>
	</form>
</div>
