<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
<cv:cvEnum name="BlockReplication.BlockReplicationStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BlockReplicationBootStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BLRRecoveryType"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BlrRestorePointType"></cv:cvEnum>
<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
		<h1>{{bootTypeLabel}}</h1>
</div>
<fmt:bundle basename="localization.blrJs">
<div class="setup-content bootstrap-wrapper">
<span class="{{serverMessage.type}} serverMessage"
		data-ng-bind="serverMessage.message"></span>
	<div class="text-center"
			data-ng-show="!bootModalData.showBootModal">
			<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
	</div>
	<form name="createBootForm" novalidate autocomplete="off" id="createBootForm" data-cv-submit="saveData(this)" class="form-horizontal" data-ng-show="bootModalData.showBootModal">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" ng-if="bootModalData.errMsg"><div class="col-md-9 col-lg-9 col-md-offset-3 col-lg-offset-3"  style="text-align:center;" ><span class="help-block">{{bootModalData.errMsg}}</span></div></div>
				<div class="form-group" data-ng-if="!isFailover">
				     <label class="col-xs-12 col-md-5 col-lg-5" for="newVMName"><cv:msg key="label.vmName" bundle="blrJs"/></label>
				     <div class="col-xs-12 col-md-7 col-lg-7">
				            <input type="text" data-ng-maxlength="50" id="newVMName" name="newVMName" data-ng-model="bootModalData.newVMName" required ng-class="{'has-error': cv.createBootForm.needsAttention(createBootForm.newVMName)}"/>
				     </div>
				     <div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
								<span class="help-block" ng-show="createBootForm.newVMName.$error.required && cv.createBootForm.needsAttention(createBootForm.newVMName)">
									<fmt:message key="error.vmname"/>
								</span>
								<span class="help-block" ng-show="createBootForm.newVMName.$error.maxlength && cv.createBootForm.needsAttention(createBootForm.newVMName)">
									<fmt:message key="error.vmname.length" />
								</span>
				 	</div>
				 </div>
				 <div class="form-group" data-ng-show="bootModalData.bootType==='test'">
					<label class="col-xs-12 col-md-5 col-lg-5" for="days"><cv:msg key="label.vmExpiryTime" bundle="blrJs"/></label>
					<div class="col-xs-12 col-md-3 col-lg-3">
						<input type="number" data-ng-model="bootModalData.days" min="0" max="30"  data-ng-maxlength="2"  id="days" name="days" required ng-class="{'has-error': cv.createBootForm.needsAttention(createBootForm.days)}"/> <label class="inline-label" for="days"><cv:msg key="label.days" bundle="blrJs"/></label>
					</div>
					<div class="col-xs-12 col-md-4 col-lg-4">
						<input type="number" data-ng-model="bootModalData.hours" min="0" max="23"  data-ng-maxlength="2"  id="hours" name="hours" required ng-class="{'has-error': cv.createBootForm.needsAttention(createBootForm.hours)}" /> <label class="inline-label" for="hours"><cv:msg key="label.hours" bundle="blrJs"/></label>
					</div>
					<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" ng-show="createBootForm.days.$invalid && cv.createBootForm.needsAttention(createBootForm.days)">
									<fmt:message key="error.expiryDays.invalid" />
						</span>
						<span class="help-block" ng-show="createBootForm.hours.$invalid && cv.createBootForm.needsAttention(createBootForm.hours)">
									<fmt:message key="error.expiryHours.invalid" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="showRecoveryTypeSelect">
					<label class="col-xs-12 col-md-5 col-lg-5" for="days"><cv:msg key="label.recoverFrom" bundle="blrJs"/></label>
				    <div class="col-xs-12 col-md-7 col-lg-7 ">
				        <select name="recoveryType" data-ng-model="bootModalData.recoveryType" data-ng-change="setOptions()">
								<option value="latest" title="<fmt:message key="label.latestPointInTime" />"><fmt:message key="label.latestPointInTime"  /></option>
								<option value="latestRP" data-ng-if="!hideLatestRPOption" title="<fmt:message key="label.latestRP" />"><fmt:message key="label.latestRP"  /></option>
								<option value="GRAPH" data-ng-if="(bootModalData.rpsMap !== null)"><fmt:message key="label.selectFromGraph" /></option>
								<option  value="SNAP"  title="<fmt:message key="label.snapshotTime" />" data-ng-if="SNAP"><fmt:message key="label.snapshotTime" /></option>
								<option value="CRASH"  title="<fmt:message key="label.crashConsistentRPT" />" data-ng-if="CRASH"><fmt:message key="label.crashConsistentRPT" /></option>
								<option value="APP"    title="<fmt:message key="label.appConsistentRPT" />" data-ng-if="APP"><fmt:message key="label.appConsistentRPT" /></option>
				        </select>
					</div>
				</div>
				<div data-ng-if="showCustomNote">
					<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='{{::customNoteText}}'></cv-please-note>
				</div>
				<div class="form-group" data-ng-if="showInfoMsg">
					<label class="col-xs-12"><span data-ng-bind="infoMsg" /></label>
				</div>
				<div class="form-group" data-ng-hide="(bootModalData.recoveryType=='latestRP')||(bootModalData.recoveryType=='latest')||(bootModalData.recoveryType=='GRAPH')">
					<label class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.selectRestorePoint" bundle="blrJs"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7 ">
				        <select id="snapshotTimeDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in SNAP" data-ng-model="bootModalData.selectedSnapRP" data-ng-if="bootModalData.recoveryType=='SNAP'" data-ng-change="bootModalData.selectPointOnGraph(bootModalData.selectedSnapRP)"></select>
				        <select id="crashConsistentRPTDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in CRASH" data-ng-model="bootModalData.selectedCrashRP" data-ng-if="bootModalData.recoveryType=='CRASH'" data-ng-change="bootModalData.selectPointOnGraph(bootModalData.selectedCrashRP)"></select>
				        <select id="appConsistentRPTDetailDate" data-ng-options="((timeStamp*1000)|date:'medium') for timeStamp in  APP" data-ng-model="bootModalData.selectedAppRP"  data-ng-if="bootModalData.recoveryType=='APP'" data-ng-change="bootModalData.selectPointOnGraph(bootModalData.selectedAppRP)"></select>
					</div>
				</div>
				<cv-blr-rp-graph boot-modal-data="bootModalData" blr-chart-config="blrChartConfig"></cv-blr-rp-graph>
				<cv-blr-network data-ng-if="!hideBLRNetwork" hypervisor-id="row.destClientId" error-model="error" override-data="overrideData">
				</cv-blr-network>
			</div>
		</div>
		<div class="modal-footer">
			<fmt:bundle basename="localization.messages">
				<button id="createBootModal_button_#8741" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				<button id="createBootModal_button_#3916"  type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Submit" /></button>
			</fmt:bundle>
		</div>
		</div>
	</form>
</div>
</fmt:bundle>