<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvEnum name="CvEntities.VMAllocationPolicyType"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<div class="bootstrap-wrapper">
	<div class="panel panel-default setup-panel">
		<span data-ng-if="serverMessage" class="text-center col-xs-12 server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
		<div class="collectMetaDiv text-center"><span data-ng-if="missingShape"  class="col-xs-12 server-message {{missingShape.type}}">{{missingShape.message}}</span></div>
		<div class="collectMetaDiv text-center"><span data-ng-if="missingGuestCredentials"  class="col-xs-12 server-message {{missingGuestCredentials.type}}">{{missingGuestCredentials.message}}</span></div>
		<div class="collectMetaDiv text-center"><span data-ng-if= "missingGuestCredentialsDetail" class="col-xs-12 server-message {{missingGuestCredentialsDetail.type}}">{{missingGuestCredentialsDetail.message}}</span></div>
		<div class="collectMetaDiv text-center"><span data-ng-if="errorMsg"  class="col-xs-12 server-message {{errorMsg.type}}">{{errorMsg.message}}</span></div>
		<div class="collectMetaDiv text-center"><span data-ng-if="serverMsg"  class="col-xs-12 server-message {{serverMessage.type}}">{{serverMsg.message}}</span></div>
		<p class="collectMetaDiv text-center" data-ng-if="!replicationGroup.enableOverrideOptions"><cv:msg key="label.enableOverrideOption" bundle="restore"></cv:msg></p>
		<div data-ng-if="replicationGroup.enableOverrideOptions && VMsDataLoaded">
			<cv-restore-options-vmware data-ng-if="(vendor === 'VMW') && VMsDataLoaded"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				source-id={{replicationGroup.selectedHypervisor.clientId}}
				destination-id="replicationGroup.destinationHyperV.clientId"
				replication-type="{{replicationGroup.attributes.replicationType}}"
				edit-mode="editMode"
				mode="repGroup"
				ctrl="ctrl">
			</cv-restore-options-vmware>

			<cv-restore-options-amazon data-ng-if="(vendor === 'AMAZON')"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				destination-for-vm-list="replicationGroup.destinationHyperV"
				proxy-client-for-vm-list="amazonProxyClientForVMList"
				mode=restoreOptionsAWSMode
				edit-mode="editMode"
				ctrl="ctrl"
				is-amazon-proxy-selected="replicationGroup.isAmazonProxy"
				is-aws-cross-restore="replicationGroup.isAWSCrossRestore">
			</cv-restore-options-amazon>
			<cv-restore-options-azure data-ng-if="(vendor === 'AZURE_V2' || vendor === 'AZURE_STACK')"
				vendor="vendor"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				mode=restore
				edit-mode="editMode"
				destination-for-vm-list="replicationGroup.destinationHyperV"
				ctrl="ctrl">
			</cv-restore-options-azure>

			<cv-restore-options-hyperv data-ng-if="(vendor === 'MICROSOFT')"
				vendor="vendor"
				vm-list="replicationGroup.selectedVMs"
				mode=restore
				modified-vms="replicationGroup.modifiedVms"
				edit-mode="editMode"
				ctrl="ctrl"
				source-id="replicationGroup.selectedHypervisor.clientId"
				destination-id="replicationGroup.destinationHyperV.clientId"
				selected-proxy="replicationGroup.selectedProxy">
			</cv-restore-options-hyperv>

			<cv-restore-options-oci data-ng-if="(vendor === 'ORACLE_CLOUD_INFRASTRUCTURE')"
				vendor ="vendor"
				vm-list="replicationGroup.selectedVMs"
				mode=restore
				modified-vms="replicationGroup.modifiedVms"
				edit-mode="editMode"
				ctrl="ctrl"
				source-id="replicationGroup.selectedHypervisor.clientId"
				destination-id="replicationGroup.destinationHyperV.clientId"
				selected-proxy="replicationGroup.selectedProxy">
			</cv-restore-options-oci>

			<cv-restore-options-openstack data-ng-if="(vendor === 'OPENSTACK')"
				vendor="vendor"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				source-id={{replicationGroup.selectedHypervisor.clientId}}
				destination-id="replicationGroup.destinationHyperV.clientId"
				replication-type="{{replicationGroup.attributes.replicationType}}"
				edit-mode="editMode"
				mode="repGroup"
				ctrl="ctrl">
			</cv-restore-options-openstack>
			<cv-restore-options-nutanix data-ng-if="(vendor === 'NUTANIX')"
				vendor="vendor"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				source-id={{replicationGroup.selectedHypervisor.clientId}}
				destination-id="replicationGroup.destinationHyperV.clientId"
				replication-type="{{replicationGroup.attributes.replicationType}}"
				edit-mode="editMode"
				mode="repGroup"
				ctrl="ctrl">
			</cv-restore-options-nutanix>
			<cv-restore-options-googlecloud data-ng-if="(vendor === 'GOOGLE_CLOUD')"
				vendor="vendor"
				vm-list="replicationGroup.selectedVMs"
				modified-vms="replicationGroup.modifiedVms"
				source-id=replicationGroup.selectedHypervisor.clientId
				destination-id="replicationGroup.destinationHyperV.clientId"
				edit-mode="editMode"
				mode=restore
				ctrl="ctrl">
			</cv-restore-options-googlecloud>
			<div data-ng-if="allErrorVMs && allErrorVMs.length" class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
				<cv-replication-groups-summary
					advanced-rst-options="allErrorVMs"
					vendor="vendorType"
					replication-type="replicationGroup.attributes.replicationType"
					disable-title="true">
		         </cv-replication-groups-summary>
	         </div>
		</div>

		<div data-ng-if="replicationGroup.enableOverrideOptions" class="button-container">
			<button id="overrideOptions_button_#1836" class="btn btn-default cvBusyOnAjax"
				data-ng-click="goBackToTarget()">
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button id="overrideOptions_button_#3806" class="btn btn-primary cvBusyOnAjax"
				data-ng-click="goToSummary()">
				<cv:msg key="Next" bundle="messages"></cv:msg>
			</button>
		</div>

	 <!-- Override question -->
		<div data-ng-if="!replicationGroup.enableOverrideOptions" class="button-container">
			<button id="overrideOptions_button_#6983" class="btn btn-default cvBusyOnAjax"
				data-ng-click="goBackToTarget()">
				<cv:msg key="Back" bundle="messages"></cv:msg>
			</button>
			<button id="overrideOptions_button_#7141" class="btn btn-primary focus cvBusyOnAjax"
				data-ng-click="goToSummary()">
				<cv:msg key="no" bundle="messagesJs"></cv:msg>
			</button>
			<button id="overrideOptions_button_#2068" class="btn btn-default cvBusyOnAjax"
				data-ng-click="enableOverride()">
				<cv:msg key="yes" bundle="messagesJs"></cv:msg>
			</button>
		</div>
	</div>
</div>
