<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div data-ng-show="guestCredentialsCtrl.isAmazonProxy || guestCredentialsCtrl.showGuestCredentials">
	<div class="form-group col-xs-12">
		<input data-ng-disabled="guestCredentialsCtrl.disabledCheckbox" type="checkbox" id="guestCredentials" name="guestCredentials"  data-ng-model="guestCredentialsCtrl.guestCredentials.checked" /> <label for="guestCredentials"><cv:msg key="label.specifyGuestCredentials" bundle="restore"/></label>
		<label data-ng-if="serverMsg" class="col-xs-12 server-message {{serverMessage.type}}">{{serverMsg.message}}</label>
	</div>
	<div class="form-group" data-ng-if="guestCredentialsCtrl.guestCredentials.checked">
		<label for="computerName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.domainOrComputerName" bundle="restore"/></label>
		
		
		
		<div class="col-xs-12 col-md-7 col-lg-7">
			<input data-ng-change="guestCredentialsChanged(guestCredentialsCtrl.guestCredentials.destComputerName)" type="text" name="computerName" id="computerName" data-ng-model="guestCredentialsCtrl.guestCredentials.destComputerName" ng-blur="destComputerNameChange()" required/>
			<span class="help-block" data-ng-show="guestCredentialsCtrl.computerNameError || submitController.getAttempted() && submitController.needsAttention(formController.computerName)">
				 <cv:msg key="error.destComputerName" bundle="restore"></cv:msg>
			</span>
		</div>
	</div>
	<div class="form-group" data-ng-if="guestCredentialsCtrl.guestCredentials.checked">
		<label for="userName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.username" bundle="restore"/></label>
		<div class="col-xs-12 col-md-7 col-lg-7">
			<input data-ng-change="destComputerUserNameChanged(guestCredentialsCtrl.guestCredentials.destComputerUserName)" type="text" name="userName" id="userName" data-ng-model="guestCredentialsCtrl.guestCredentials.destComputerUserName" ng-blur="destComputerUserNameChange()" required/>
			<span class="help-block"data-ng-show="guestCredentialsCtrl.destComputerUserNameError || submitController.getAttempted() && submitController.needsAttention(formController.userName)">
				<cv:msg key="error.destComputerUserName" bundle="restore"></cv:msg>
			</span>
		</div>
	</div>
	<div class="form-group" data-ng-if="guestCredentialsCtrl.guestCredentials.checked">
		<label for="instanceAdminPassword" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.password" bundle="restore"/></label>
		<div class="col-xs-12 col-md-7 col-lg-7">
			<input data-ng-change="instanceAdminPasswordChanged(guestCredentialsCtrl.guestCredentials.instanceAdminPassword)" type="password" name="instanceAdminPassword" id="instanceAdminPassword" data-ng-model="guestCredentialsCtrl.guestCredentials.instanceAdminPassword" ng-blur="instanceAdminPasswordChange()" required/>
			<span class="help-block" data-ng-show="guestCredentialsCtrl.instanceAdminPasswordError || adminpassword.message || submitController.getAttempted() && submitController.needsAttention(formController.instanceAdminPassword)">
				<cv:msg key="error.passwordRequired" bundle="restore"></cv:msg>
			</span>
		</div>
	</div>
</div>