	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.servers">
		<div class="setup-title">
			<h1><fmt:message key="pageHeader.addServer" /></h1>
		</div>
		<div class="setup-content" data-ng-controller="adhocServerController">
			<span class="{{addServerMessage.type}} serverMessage">{{addServerMessage.message}}</span>
			<form name="addServerForm" novalidate data-cv-submit="addServer()" autocomplete="off">
				<div class="global-options remove-border-padding">
					<label for="hostname"><fmt:message key="label.hostName" />
						<input type="text" name="hostname" data-ng-model="serverName" required />
						<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.hostname)"><fmt:message key="error.hostName" /></span>
					</label>
					<label for="vsUserName"><fmt:message key="label.userName" />
						<input type="text" name="vsUserName" data-ng-model="username" required />
						<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsUserName)"><fmt:message key="error.userName" /></span>
					</label>
					<label for="vsPassword"><fmt:message key="label.password" />
						<input type="password" name="vsPassword" data-ng-model="password"  required/>
						<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsPassword)"><fmt:message key="error.password" /></span>
					</label>
				</div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
						<button id="adhocServer_button_#0129" type="button" ng-show="{{showDefaultOption}}" class="btn btn-default setup-btn--hidden" data-ng-click="setDefault()"><fmt:message key="Default" /></button> 
						<button id="adhocServer_button_#1144" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
						<button id="adhocServer_button_#0471" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
					</fmt:bundle>
				</div>
			</form>
		</div>
	</fmt:bundle>
