<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.collections">
	<div class="setup-title">
		<h1>{{::localizedTitle}}</h1>
	</div>
	<div class="setup-content">
		<span class="{{restoreSettingServerMessage.type}} serverMessage">{{restoreSettingServerMessage.message}}</span>
		<form name="addNetworkSettingsForm" novalidate cv-submit="addNetworkSettings()" autocomplete="off" class="add-collection-form">
            <label ><cv:msg key="label.sourceNetworkModal" bundle="restore"/>
                <div class="company-multi-select">
                        <isteven-multi-select id="addVMwareNetworkSettingsModal_isteven-multi-select_#0160" 
                                input-model="networkSettingsSourceNetworkData"
                                output-model="selectedSourceNetworkData"
                                button-label="name"
                                item-label="name"
                                tick-property="selected"
                                selection-mode="single"
                                directive-id="sourceNetworkModal"
                                class="isteven-multi-select user-group-select single-select"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="localLang"
                                on-item-click="changeSourceNetworkData(selectedSourceNetworkData[0])">
                        </isteven-multi-select>
                </div>
            </label>
			
            <label><cv:msg key="label.destinationNetworkModal" bundle="restore"/>
                <div class="company-multi-select">
                        <isteven-multi-select id="addVMwareNetworkSettingsModal_isteven-multi-select_#9141" 
                                input-model="networkSettingsDestinationNetworkData"
                                output-model="selectedDestinationNetworkModal"
                                button-label="name"
                                item-label="name"
                                tick-property="selected"
                                selection-mode="single"
                                directive-id="destinationNetworkModal"
                                class="isteven-multi-select user-group-select single-select"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="localLang"
                                on-item-click="changeDestinationNetworkData(selectedDestinationNetworkModal[0])">
                        </isteven-multi-select>
                </div>
            </label>
			
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addVMwareNetworkSettingsModal_button_#3028" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddNetworkSettings()"><fmt:message key="Cancel" /></button> 
			  		<button id="addVMwareNetworkSettingsModal_button_#3424" type="submit" class="btn btn-primary" data-ng-disabled="!restoreData.vmOptions.settings.networkSettingsDataAvailable"><fmt:message key="OK" /></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>	
</fmt:bundle>