<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-controller="cloneVMGroupController">
	<div class="setup-title">
		<h1>
			<span><cv:msg key="label.cloneVMGroup" bundle="collectionsJs"/></span>
			<cv-help-component help-text="<cv:msg key="label.cloneVMGroupHelpText" bundle="collectionsJs"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content collection">
		<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
		<form id="addVmGroupCloneForm" name="addVmGroupCloneForm" novalidate cv-submit="cloneVMGroup()" autocomplete="off" class="add-collection-form">
			<label for="name"><cv:msg key="label.name" bundle="collections"/>
				<input type="text" id="name" name="name" data-ng-model="vmGroupInfo.name" required
					data-ng-class="{'has-error': cv.addVmGroupCloneForm.needsAttention(addVmGroupCloneForm.name)}" maxlength="100" />
				<span class="help-block" data-ng-show="cv.addVmGroupCloneForm.needsAttention(addVmGroupCloneForm.name)"><cv:msg key="error.name" bundle="collections"/></span>
			</label>
			
			<span class="multiSelectVMs">
				<div data-ng-if="serverId">
					<cv-browse-collection-content
						selected-content='vmGroupInfo.selectedContent'
						server-id="serverId"
						server-type="{{vendor}}"
						select-content-warning-fn='cv.addVmGroupCloneForm.getAttempted()'>
					</cv-browse-collection-content>
				</div>
			</span>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addVMGroupClone_button_#8099" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancelCloneVMGroup()"><cv:msg key="Cancel" /></button> 
			  		<button id="addVMGroupClone_button_#2300" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" /></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</div>