<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div data-ng-init="init()">
		<div class='setup-title'>
			<h1 data-ng-if="userInfo.userId == 0"><fmt:message key="pageHeader.addUser" /></h1>
			<h1 data-ng-if="userInfo.userId !== 0"><fmt:message key="pageHeader.editUser" /></h1>
		</div>
		<span class="{{serverMessage.type}}">{{serverMessage.message}}</span>
		<form name="addUserForm" cv-hide-api novalidate data-cv-submit="save()" autocomplete="off" id="addUserForm" class="bootstrap-wrapper form-horizontal edit-users-grid-form">
			<input type="hidden" data-ng-model="userInfo.userId">

			<div class="panel-body">
				<div data-ng-if="userInfo.userId === 0" class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="localUser"><fmt:message key="label.userType" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<label class="radio-label inline-label">
							<input class="no-float-auto" type="radio" id="localUser" data-ng-model="userInfo.userType" value="local" name="userType" data-ng-change="userTypeChange()">
							<fmt:message key="label.localUser" />
						</label>
						<label class="inline-label">
							<input class="no-float-auto" type="radio" id="externalUser" data-ng-model="userInfo.userType" value="external" name="userType" data-ng-change="userTypeChange()">
							<fmt:message key="label.externalUser" />
						</label>
					</div>
				</div>

				<div data-ng-if="userInfo.userType">
					<div data-ng-if="userInfo.local" class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="fullName">
							<fmt:message key="label.fullName" />
							<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
						</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" id="fullName" name="name" data-ng-model="userInfo.name" autofocus/>
						</div>
					</div>

					<div data-ng-if="!userInfo.local" class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="externalProvider">
							<fmt:message key="label.externalProvider" />
						</label>

						<div class="col-xs-12 col-md-7 col-lg-7">
							<isteven-multi-select
				   				  input-model="externalProviders"
				  				  button-label="name"
				  				  item-label="name"
				   				  tick-property="domanTicked"
				   				  class="isteven-multi-select user-group-select"
				   				  id="externalProvider"
				   				  name="externalProvider"
				   				  helper-elements="filter"
				   				  max-labels="1"
				   				  translation="localLangDomain"
				   				  disable-property="disabled"
				   				  on-item-click="validateProviderSelection()"
				   				  on-select-none="validateProviderSelection()"
				   				  on-select-all="validateProviderSelection()"
				   				  on-reset="validateProviderSelection()"
				   				  selection-mode="single"
				   				  group-property="msGroup">
							</isteven-multi-select>

							<span class="help-block" data-ng-if="showExternalProviderErrorMessage"><fmt:message key="error.externalProvider" /></span>
						</div>
					</div>

					<div data-ng-if="userInfo.local" class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5"  for="userName"><fmt:message key="label.userName" />
							<span class="optional-text" ng-hide="userInfo.userId !== 0"><cv:msg key="label.optional" bundle="subscriptions" /></span>
						</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" id="userName" name="userName" data-ng-model="userInfo.newUserName" ng-required="userInfo.userId !== 0"/>
							<span class="help-block" data-ng-if="addUserForm.userName.$error.required && cv.addUserForm.needsAttention(addUserForm.userName)"><fmt:message key="error.userName" /></span>
						</div>
					</div>

					<div data-ng-disabled="!selectedDomain || !selectedDomain.name" data-ng-if="!userInfo.local" class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5"  for="userName"><fmt:message key="label.userName" />
						</label>

						<div  class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" id="userName" name="userName" data-ng-model="userInfo.external.newExternalUserName" data-ng-change="externalUsernameChanged(userInfo.external.newExternalUserName)"/>
							<span class="help-block" data-ng-if="showInvalidExternalUsername"><fmt:message key="error.invalidUserName" /></span>
							<!-- <span class="help-block" data-ng-if="addUserForm.userName.$error.required && cv.addUserForm.needsAttention(addUserForm.userName)"><fmt:message key="error.userName" /></span> -->
						</div>
					</div>
					<div class="form-group" data-ng-if="!userInfo.local">
						<label class="col-xs-12 col-md-5 col-lg-5" for="providerEmail"><fmt:message key="label.email" />
							<span data-ng-show="selectedDomain.isAD" class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
						</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input data-ng-required="!selectedDomain.isAD" type="text" class="cv-first-cursor-position" type="email" id="providerEmail" name="providerEmail" data-ng-model="userInfo.external.email"  data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.providerEmail)}" data-ng-pattern="emailRegex" />
							<!--<span class="help-block" data-ng-if="!addUserForm.email.$error.required && cv.addUserForm.needsAttention(addUserForm.email)"><fmt:message key="error.email" /></span>-->
							<span class="help-block" data-ng-show="cv.addUserForm.needsAttention(addUserForm.providerEmail)"><fmt:message key="error.email" /></span>
						</div>
					</div>
					<div class="form-group" data-ng-if="userInfo.local">
						<label class="col-xs-12 col-md-5 col-lg-5" for="email"><fmt:message key="label.email" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input required type="text" class="cv-first-cursor-position" type="email" id="email" name="email" data-ng-model="userInfo.email"  data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.email)}" data-ng-pattern="emailRegex" />
							<!--<span class="help-block" data-ng-if="!addUserForm.email.$error.required && cv.addUserForm.needsAttention(addUserForm.email)"><fmt:message key="error.email" /></span>-->
							<span class="help-block" data-ng-show="cv.addUserForm.needsAttention(addUserForm.email)"><fmt:message key="error.email" /></span>
						</div>
					</div>
					<div class="form-group">
						<div data-ng-disabled="!selectedDomain && !userInfo.local">
							<label class="col-xs-12 col-md-5 col-lg-5" for="userGroupType"><fmt:message key="label.userGroup" />
								<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<isteven-multi-select
					   				  input-model="groups"
					  				  button-label="buttonLabel"
					  				  item-label="name"
					   				  tick-property="ticked"
					   				  class="isteven-multi-select user-group-select"
					   				  id="userGroupType"
					   				  name="userGroupType"
					   				  helper-elements="all none reset filter"
					   				  max-labels="1"
					   				  translation="localLang"
					   				  disable-property="disabled"
					   				  on-item-click="validateGroupSelection()"
					   				  on-select-none="validateGroupSelection()"
					   				  on-select-all="validateGroupSelection()"
					   				  on-reset="validateGroupSelection()"
					   				  group-property="msGroup"
					   				  loader="groups">
									</isteven-multi-select>

								<!--<span class="help-block" data-ng-if="showUserGroupErrorMessage"><fmt:message key="error.userGroupType" /></span>  -->
							</div>
						</div>
					</div>

					<div class="no-padding col-xs-12" data-ng-if="userInfo.local && userInfo.userId === 0" >
						<input type="checkbox" id="systemGeneratePassword"
							data-ng-model="userInfo.useSystemGeneratePassword"
							data-ng-change="manageSystemGeneratePassword()" />
						<label for="systemGeneratePassword">
								<cv:msg key="label.useSystemGeneratePassword" bundle="users" />
								<cv-help-component help-text="<cv:msg key="label.systemGeneratePasswordHelpText" bundle="users"/>"></cv-help-component>
							</label>
					</div>

					<div data-ng-if="userInfo.userId == 0 && userInfo.userType === 'local' && !userInfo.useSystemGeneratePassword">
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5"  for="password"><fmt:message key="label.password" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="password" name="password" id="password" data-ng-model="userInfo.password" data-ng-required="userInfo.local && !userInfo.useSystemGeneratePassword"
								data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.password)}"/>
								<span class="help-block" data-ng-if="cv.addUserForm.needsAttention(addUserForm.password)"><fmt:message key="error.password" /></span>
							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="confirmUserPassword"><fmt:message key="label.confirmPassword" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input data-ng-required="!userInfo.password" type="password"  name="confirmUserPassword" id="confirmUserPassword" data-ng-model="model.confirmPassword" data-cv-equals="{{userInfo.password}}"
									data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.confirmUserPassword)}" />
								<!--
									The warning message logic for the confirm pw field below is as follows:
									If the pw field is blank AND the user did not type anything in the password field above, show a required-field message
									If the pw field is not blank AND the field does not match the pw field AND the user has typed something in password field above, show a does-not-match message
								-->
								<span class="help-block" data-ng-if="addUserForm.confirmUserPassword.$error.required && cv.addUserForm.needsAttention(addUserForm.password)"><fmt:message key="error.confirmPassword" /></span>
								<span class="help-block"
									data-ng-if="!addUserForm.confirmUserPassword.$error.required && addUserForm.confirmUserPassword.$error.cvEquals && userInfo.password"><fmt:message key="error.mismatchedPassword" /></span>
							</div>
						</div>
					</div>

					<div data-ng-if="userInfo.userId !== 0 && userInfo.userType === 'local' && !userInfo.useSystemGeneratePassword">
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5"  for="password"><fmt:message key="label.password" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="password" name="password" id="password" data-ng-model="userInfo.password" placeholder="<fmt:message key="placeholder.editUserPassword" />"
								data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.password)}" />
								<span class="help-block" data-ng-if="cv.addUserForm.needsAttention(addUserForm.password)"><fmt:message key="error.password" /></span>
							</div>
						</div>
						<!--
							The warning message logic for the confirm pw field below is as follows:
							If the user password field is blank , not showing this one
							If the field is not blank AND the field does not match the pw field, show a does-not-match message
						-->

						<div data-ng-if="userInfo.password" class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="confirmUserPassword"><fmt:message key="label.confirmPassword" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="password"  name="confirmUserPassword" id="confirmUserPassword" data-ng-model="model.confirmPassword" data-cv-equals="{{userInfo.password}}"
									data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.confirmUserPassword)}" />
								<span class="help-block"
									data-ng-if="addUserForm.confirmUserPassword.$error.cvEquals"><fmt:message key="error.mismatchedPassword" /></span>
							</div>
						</div>

						<div data-ng-if="userInfo.password && model.confirmPassword" class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5"  for="currentUserPassword">
								<fmt:message key="label.currentLoggedInUserPassword" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="password" name="currentUserPassword" id="currentUserPassword" data-ng-model="userInfo.currentUserPassword" placeholder="<fmt:message key="placeholder.currentLoggedInUser" /> (${loginContext.userEntity.userName})"/>
							</div>
						</div>
					</div>

				<!-- <div data-ng-if="userInfo.availableGroups">
					<label for="userGroupType" class="select-label"><fmt:message key="label.userGroup" />
						<select name="userGroupType" id="userGroupType"
							data-ng-options="group.userGroupEntity.userGroupId as group.userGroupEntity.userGroupName  for group in userInfo.availableGroups | orderBy : 'userGroupEntity.userGroupName'"
							data-ng-model="userInfo.associatedUserGroup" required
							data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.userGroupType)}">
							<option value=""><fmt:message key="label.userGroupType" /></option>
						</select>
						<span class="help-block" data-ng-if="cv.addUserForm.needsAttention(addUserForm.userGroupType)"><fmt:message key="error.userGroupType" /></span>
					</label>
				</div> -->

	   				<span data-ng-if="userInfo.userId!==0" class="istevens-wrapper">
						<cv-plan-migration user-info="userInfo" is-modal=true show-tile=true server-msg="serverMessage"></cv-plan-migration>
					</span>

					<div class="no-padding col-xs-12" data-ng-if="showInviteUser">
						<input type="checkbox" id="inviteUser" data-ng-model="userInfo.inviteUser" />
						<label for="inviteUser">
							<fmt:message key="label.inviteUser" />
							<cv-help-component help-text="<cv:msg key="label.inviteUserHelpText" bundle="users"/>"></cv-help-component>
						</label>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button id="addUserModal_button_#5061" type='button' class='btn btn-default cvBusyOnAjax' data-ng-click='cancel()'><fmt:message key="action.cancel" /></button>
				<button id="addUserModal_button_#5740" type='submit' class='btn btn-primary cvBusyOnAjax'><fmt:message key="action.save" /></button>
			</div>
		</form>
	</div>
</fmt:bundle>
<!-- needed for encoding the password -->
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>