<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
</script>
	<div class="setup-title">
			<h1><cv:msg key="label.addSubscription" bundle="subscriptions"/></h1>
	</div>
	<div class="setup-content">
		<div class="{{addSubscriptionMessage.type}} serverMessage">{{addSubscriptionMessage.message}}</div>
		<div class="bootstrap-wrapper modal-margin">
			<form class="form-horizontal" name="addSubscriptionForm" data-cv-submit="addSubscription()" novalidate autocomplete="off" id="addSubscriptionForm">
				<div class="form-group">
					<label for="name" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.companyName" bundle="subscriptions"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="name" id="name" data-ng-model="modalInfo.name" required />
						<span class="help-block" data-ng-show="cv.addSubscriptionForm.needsAttention(addSubscriptionForm.name)"><cv:msg key="error.name" bundle="subscriptions"/></span>
					</div>
				</div>
				<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
				<input style="display:none" type="text" name="fakeusernameremembered"/>
				<input style="display:none" type="password" name="fakepasswordremembered"/>
				<div class="form-group">
					<label for="plans" class="col-xs-12 col-md-5 col-lg-5" data-ng-show="planList"><cv:msg key="label.profiles" bundle="profiles"/> <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="planList">
						<cv-plan-summary-dropdown
							input-model="planList"
							output-model="selectedPlanList"
							button-label="'planName'"
              				item-label="'planName'"
							tick-property="'selected'"
							directive-id="'plans'"
              				helper-elements="'all none reset filter'"
              				max-labels="1"
							translation="localLang"
							disable-property="'disabled'"
							on-item-clicked="validatePlanSelection()"
							on-select-none="validatePlanSelection()"
							on-select-all="validatePlanSelection()"
							on-reset="validatePlanSelection()"
							group-property="'msGroup'">
						</cv-plan-summary-dropdown>
					</div>
				</div>
  				<div class="form-group">
					<label for="companyAlias" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.companyAlias" bundle="subscriptions"/>
                        <cv-help-component help-text="<cv:msg key="label.companyAliasHelpText" bundle="subscriptions"/>"></cv-help-component>
                    </label>
                    <div class="col-xs-12 col-md-7 col-lg-7">
                        <input type="text" name="companyAlias" id="companyAlias" data-ng-model="modalInfo.companyAlias" required />
                        <span class="help-block" data-ng-show="cv.addSubscriptionForm.needsAttention(addSubscriptionForm.companyAlias)"><cv:msg key="error.companyAlias" bundle="subscriptions"/></span>
                    </div>
				</div>
				<div class="form-group" ng-show="${ !cvConfig.isMultiCommcellAssociationHidden() } && isGlobalIDPRouterCommcell">
					<label for="associateCommcell" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.serviceCommcells" bundle="commcell"/> <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							input-model="commcellModels.serviceCommcells"
							output-model="commcellModels.selectedServiceCommcells"
							class="isteven-multi-select"
							button-label="commCellName"
							item-label="commCellName"
							tick-property="selected"
							directive-id="'associateCommcell'"
							translation="{ nothingSelected: '<cv:msg key="label.selectCommcellForDropdown" bundle="commcell" />' }"
							disable-property="'disabled'">
						</isteven-multi-select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" data-ng-class="{'has-error': addSubscriptionForm.smtp.$invalid}" for="associatedSMTP"><cv:msg key="label.associatedSMTP" bundle="subscriptions"/>
						<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
						<cv-help-component help-text="<cv:msg key="label.associatedSMTPHelpText" bundle="subscriptions"/>"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="associatedSMTP" id="associatedSMTP" data-ng-model="modalInfo.emailDomainNames" data-ng-pattern="smtpRegex"/>
						<span class="help-block" data-ng-show="cv.addSubscriptionForm.needsAttention(addSubscriptionForm.associatedSMTP)"><cv:msg key="error.smtpAddress" bundle="subscriptions"/></span>
					</div>
				</div>
				<cv-toggle-accordion accordion-label="label.autoCreateTenantAdmin" collapsed="modalInfo.dontAutoCreateTenantAdmin">
					<div class="form-group">
						<label for="fullName" class="col-xs-12 col-md-5 col-lg-5 padding-left-20"><cv:msg key="label.fullName" bundle="subscriptions"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" name="fullName" id="fullName" ng-required="modalInfo.dontAutoCreateTenantAdmin" data-ng-model="modalInfo.userFullName" />
							<span class="help-block" data-ng-show="cv.addSubscriptionForm.needsAttention(addSubscriptionForm.fullName)"><cv:msg key="error.fullName" bundle="subscriptions"/></span>
						</div>
					</div>
					<div class="form-group">
						<label for="email" class="col-xs-12 col-md-5 col-lg-5 padding-left-20"><cv:msg key="label.email" bundle="subscriptions"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" name="email" id="email" ng-required="modalInfo.dontAutoCreateTenantAdmin" data-ng-model="modalInfo.userEmail" data-ng-pattern="emailRegex"/>
							<span class="help-block" data-ng-show="cv.addSubscriptionForm.needsAttention(addSubscriptionForm.email)"><cv:msg key="error.email" bundle="subscriptions"/></span>
						</div>
					</div>
					<!--  Email Template option - START-->
					<cv-toggle-accordion accordion-label="label.sendOnboardingEmail" collapsed="modalInfo.sendOnboardingEmail">
						<label for="templates" class="col-xs-12 col-sm-5 no-margin"><cv:msg key="emailTemplates.label.template" bundle="emailTemplate" />
							<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
						</label>
						<div class="col-xs-12 col-sm-7">
							<isteven-multi-select id="addSubscriptionWindowModal_isteven-multi-select_#4231"
							      data-ng-if="templateList.length > 0"
				   				  input-model="templateList"
				   				  output-model="modalInfo.selectedTemplate"
				  				  button-label="name"
								  item-label="name"
	  							  directive-id="templates"
				   				  tick-property="selected"
				   				  selection-mode="single"
				   				  class="isteven-multi-select user-group-select"
				   				  name="templates"
								  helper-elements="filter"
				   				  max-labels="1"
				   				  translation="localLangTemplate"
				   				  disable-property="disabled"
				   				  group-property="msGroup"
				   				  search-limit="10">
							</isteven-multi-select>
							<label data-ng-if="!(templateList.length > 0)">
								<span><cv:msg key="emailTemplates.msg.noTemplates" bundle="emailTemplate"/>
								<a ng-click="goToAddTemplate()" href="${pageContext.request.contextPath}/#/emailTemplates/new?emailType=1"><cv:msg key="emailTemplates.label.createTemplate" bundle="emailTemplate"/></a>
								</span>
							</label>
							</div>
					</cv-toggle-accordion>
					<!--  Email Template option - END-->
				</cv-toggle-accordion>
					<cv-toggle-accordion accordion-label="label.enableCustomDomain" collapsed="modalInfo.enableCustomDomain" click-Header="enableDisableCustomDomain(data)">
						<label for="domainName" class="col-xs-12 col-sm-5 no-margin"><cv:msg key="label.primaryDomainName" bundle="subscriptions" /></label>
						<div class="col-xs-12 col-sm-7">
							<input class="full-width" type="text" name="domainName" id="domainName" data-ng-model="modalInfo.domainName" required />
							<span class="help-block" data-ng-show="modalInfo.enableCustomDomain && cv.addSubscriptionForm.needsAttention(addSubscriptionForm.domainName)"><cv:msg key="error.domainName" bundle="users" /></span>
						</div>
					</cv-toggle-accordion>

				<div class="button-container">
					<button id="addSubscriptionWindowModal_button_#4101" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="subscriptions"/></button>
					<button id="addSubscriptionWindowModal_button_#1939" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="subscriptions"/></button>
				</div>
			</form>
		</div>
	</div>
