<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.storage">
	<div data-ng-controller="addVSAStorageController">
		<div class="setup-title">
			<h1 data-ng-if="action=='newLib'"><fmt:message key="Add Storage" /></h1>
			<h1 data-ng-if="action=='editMP'"><fmt:message key="Edit_Path" /></h1>
			<h1 data-ng-if="action=='addMP'"><fmt:message key="Add_Path" /></h1>
		</div>
		
		<div class="setup-content" >
			<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
			<p class="serverMessage">{{storagePresentMessage.message}}</p>
			<a data-ng-click="changeStorage()" data-ng-show="formStorage.hide && !mspModeOn" ><fmt:message key="Edit Storage"/></a>
			<form name="storageForm" class="{{typeOfStorage}}" novalidate cv-submit="addStorage()" autocomplete="off" data-ng-hide="formStorage.hide">
				<div class="storage-type">
					<label>
						<input type="radio" data-ng-model="typeOfStorage" value="localStorage" name="typeOfStorage" data-ng-disabled="action=='editMP'">
						<fmt:message key="Local Disk" />
					</label>
					<label>
						<input type="radio" data-ng-model="typeOfStorage" value="networkStorage" name="typeOfStorage" data-ng-disabled="action=='editMP'">
						<fmt:message key="Network_Path" />
					</label>
				</div>
		
				<label>
					<fmt:message key="Storage Name" />
					<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" data-ng-readonly="action=='addMP'||action=='editMP'" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" required maxlength="128"/>
					<span class="help-block" data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><fmt:message key="error.libraryName.required" /></span>
					<span class="help-block" data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><fmt:message key="error.libraryName.length" /></span>
				</label>
				<label  for="mediaAgent" class="select-label"><fmt:message key="label.mediaAgent"/>
								<select id="mediaAgent" name="mediaAgent" data-ng-model="libraryInfo.mediaAgentId"
										data-ng-options="agent.mediaAgentId as agent.displayName for agent in agentList" 
										data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)}">
									 <option value=""><fmt:message key="placeholder.mediaAgent" /></option> 
								</select>
								<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"><fmt:message key="error.mediaAgent" /></span>
							</label>
				<label for="mountPath" data-ng-class="{'storage-path-label': typeOfStorage=='localStorage'}">
					<fmt:message key="Storage Path" />
					<input data-ng-readonly="action=='editMP'" data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern'/>
					<span class="help-block" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><fmt:message key="error.mountpath.required" /></span>
					
					<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
									<fmt:message key="error.mountpath.invalid" />
								</span>
				</label>
				<button id="addStorageContent_button_#0629" type="button" data-ng-if="typeOfStorage=='localStorage' && action!='editMP'" data-ng-click="browse()" class="btn btn-default browse-btn"> 
					<fmt:message key="Browse" />
				</button>
				
				<div data-ng-if="typeOfStorage=='networkStorage' && action!='editMP'" class="credentials">
					<label>
						<fmt:message key="User Name" />
						<input type="text" name=loginName data-ng-model="libraryInfo.loginName"/>
					</label>
					<label>
						<fmt:message key="Password" />
						<input type="password" data-ng-model="libraryInfo.password"/>
					</label>
				</div>
				<div class="button-container">
					<button id="addStorageContent_button_#7202" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"> 
						<fmt:message key="Cancel" bundle="${common }"/>
					</button>
					<button id="addStorageContent_button_#3644" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-hide="action=='newLib'||action=='addMP'" data-ng-click="deleteMountPath()"> 
						<fmt:message bundle="${common }" key="Delete" />
					</button>
					<button id="addStorageContent_button_#4959" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-if="storagePresent" data-ng-click="skip()"><fmt:message bundle="${common }" key="Skip" /></button> 
					<button id="addStorageContent_button_#6291" class="btn btn-primary cvBusyOnAjax" type="submit" data-ng-if="action!='editMP'"> 
						<fmt:message bundle="${common }" key="Save" />
					</button>
				</div>
			</form>
			<div class="button-container centered" data-ng-show="formStorage.hide">
				<fmt:bundle basename="localization.messages">
					<button id="addStorageContent_button_#1991" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><fmt:message key="Continue" /></button> 
				</fmt:bundle>
			</div>
			
		</div>
	</div>
</fmt:bundle>