<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div  data-ng-controller="addCollectionController">
		<div class="setup-title">
			<h1>{{::localizedTitle}}</h1>
		</div>
		<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
		<form name="addRuleForm" novalidate cv-submit="addRuleContent()" cv-hide-api autocomplete="off" class="bootstrap-wrapper form-horizontal">
			<div class="panel panel-default"> 
				<div class="panel-body">
					<div class="form-group" data-ng-if="!appGroupCreationEligible">
						<label class="col-xs-12 col-md-5 col-lg-5" for="ruleType"><cv:msg key="label.selectRule" bundle="collectionsJs" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<!-- <select	data-ng-options="rule as rule.displayName for rule in editor.ruleTypeList track by rule.typeName"
									data-ng-model="editor.ruleType" data-ng-change="updateRuleEditorForType(editor)" required id="ruleType"></select> -->
							<isteven-multi-select
									input-model="editor.ruleTypeList"
									button-label="displayName"
									output-model="editor.ruleType"
									id="ruleType"
									item-label="displayName"
									search-limit="10"
									search-property="displayName"
									selection-mode="single"
									tick-property="selected"
									class="isteven-multi-select user-group-select"
									helper-elements="filter"
									on-item-click="updateRuleEditorForType(editor)">
								</isteven-multi-select>
						</div>
					</div>
					<div class="form-group" data-ng-if="editor.ruleType[0].isKeyValuePair && !appGroupCreationEligible"">
						 <label data-ng-class="appGroupCreationEligible || isMetadataTagSelected? 'col-xs-12 col-md-5 col-lg-5' : 'col-xs-12 col-md-2 col-lg-2'" for="ruleKey">
						 	<span data-ng-if="editor.ruleType[0].key"><cv:msg key="label.key" bundle="collectionsJs" /></span>
						 	<span data-ng-if="!editor.ruleType[0].key"><cv:msg key="label.ruleName" bundle="collectionsJs" /></span>
						 </label>
				   		 <div class="col-xs-12 col-md-3 col-lg-3" data-ng-if="!appGroupCreationEligible && !isMetadataTagSelected"><select data-ng-disabled="editor.operatorList.length<=1"
							id="ruleKey"
							data-ng-options="operator as operator.name for operator in editor.operatorList | orderBy: 'name' track by operator.value"
							data-ng-model="editor.operatorForKey" required></select>
						</div>
					    <div class="col-xs-12 col-md-7 col-lg-7"><input type="text" name="ruleStringForKey"
							id=""
							data-ng-model="editor.ruleStringForKey"
							data-ng-disabled="!editor.stringEditable || appGroupCreationEligible"
							required spellcheck="false"/>
						</div>
						<span class="help-block" data-ng-show="cv.addRuleForm.needsAttention(addRuleForm.ruleStringForKey)"><cv:msg key="error.customRuleName" bundle="collectionsJs"/></span>
					</div>
					<div class="form-group" data-ng-if="appGroupCreationEligible && editor.ruleType[0].isKeyValuePair">
						<label data-ng-class="appGroupCreationEligible ? 'col-xs-12 col-md-5 col-lg-5' : 'col-xs-12 col-md-2 col-lg-2'" for="ruleType"><cv:msg key="label.type" bundle="collectionsJs" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<isteven-multi-select data-ng-class="select" id="ruleType"
							data-input-model="model.ruleType"
							data-output-model="model.selectedRuleType"
							data-tick-property="checked"
							item-label="name"
							data-button-label="name"
							data-search-property="name"
							helper-elements="filter showSelected"
							class="isteven-multi-select user-group-select modal-right"
							data-selection-mode="single"
							translation="localLangKubernetesRuleType">
							</isteven-multi-select>
						</div>
					</div>
					<div class="form-group" data-ng-if="isMetadataTagSelected">
						<label class="col-xs-12 col-md-5 col-lg-5" for="keyType"><cv:msg key="label.selectKeyType" bundle="collectionsJs" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<isteven-multi-select
									input-model="editor.keyTypeList"
									button-label="displayName"
									output-model="editor.keyType"
									id="keyType"
									item-label="displayName"
									search-limit="10"
									search-property="displayName"
									selection-mode="single"
									tick-property="selected"
									class="isteven-multi-select user-group-select"
									helper-elements="filter"
									on-item-click="updateRuleEditorForType(editor)">
								</isteven-multi-select>
						</div>
					</div>
					<div class="form-group" data-ng-if="editor.ruleType[0].isKeyValuePair && !isMetaBooleanSelected">
						<label data-ng-if="appGroupCreationEligible" data-ng-class="appGroupCreationEligible ? 'col-xs-12 col-md-5 col-lg-5' : 'col-xs-12 col-md-2 col-lg-2'" for="rulevalue">
							<cv-help-text help-label="<cv:msg key="label.ruleValue" bundle="collectionsJs"/>" 
								help-text="'<cv:msg key='label.ruleValeText' bundle="collectionsJs"/>'">
							</cv-help-text>
						</label>
						<label data-ng-if="!appGroupCreationEligible" data-ng-class="appGroupCreationEligible || isMetadataTagSelected? 'col-xs-12 col-md-5 col-lg-5' : 'col-xs-12 col-md-2 col-lg-2'" for="rulevalue">
							<cv:msg key="label.ruleValue" bundle="collectionsJs"/>
						</label>
						
			    		<div class="col-xs-12 col-md-3 col-lg-3" data-ng-if="!appGroupCreationEligible && !isMetadataTagSelected"><select data-ng-disabled="editor.operatorList.length<=1"
			    			id="rulevalue"
							data-ng-options="operator as operator.name for operator in editor.operatorList | orderBy: 'name' track by operator.value"
							data-ng-model="editor.operator" required></select>
						</div>
				    
						<div class="col-xs-12 col-md-7 col-lg-7"><input type="text" name="ruleString"
			    			id=""
							data-ng-model="editor.ruleString"
							data-ng-disabled="!editor.stringEditable"
							data-ng-change="ruleStringEdited(editor)"
							required spellcheck="false"/>
						</div>
						<span class="help-block" data-ng-show="cv.addRuleForm.needsAttention(addRuleForm.ruleString)"><cv:msg key="error.ruleValue" bundle="collectionsJs"/></span>
					</div>
					<div class="form-group" data-ng-if="!editor.ruleType[0].isKeyValuePair">
						<label class="col-xs-12 col-md-5 col-lg-5" for="matchesrule"><cv:msg key="label.matchesRule" bundle="collectionsJs" /></label>
				    	<div class="col-xs-12 col-md-7 col-lg-7"><select data-ng-disabled="editor.operatorList.length<=1"
							 id="matchesrule"
				             data-ng-options="operator as operator.name for operator in editor.operatorList | orderBy: 'name' track by operator.value"
						  	 data-ng-model="editor.operator" required></select>
						</div>
					</div>
					<div class="form-group" data-ng-if="!editor.ruleType[0].isCustom && !editor.ruleType[0].isKeyValuePair">
						<label class="col-xs-12 col-md-5 col-lg-5" for="rulename2"><cv:msg key="label.ruleName" bundle="collectionsJs" /></label>
			    		<div class="col-xs-12 col-md-7 col-lg-7">
			    			<input type="text"	
			    			placeholder="<cv:msg key="placeholder.enterRuleName" bundle="collections"></cv:msg>"							    			
							id="rulename2"
				    		name="ruleString"
							data-ng-model="editor.ruleString"
							data-ng-disabled="!editor.stringEditable"
							data-ng-change="ruleStringEdited(editor)"
							required spellcheck="false"/>
							<span class="help-block" data-ng-show="cv.addRuleForm.needsAttention(addRuleForm.ruleString)"><cv:msg key="error.ruleName" bundle="collectionsJs"/></span>
						</div>
					</div>
					<div class="form-group" data-ng-if="editor.ruleType[0].isCustom">
						<label class="col-xs-12 col-md-5 col-lg-5" for="rulename3"><cv:msg key="label.ruleName" bundle="collectionsJs"/></label>
				    	<div class="col-xs-12 col-md-7 col-lg-7"><select data-ng-disabled="editor.ruleType[0].customOptionsList.length<=1"
							 id="rulename3"
							 data-ng-options="item as item.displayName for item in editor.ruleType[0].customOptionsList track by item.value"
							 data-ng-model="editor.customOption" required></select>
						</div>
					</div>
					<div class="form-group" data-ng-if="isMetaBooleanSelected">
						<label class="col-xs-12 col-md-5 col-lg-5" for="ruleValue2"><cv:msg key="label.ruleValue" bundle="collectionsJs"/></label>
				    	<div class="col-xs-12 col-md-7 col-lg-7"><select data-ng-disabled="editor.ruleType[0].customOptionsList.length<=1"
							 id="ruleValue2"
							 data-ng-options="item as item.displayName for item in editor.ruleType[0].customOptionsList track by item.value"
							 data-ng-model="editor.customOption" required></select>
						</div>
					</div>
					<div class="form-group" data-ng-if="isFilter && !appGroupCreationEligible">
						<label class="col-xs-12 col-md-5 col-lg-5" for="ruleDescription"><cv:msg key="label.ruleDescription" bundle="collectionsJs" /></label>
			    		<div class="col-xs-12 col-md-7 col-lg-7"><input type="text"							    			
							id="ruledescription"
				    		name="descriptionString"
							data-ng-model="editor.ruleDescriptionString"
							data-ng-disabled="!editor.stringEditable"
							data-ng-change="ruleDescriptionStringEdited(editor)"=
							spellcheck="false"/>
						</div>
					</div>
				</div>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addRuleContentModal_button_#3106" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddRule()"><fmt:message key="Cancel" /></button> 
			  		<button id="addRuleContentModal_button_#0291" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>
