
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>

<div>
	<div class="setup-title">
		<h1>Custom validation script</h1>
	</div>
	<div class="bootstrap-wrapper">
		<div class="modal-body">
			<div class="form-horizontal">
				<form name="customScriptForm" novalidate autocomplete="off">
					<!--Hiding the custom script location selection as the script is going to be in local for now -->
					<div class="form-group" data-ng-show="false">
						<div class="col-xs-12 col-sm-4">
							<label for="applicationName">Script location</label>
						</div>
						<div class="col-xs-12  col-sm-8">
							<div class="multiple-radio-group">
								<label for="user"><input type="radio" data-ng-model="$ctrl.customValidationApp.scriptLocationType" value="Local"/>
								<span class="block-indent"><cv:msg key="label.local" bundle="dr"/></span></label>
							</div>
							<div class="multiple-radio-group">
								<label for="credManager"><input type="radio" data-ng-model="$ctrl.customValidationApp.scriptLocationType" value="Network"/>
								<span class="block-indent"><cv:msg key="label.network" bundle="dr"/></span></label>
							</div>
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-4">
							<label for="uncNetworkPath"><cv:msg key="label.uncNetworkPath" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input name="uncPath" type="text" id="uncNetworkPath" data-ng-model="$ctrl.customValidationApp.uncNetworkPath" required>
							<div class="help-block" data-ng-if="customScriptForm.$submitted && customScriptForm.uncPath.$error.required">
								<cv:msg key="msg.uncNetworkPathInvalid" bundle="dr"/>
							</div>
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-sm-4">
							<label for="scriptArguments"><cv:msg key="label.scriptArguments" bundle="dr"/></label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input name="scriptArguments" type="text" id="scriptArguments" data-ng-model="$ctrl.customValidationApp.arguments">
						</div>
					</div>
					<div data-ng-if="$ctrl.customValidationApp.scriptLocationType == 'Network'">
						<cv-credential-manager id="credentialMgrCustomApp" model="$ctrl.uncCredentialsInput" form-name="customScriptForm" input-name="$ctrl.guestName"
						password-complexity="1" is-optional="false" show-credential="true" css-class="form-group row" password-required-on-edit="true"></cv-credential-manager>
					</div>

					<div class="setup-content">
					<div class="button-container">
						<button type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="$ctrl.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button>
						<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="$ctrl.saveValidationScriptDetails(customScriptForm.$valid)"><cv:msg key="Save" bundle="messages"/></button>
					</div>
				</div>
				</form>
			</div>
		</div>
	</div>
</div>


