<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vms"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div data-ng-controller="addCollectionController">
		<div class="setup-title" data-ng-if="!customizeForMetallic">
			<h1>
				<span data-ng-if="!isAddServerWizard && !appGroupCreationEligible"><cv:msg key="action.addVMGroup" bundle="collections" /></span>
				<span data-ng-if="isAddServerWizard && !appGroupCreationEligible"><cv:msg key="label.ec2For" bundle="servers" /> {{addedServerName}}</span>
				<span data-ng-if="!isAddServerWizard && appGroupCreationEligible"><cv:msg key="pageHeader.addApplication" bundle="kubernetes" /></span>
				<cv-help-component help-text="{{helpTextLabel}}"></cv-help-component>
			</h1>
		</div>
		<div data-ng-if="customizeForMetallic" class="wizard-step-header">
			<h2>
				<span data-ng-if="!isAddServerWizard && !appGroupCreationEligible"><cv:msg key="action.addVMGroup" bundle="collections" /></span>
				<span data-ng-if="isAddServerWizard && !appGroupCreationEligible"><cv:msg key="label.ec2For" bundle="servers" /> {{addedServerName}}</span>
				<span data-ng-if="!isAddServerWizard && appGroupCreationEligible"><cv:msg key="pageHeader.addApplication" bundle="kubernetes" /></span>
			</h2>
			<p>{{helpTextLabel}}</p>
		</div>
		<div class="setup-content medium-width" data-ng-class="{'wizard-step-body' : customizeForMetallic}">
			<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
			<p class="{{serverMessage.type}} serverMessage">{{collectionExistedMessage.message}}</p>
			<p class="text-center"><a data-ng-click="changeConfig()" data-ng-show="formConfig.hide" data-ng-bind="addVmOrAppGroup"></a></p>
			<form id="addCollectionForm"
					data-ng-hide="formConfig.hide"
					name="addCollectionForm"
					novalidate
					cv-submit="addCollection()"
					autocomplete="off"
					class="add-collection-form form-horizontal">
			
			<div class="bootstrap-wrapper bootstrap-wrapper padding-bottom-0 margin-bottom-0 panel panel-default">
				<div class="panel-body">
					<div class="form-group" data-ng-show="showClientSelector">
						<label data-ng-if="!isAddServerWizard && !appGroupCreationEligible" class="col-xs-12 col-md-4 col-lg-4" for="client"><cv:msg key="pageHeader.hypervisors" bundle="servers" /></label>
						<label data-ng-if="!isAddServerWizard && appGroupCreationEligible" class="col-xs-12 col-md-4 col-lg-4" for="client"><cv:msg key="header.server" bundle="kubernetes" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<isteven-multi-select
								input-model="serversList"
								output-model="selectedHypervisor"
								button-label="label"
								item-label="icon label"
								id="client"
								tick-property="selected"
								selection-mode="single"
								class="isteven-multi-select user-group-select single-select"
								name="vendorType"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								on-item-click="changeHypervisor(selectedHypervisor)">
							</isteven-multi-select>
						</div>
					</div>
					<div class="form-group" data-ng-if="!isAddServerWizard">
						<label class="col-xs-12 col-md-4 col-lg-4" for="name"><cv:msg key="label.name" bundle="collections" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text"
									id="name"
									name="name"
									data-ng-model="collectionInfo.name"
									placeholder="<cv:msg key="placeholder.enterGroupName" bundle="replicationGroups"></cv:msg>"
									required data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.name)}"
									maxlength="100" />
							<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.name)"><cv:msg key="error.name" bundle="collections" /></span>
						</div>
					</div>
					<span class="multiSelectVMs" data-ng-if="!vmContent && !enableAddRuleReplicationGroup">
						<div data-ng-if="scId">
							<cv-browse-collection-content
								selected-content='collectionInfo.selectedContent'
								server-id="scId"
								server-type="{{serverType}}"
								select-content-warning-fn='cv.addCollectionForm.getAttempted()'
								hide-search="{{isAddServerWizard}}"
								edit-users-grid-form
								edit-users-grid-form="ctrl"
								selection-error-str="{{errorMsgOnEmptySelection}}">
							</cv-browse-collection-content>
						</div>
					</span>
				</div>
			</div>
			<div data-ng-if="scId && !vmContent && enableAddRuleReplicationGroup">
				<cv-add-vm-content-directive
				vendor="serverType" 
				client-id="scId" ctrl="ctrl"></cv-add-vm-content-directive>
			</div>
			<div class="bootstrap-wrapper form-horizontal">
				<div class="panel panel-default">
					<div class="panel-body">
						<div>
							<label for="vmContent" data-ng-if="vmContent"><cv:msg key="header.content" bundle="collections" />
								<input type="text" id="vmContent" name="vmContent" value="{{vmContent.type}}:{{vmContent.displayName}}" disabled="disabled" />
							</label>
							<div class="bootstrap-wrapper padding-bottom-0">
								<div data-ng-if="showIntellisnapOption()">
									<h4 class="text-left"><cv:msg key="header.snapConfiguration" bundle="clients" /></h4>
									<div class="form-group row">
										<div class="col-xs-12 col-md-1 col-lg-1" data-ng-click="onIntellinSnapClick()">
											<toggle-control status="collectionInfo.isSnapBackupEnabled" title='<cv:msg key="label.intellisnapTitle" bundle="collectionsJs" />'></toggle-control>
										</div>
										<label class="col-xs-12 col-md-11 col-lg-11" ><span><cv:msg key="label.intellisnap" bundle="collectionsJs" /></span></label>
										</div>
									</div>
								<!-- There is no Plan while manage collection content.-->
								<cv-entity-plan-policy-select data-ng-if="planPolicyModel && (formId != 'manageCollectionContentForm')" data-cv-model="planPolicyModel"
										data-cv-hide-policy-toggle-option="true" data-cv-app-id="applicationId" data-cv-client-id="serverId" plan-selection-change="showHideRegionDropdown(planDetails)" data-cv-wrapper-class="'form-group'"
										data-cv-label-class="'col-xs-12 col-md-4 col-lg-4'" data-cv-select-class="'col-xs-12 col-md-8 col-lg-8'">
								</cv-entity-plan-policy-select>
						<div class="form-group" data-ng-if="planRuleEnabled">
									<data-ng-include src="appUtil.appRoot + 'common/partials/cvPleaseNote.jsp'"> </data-ng-include>
									<label  class="col-xs-12 col-md-4 col-lg-4" for="storage" ><cv:msg key="label.region" bundle="profiles"/></label>
									<div class="col-xs-12 col-md-8 col-lg-8" data-ng-disabled="editMode">
									<isteven-multi-select  input-model="regionList" output-model="selectedRegion" button-label="name" item-label="name" tick-property="selected" class="isteven-multi-select user-group-select single-select" id="criteria-key-region-{{$id}}" on-close="setRegionDetails()" group-property="msGroup" on-item-click="selectedRegionValue()" search-property="name" selection-mode="single" helper-elements="filter">
		    						</isteven-multi-select>
		    						</div>
								</div>
	
						<div data-ng-if="showMeditechSystemOption()">
								<h4 class="text-left"><cv:msg key="label.meditechSystem" bundle="dr" /></h4>
								<div class="form-group row" >
									<div class="col-xs-12 col-md-1 col-lg-1" data-ng-click="onMeditechSystemClick()">
										<toggle-control status="isMeditechSystemEnabled" title='<cv:msg key="label.enableMeditech" bundle="dr" />'></toggle-control>
									</div>
									<label class="col-xs-12 col-md-11 col-lg-11" ><span><cv:msg key="label.enableMeditech" bundle="dr" /></span></label>
								</div>
	
	 							<div class="form-group" name="meditechForm" id="meditechForm" data-ng-if="isMeditechSystemEnabled == 'enabled-activity'">
									<label class="col-xs-12 col-md-4 col-lg-4" for="systemName"> <cv:msg key="label.systemName" bundle="dr" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="text" name="systemName" id="systemName" data-ng-model="collectionInfo.hcSubclientProp.medicalSystemName" required />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.systemName)"><cv:msg key="error.medicalSystemName" bundle="dr" /></span>
									</div>
									<label class="col-xs-12 col-md-4 col-lg-4" for="masterNode"> <cv:msg key="label.masterNode" bundle="dr" /><cv-help-component help-text="<cv:msg key="info.listener" bundle="dr"/>"></cv-help-component></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="text" name="masterNode" id="masterNode" data-ng-model="collectionInfo.hcSubclientProp.masterNode" required />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.masterNode)"><cv:msg key="error.masterNode" bundle="dr" /></span>
									</div>
									<label class="col-xs-12 col-md-4 col-lg-4" for="masterNodePort"> <cv:msg key="label.masterNodePort" bundle="dr" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="number" name="masterNodePort" id="masterNodePort" min="0" max="65535" data-ng-model="collectionInfo.hcSubclientProp.masterNodePort" />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.masterNodePort)"><cv:msg key="error.masterNodePort" bundle="dr" /></span>
									</div>
									<label class="col-xs-12 col-md-4 col-lg-4" for="userName"> <cv:msg key="label.userName" bundle="dr" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="text" name="userName" id="userName" data-ng-model="collectionInfo.hcSubclientProp.userName" required />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.userName)"><cv:msg key="error.mbfUserName" bundle="dr" /></span>
									</div>
									<label class="col-xs-12 col-md-4 col-lg-4" for="userPassword"> <cv:msg key="label.password" bundle="dr" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="password" name="userPassword" id="userPassword" data-ng-model="collectionInfo.hcSubclientProp.userPassword" required />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.userPassword)"><cv:msg key="error.mbfUserPassword" bundle="dr" /></span>
									</div>
									<label class="col-xs-12 col-md-4 col-lg-4" for="mbfTimeout"> <cv:msg key="label.mbfTimeout" bundle="dr" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<input type="number" name="mbfTimeout" id="mbfTimeout" min="0" data-ng-model="collectionInfo.hcSubclientProp.mbfTimeout" required />
										<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.mbfTimeout)"><cv:msg key="error.mbfTimeout" bundle="dr" /></span>
									</div>
								</div>
							</div>
						</div>

					<!-- // num of readers starts // -->
					<div data-ng-show="false">
						<label for="readers"><cv:msg key="label.readers" bundle="collections" />
							<input required type="number" id="readers" min="1" max="50" name="readers" data-ng-model="collectionInfo.readers" />
							<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.readers)"><cv:msg key="error.readers" bundle="collections" /></span>
						</label>
					</div>
					<!-- // num of readers end // -->
				</div><!-- // end global-options div // -->
				<!-- // Virtual Machine Backup Type starts // -->
				<div data-ng-show="false">
					<div class="modal-wrapper" >
						<label for="btAppConsistent" class="label"><cv:msg key="label.vmBackupType" bundle="collectionsJs" /></label>
						<div class="inline-wrapper larger-width">
							<div class="frequency">
								<label for="btAppConsistent" class="tight-line-height">
									<input id="btAppConsistent" type="radio" name=backupType value="APP" data-ng-model="collectionInfo.backupType" />
									<span class="hanging-indent">
										<cv:msg bundle="collectionsJs" key="label.appConsistentAll1" />
										<br />
										<span class="smaller-text"><cv:msg bundle="collectionsJs" key="label.appConsistentAll2" /></span>
									</span>
								</label>
								<label for="btCrashConsistent" class="tight-line-height">
									<input id="btCrashConsistent" type="radio" name="backupType" value="CRASH" data-ng-model="collectionInfo.backupType" />
									<span class="hanging-indent"><cv:msg bundle="collectionsJs" key="label.crashConsistentAll1" /><br />
										<span class="smaller-text"><cv:msg bundle="collectionsJs" key="label.crashConsistentAll2"/></span>
									</span>
								</label>
							</div>
						</div>
					</div>
					<!-- // Virtual Machine Backup Type ends // -->
				    <label data-ng-if="serverType && serverType=='VMW'" for="transportMode" class="select-label"><cv:msg key="label.transportMode" bundle="collectionsJs" />
						<select name="transportMode" data-ng-options="transportMd.value as transportMd.name for transportMd in transportModeTypes | orderBy: 'name'" data-ng-model="collectionInfo.transportMode" >
						<!-- <option value=""><fmt:message key="placeholder.vendorType" /></option> -->
						</select>
				   </label>
			   </div>
			  </div>
			  </div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
						<button id="addCollectionModa_preview_button_#7675" type="button" class="float-left btn btn-primary" data-ng-click="openPreviewDialog()"><cv:msg key="label.preview" bundle="collectionsJs"/></button> 
				  		<button id="addCollectionModal_button_#7455" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-if="!isAddServerWizard" data-ng-click="cancelAddCollection()"><cv:msg key="Cancel" /></button>
				  		<button id="addCollectionModal_button_#3137" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="skip()" data-ng-if="isSetup && collectionsPresent ||isAddServerWizard"><cv:msg key="Skip" /></button>
				  		<button id="addCollectionModal_button_#5262"  type="submit" class="btn btn-primary cvBusyOnAjax">{{submit}}</button>
				  		<!--  <button id="addCollectionModal_button_#3225"  data-ng-if="isAddServerWizard" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Next" /></button>-->
				  	</fmt:bundle>
				</div>
			</div>
			</form>
			<div class="button-container centered" data-ng-show="formConfig.hide">
				<fmt:bundle basename="localization.messages">
					<button id="addCollectionModal_button_#4397" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><fmt:message key="Continue" /></button>
				</fmt:bundle>
			</div>
		</div>
	</div>
</fmt:bundle>
