<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.mode == 'replicationTarget'">
	<label class="col-xs-12 col-md-5 col-lg-5" for="compartment"><cv:msg
			key="label.compartment" bundle="restore"></cv:msg> </label>
	<div class="col-xs-12 col-md-7 col-lg-7">
		<isteven-multi-select
			input-model="rOCICompartmentsSettings.compartments"
			output-model="rOCICompartmentsSettings.compartment"
			button-label="displayName" item-label="displayName"
			selection-mode="single" tick-property="selected"
			class="isteven-multi-select user-group-select" id="compartment"
			name="displayName" max-labels="1" helper-elements="filter"
			search-property="displayName" translation="localLangCompartment"
			on-item-click="rOCICompartmentsSettings.setCompartment(data)">
		</isteven-multi-select>
		<div class="help-block"
			data-ng-if="rOCICompartmentsSettings.compartmentError.message">
			<i class="ion-alert-circled"></i>{{rOCICompartmentsSettings.compartmentError.message}}
		</div>
	</div>
</div>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true &&
	rOCICompartmentsSettings.mode == 'replicationTarget'" data-ng-disabled="rOCICompartmentsSettings.disableADomain">
	<label class="col-xs-12 col-md-5 col-lg-5" for="aDomain"><cv:msg
			key="label.availabilityDomain" bundle="restore"></cv:msg></label>
	<div class="col-xs-12 col-md-7 col-lg-7">
		<isteven-multi-select
			input-model="rOCICompartmentsSettings.availabilityDomains"
			output-model="rOCICompartmentsSettings.availabilityDomain"
			button-label="name" item-label="name" selection-mode="single"
			tick-property="selected"
			class="isteven-multi-select user-group-select" id="aDomain"
			name="name" max-labels="1" helper-elements="filter"
			search-property="name" translation="localLangADomain"
			on-item-click="rOCICompartmentsSettings.setADomain(data)">
		</isteven-multi-select>
		<div class="help-block"
			data-ng-if="rOCICompartmentsSettings.aDomainError.message">
			<i class="ion-alert-circled"></i>{{rOCICompartmentsSettings.aDomainError.message}}
		</div>
	</div>
</div>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true &&
	rOCICompartmentsSettings.mode == 'replicationTarget'" data-ng-disabled="rOCICompartmentsSettings.disableCloudNetwork">
	<label class="col-xs-12 col-md-5 col-lg-5" for="cloudNetwork"><cv:msg
			key="label.virtualCloudNetwork" bundle="restore"></cv:msg></label>
	<div class="col-xs-12 col-md-7 col-lg-7">
		<isteven-multi-select
			input-model="rOCICompartmentsSettings.cloudNetworks"
			output-model="rOCICompartmentsSettings.cloudNetwork"
			button-label="networkName" item-label="networkName"
			selection-mode="single" tick-property="selected"
			class="isteven-multi-select user-group-select" id="cloudNetwork"
			name="networkName" max-labels="1" helper-elements="filter"
			search-property="networkName" translation="localLangVCN"
			on-item-click="rOCICompartmentsSettings.setCloudNetwork(data)">
		</isteven-multi-select>
		<div class="help-block"
			data-ng-if="rOCICompartmentsSettings.vcnError.message">
			<i class="ion-alert-circled"></i>{{rOCICompartmentsSettings.vcnError.message}}
		</div>
	</div>
</div>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true &&
	rOCICompartmentsSettings.mode == 'replicationTarget'" data-ng-disabled="rOCICompartmentsSettings.disableCloudNetwork">
	<label class="col-xs-12 col-md-5 col-lg-5" for="subnet"><cv:msg
			key="label.subnet" bundle="restore"></cv:msg></label>
	<div class="col-xs-12 col-md-7 col-lg-7">
		<isteven-multi-select input-model="rOCICompartmentsSettings.subnets"
			output-model="rOCICompartmentsSettings.subnet" button-label="name"
			item-label="name"
			selection-mode="{{rOCICompartmentsSettings.selectionMode}}"
			tick-property="selected"
			class="isteven-multi-select user-group-select" id="subnet"
			name="name" max-labels="1" helper-elements="filter"
			search-property="name" translation="localLangSubnet"
			on-item-click="rOCICompartmentsSettings.setSubnet(data)">
		</isteven-multi-select>
		<div class="help-block"
			data-ng-if="rOCICompartmentsSettings.subnetError.message">
			<i class="ion-alert-circled"></i>{{rOCICompartmentsSettings.subnetError.message}}
		</div>
	</div>
</div>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true && !rOCICompartmentsSettings.isTenantAdmin" data-ng-disabled="rOCICompartmentsSettings.disableShape">
			<label class="col-xs-12 col-md-5 col-lg-5" for="shape"><cv:msg
					key="label.shape" bundle="restore"></cv:msg></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<isteven-multi-select input-model="rOCICompartmentsSettings.shapes"
					output-model="rOCICompartmentsSettings.shape" button-label="name"
					item-label="name"
					selection-mode="{{rOCICompartmentsSettings.selectionMode}}"
					tick-property="selected"
			class="isteven-multi-select user-group-select" id="shape" name="name"
			max-labels="1" helper-elements="filter" search-property="name"
			translation="localLangShape"
					on-item-click="rOCICompartmentsSettings.setShape(data)"
					on-close="rOCICompartmentsSettings.ociShapeChanged()">
				</isteven-multi-select>
				<div class="help-block"
					data-ng-if="rOCICompartmentsSettings.shapeError.message">
					<i class="ion-alert-circled"></i>{{rOCICompartmentsSettings.shapeError.message}}
				</div>
			</div>
		</div>
<div class="form-group"
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true && rOCICompartmentsSettings.mode === 'replicationTarget'">
	<uib-accordion close-others="true"> <cv-plain-accordion
		accordion-label="label.advanced.options"
		collapsed="rOCICompartmentsSettings.networkSettingsAccordion">
		<div class="form-group col-xs-12" data-ng-disabled="rOCICompartmentsSettings.disableBucket">
			<label class="col-xs-12 col-md-5 col-lg-5" for="stagingBucket"><cv:msg
					key="label.stagingBucket" bundle="restore"></cv:msg> <span
				class="optional-text"><cv:msg key="label.optional"
						bundle="restore" /></span></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<isteven-multi-select
					input-model="rOCICompartmentsSettings.stagingBuckets"
					output-model="rOCICompartmentsSettings.stagingBucket"
					button-label="name" item-label="name" selection-mode="single"
					tick-property="selected"
					class="isteven-multi-select user-group-select" id="stagingBucket"
					name="name" max-labels="1" helper-elements="filter"
					search-property="name" translation="localLangStagingBucket"
					on-item-click="rOCICompartmentsSettings.setStagingBucket(data)">
				</isteven-multi-select>
			</div>
		</div>
		<div class="form-group col-xs-12"
			data-ng-if="rOCICompartmentsSettings.showImagesAndSsh === true && rOCICompartmentsSettings.isRegularPolicy" data-ng-disabled="rOCICompartmentsSettings.disableImages">
			<label class="col-xs-12 col-md-5 col-lg-5" for="images"><cv:msg
				key="fs.keyword.fileextension.Image" bundle="search" /> <span
				data-ng-if="rOCICompartmentsSettings.mode === 'replicationTarget'"
				class="optional-text"><cv:msg key="label.optional"
						bundle="restore" /></span></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<isteven-multi-select input-model="rOCICompartmentsSettings.images"
					output-model="rOCICompartmentsSettings.selectedImages" button-label="name"
				selection-mode="multiple"	item-label="name" tick-property="selected"
				translation="localLangImage"
					class="isteven-multi-select user-group-select" id="images"
					name="name" max-labels="1"
					on-close="rOCICompartmentsSettings.setImage(rOCICompartmentsSettings.selectedImages)">
				</isteven-multi-select>
				<span class="help-block"
					data-ng-show="policyCreate.isImagesLoading && !policyCreate.isImagesListAvailable()">
					<cv:msg key="error.dataLoading" bundle="restore"></cv:msg>
				</span>
			</div>
		</div>
		<div class="form-group col-xs-12"
			data-ng-if="rOCICompartmentsSettings.showImagesAndSsh === true && rOCICompartmentsSettings.isRegularPolicy">
			<label class="col-xs-12 col-md-5 col-lg-5" for="sshKeys"><cv:msg
					key="label.sshKey" bundle="vmManagement" /> <span
				data-ng-if="rOCICompartmentsSettings.mode === 'replicationTarget'"
				class="optional-text"><cv:msg key="label.optional"
						bundle="restore" /></span></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<span class="btn btn-default btn-file btn-file-fullWidth"> <span
					class="btn-text sshKeyFileName">{{rOCICompartmentsSettings.sshKeyFileName}}</span>
					<cv-file-input file-input="rOCICompartmentsSettings.file"
						on-change="rOCICompartmentsSettings.fileUpload()"></cv-file-input>
				</span>
			</div>
		</div>
	<div class="form-group col-xs-12">
		<label class="col-xs-12">
				<toggle-control
					status="rOCICompartmentsSettings.createPublicIp"
					data-ng-click="rOCICompartmentsSettings.managePublicIPActivity()"
					title="Enable/disable"> </toggle-control>
			<span class="no-padding"><cv:msg key="label.createPublicIp" bundle="restore" /></span>
		</label>
	</div>
	</cv-plain-accordion> </uib-accordion>
</div>
<div
	data-ng-if="rOCICompartmentsSettings.showComponenets ===  true && rOCICompartmentsSettings.mode !== 'replicationTarget'">
	<div class="form-group" data-ng-if="!rOCICompartmentsSettings.isTenantAdmin">
		<label class="col-xs-12 col-md-5 col-lg-5" for="stagingBucket"><cv:msg
				key="label.stagingBucket" bundle="restore"></cv:msg> <span
			class="optional-text"><cv:msg key="label.optional"
					bundle="restore" /></span></label>
		<div class="col-xs-12 col-md-7 col-lg-7">
			<isteven-multi-select
				input-model="rOCICompartmentsSettings.stagingBuckets"
				output-model="rOCICompartmentsSettings.stagingBucket"
				button-label="name" item-label="name" selection-mode="single"
				tick-property="selected"
				class="isteven-multi-select user-group-select" id="stagingBucket"
				name="name" max-labels="1" helper-elements="filter"
				search-property="name" translation="localLangStagingBucket"
				on-item-click="rOCICompartmentsSettings.setStagingBucket(data)">
			</isteven-multi-select>
		</div>
	</div>
	<div class="col-md-12 form-group" data-ng-if="!rOCICompartmentsSettings.isTenantAdmin">
			<toggle-control
				status="rOCICompartmentsSettings.createPublicIp"
				data-ng-click="rOCICompartmentsSettings.managePublicIPActivity()"
				title="Enable/disable"> </toggle-control>
		<label for="autoDeployment">
			<cv:msg key="label.createPublicIp" bundle="restore" /></label>
	</div>
</div>