/*
 * Utility methods for search components
 * Use closure instead of prototype as there will be only one instance of this class.
 */
if (typeof String.prototype.endsWith !== 'function') {
	String.prototype.endsWith = function(suffix) {
		return this.indexOf(suffix, this.length - suffix.length) !== -1;
	};
}
if (typeof String.prototype.startsWith !== 'function') {
	String.prototype.startsWith = function(prefix) {
		return this.indexOf(prefix, 0) !== -1;
	};
}
var cvSearchUtil = (function() {

	return {
		/*
		 * Given an array of objects (arr), return an object which has value (v) for the key (k) defined in
		 * the keyValPairs obj
		 */
		getObjectIndexByKeyValue : function(arr, keyValPairs, isCaseInSensitive) {
			var objToReturn = null;
			var index = -1;
			$.each(arr, function(i, obj) {
				if (!$.isEmptyObject(obj)) {
					var isAllMatch = true;
					$.each(keyValPairs, function(k, v) {
						var objV = obj[k];
						// use typeof instead of simple objV check because when objV = 0, logic will go wrong						
						if (!(typeof (objV) !== "undefined" && (objV == v || (isCaseInSensitive && typeof(objV) === "string" && typeof(v) === "string" && objV.toLowerCase() === v.toLowerCase())))) { 
							// if value is defined and they are not equal, check if values are instance of moment object
							// if moment object and their timestamp is unequal then allmatch=false
							if (typeof (objV) === "object" && moment.isMoment(objV) && typeof (v) === "object" &&
									moment.isMoment(v)) {
								if (objV.unix() != v.unix()) {
									isAllMatch = false;
									return; // break the each loop
								}
							} else {
								isAllMatch = false;
								return; // break the each loop

							}

						}
					});
					if (isAllMatch) {
						objToReturn = obj;
						index = i;
						return; // break the each loop
					}
				}
			});
			return {
				"index" : index,
				"obj" : objToReturn
			};
		},
		getObjectByKeyValue : function(arr, keyValPairs, isCaseInSensitive) {
			return this.getObjectIndexByKeyValue(arr, keyValPairs, isCaseInSensitive).obj;

		},
		getIndexByKeyValue : function(arr, keyValPairs) {
			return this.getObjectIndexByKeyValue(arr, keyValPairs).index;
		},
		isObjectByKeyValueExist : function(arr, k, v) {
			var o = {};
			o[k] = v;
			if (this.getIndexByKeyValue(arr, o) > -1) {
				return true;
			}
			return false;
		},
		/*
		 * Given an array of objects (arr), return sorted array based on the key (k)
		 */
		sortArrayByKey : function(arr, k, sortDir) {
			var sortedArr = $.extend(true, [], arr);
			var dir = (typeof sortDir !== "undefined" && sortDir === "desc") ? -1 : 1;
			sortedArr.sort(function(o1, o2) {
				return cvSearchUtil.compareObjectByKey(o1, o2, k, dir);
			});
			return sortedArr;
		},
		compareObjectByKey : function(o1, o2, k, dir) {
			var v1 = (typeof (o1[k]) === "undefined") ? 999 : o1[k];
			var v2 = (typeof (o2[k]) === "undefined") ? 999 : o2[k];
			//we are converting values into Uppercase string so that sorting will be case insensitive
			if(typeof v1 === "string") 
				v1 = v1.toUpperCase();	
			
			if(typeof v2 === "string")		
				v2 = v2.toUpperCase();
			
				
			if (v1 < v2) {
				return -1 * dir;
			}
			if (v1 > v2) {
				return 1 * dir;
			}
			return 0;
		},
		/*
		 * Input: str - a,b,c, Input: char - , Output: a,b,c
		 */
		rtrim : function(str, char) {
			if (str && char && str.endsWith(char) && str.length > 1) {
				return str.substring(0, str.length - 1);
			}
			return str;
		},
		/*
		 * Input: str - (a,b,c), char1 - (, char2 - ), Output: a,b,c
		 */
		trim : function(str, char1, char2) {
			if (str && char1) {
				if (str.endsWith(char2) && str.length > 1) {
					str = str.substring(0, str.length - 1);
				}
				if (str.startsWith(char1) && str.length > 1) {
					str = str.substring(1);
				}
			}
			return str;
		},
		/*
		 * Input: str - solr Input: char - / Output: solr/
		 */
		appendChar : function(str, char) {
			if (str && char && !(str.endsWith(char))) {
				return str + char;
			}
			return str;
		},
		/*
		 * Input: str - solr Input: char - / Output: /solr
		 */
		prependChar : function(str, char) {
			if (str && char && !str.startsWith(char)) {
				return char + str;
			}
			return str;
		},

		/* refer http://jsperf.com/array-unshift-vs-prepend */
		prependArray : function(value, oldArray) {
			var i, len = oldArray.length, newArray = new Array(len + 1);
			newArray[0] = value;
			for (i = 0; i < len; i++) {
				newArray[i + 1] = oldArray[i];
			}
			return newArray;
		},

		/*
		 * Input: str - accesstime:[2014-10-01T00:10:00Z TO 2014-11-06T23:11:99Z] char - : Output: arr =
		 * ["accesstime","[2014-10-01T00:10:00Z TO 2014-11-06T23:11:99Z]"]
		 */
		splitByFirstChar : function(str, c) {
			var arr = [];
			if (str) {
				var i = str.indexOf(c);
				if (i > -1) {
					arr.push(str.substring(0, i));
					arr.push(str.substring(i + 1));
				}
			}
			return arr;
		},
		/*
		 * Input: "sea.ColumnConfiguration.searchResultTmpl" context: window Output: Output from the method
		 */
		executeFunctionByName : function(functionName, context /* , args */) {
			var args = [].slice.call(arguments).splice(2);
			var namespaces = functionName.split(".");
			var func = namespaces.pop();
			for (var i = 0; i < namespaces.length; i++) {
				context = context[namespaces[i]];
			}
			return context[func].apply(this, args);
		},
		/*
		 * Input: "sea.ColumnConfiguration.searchResultTmpl" context: window Output: Function
		 */
		getFunctionByName : function(functionName, context) {
			if (!context) {
				context = window;
			}
			var namespaces = functionName.split(".");
			var func = namespaces.pop();
			for (var i = 0; i < namespaces.length; i++) {
				context = context[namespaces[i]];
			}
			return context[func];
		},
		/*
		 * Returns the modified/new values from object o2 Input: o1 : { x: "abcd", y: 2 }, o2 : { x: "efgh",
		 * y: 2, z: 2.5} Output: { x:"efgh",z:2.5}
		 */
		getDiffObjects : function(o1, o2) {
			var _o1 = $.extend({}, o1);
			var _o2 = $.extend({}, o2);
			if ($.isEmptyObject(_o1) || $.isEmptyObject(_o2)) {
				return o2;
			}
			var objToReturn = {};
			$.each(_o1, function(k, v) {
				if (_o2.hasOwnProperty(k)) {
					if (_o2[k] != v) {
						objToReturn[k] = _o2[k];
					}
					delete _o2[k];
				}
			});
			// copy the remaining properties from o2 to return
			objToReturn = $.extend(objToReturn, _o2);
			return objToReturn;
		}
	};
}());
