/*!
 * jQuery plugin
 * Component for search results view
 */

(function(factory) {
	var getDependencyMissingMsg = function(dependency) {
		return "cvBreadCrumbs depends on " + dependency + " and seems to be missing. Please include necessary files.";
	};
	if (!jQuery)
		throw getDependencyMissingMsg('jQuery');
	else
		factory(jQuery);

}(function($) {
	"use strict";

	/**
	 * @function
	 * @name cvBreadCrumbs
	 * @Description Creates a new cvBreadCrumb with given configuration
	 */
	$.fn.cvBreadCrumb = function(config) {

		return this.each(function() {
			var $this = $(this), data = $this.data('cvBreadCrumb');
			if (!data)
				$this.data('cvBreadCrumb', new BreadCrumb(this, config));
			this.testFunc = 13;
			return $this;
		});

	};
	$.fn.cvBreadCrumb.id = 0;
}));

function BreadCrumb(element, config) {
	this.$element = $(element);
	this._origConfig = config;
	this._config = $.extend(true, {}, this.defaults, config);
	this.tip = null;
	this._id = $.fn.cvBreadCrumb.id++;
	this._init();
	this._render();
}

function Crumb(name) {
	this.name = name;
	this.params = {
		level : 0
	}
	this.next = null;
	this.parent = null;
}

BreadCrumb.prototype.Constants = {
	BREADCRUMB_HOLDER : "cvBreadCrumbHolder",
	CRUMB : "crumb"
}

BreadCrumb.prototype.defaults = {
	levelZeroName : "",
	//breadCrumbs won't be shown in DOM until this many levels have been added
	breadCrumbRenderFromLevel : 0,
	levelZeroResets : false,
	crumbClickSelector : "",
	levelSeperator : "<span class='ico-keyboard-arrow-right seperator' style='margin-left: 5px; margin-right: 5px;'></span>",
	fnCrumbTmpl : function(crumb) {
		return $("<span>" + crumb.name + "</span>");
	}
}

BreadCrumb.prototype._init = function() {
	this.$element.append(this._getHolderHtml());

	//if levelZeroName is specified, already start with the initial node. Else, the user has to add the starting
	//node by calling addLevel
	//ToDo: A more intuitive name than levelZeroName? How about startWithLevel?
	if (this._config.levelZeroName.length > 0) {
		this.chain = new Crumb(this._config.levelZeroName);
		this.tip = this.chain;
	}

	this._attachListeners();
}

BreadCrumb.prototype._getHolderHtml = function() {
	var crumbHolder = $("<div class='" + this.Constants.BREADCRUMB_HOLDER + "'></div>")
	return crumbHolder;
}

BreadCrumb.prototype._render = function() {
	var fn = null;
	if (!this.tip || this.tip.params.level < this._config.breadCrumbRenderFromLevel)
		return;
	if (typeof this._config.fnCrumbTmpl === "function") {
		fn = this._config.fnCrumbTmpl;
		this._renderCrumbs(fn);
	} else if (typeof this._config.fnCrumbTmpl === "string") {
		fn = cvSearchUtil.getFunctionByName(fn);
		this._renderCrumbs(fn);
	}
}

BreadCrumb.prototype._renderCrumbs = function(fn) {
	for (var level = 0, head = this.chain; head != null; head = head.next, level++) {
		var currentCrumb = head;
		var crumbHtml = fn(currentCrumb);
		var crumbWrapper = $("<span class='" + this.Constants.CRUMB + "' data-level=" + level + "></span>")
		if (head.next == null)
			crumbWrapper.addClass("leaf");
		crumbWrapper.append(crumbHtml);
		if (level > 0)
			this.$element.find("." + this.Constants.BREADCRUMB_HOLDER).append(this._config.levelSeperator);

		this.$element.find("." + this.Constants.BREADCRUMB_HOLDER).append(crumbWrapper);
	}
}

//options is a json object
BreadCrumb.prototype.addLevel = function(name, options) {
	if (!this.tip) {
		this.chain = new Crumb(name);
		this.tip = this.chain;
	} else {
		this.tip.next = new Crumb(name);
		var parent = this.tip;
		this.tip = this.tip.next;
		this.tip.parent = parent;
		this.tip.params.level = this.tip.parent.params.level + 1;
	}

	for ( var property in options) {
		if (options.hasOwnProperty(property))
			this.tip.params[property] = options[property];
	}
	this.redraw();
};

BreadCrumb.prototype.updateLevel = function(level, name, options) {
	for (var head = this.chain; head != null; head = head.next) {
		if (head.params.level == level) {
			head.name = name;
			if (!options)
				break;
			else {
				for ( var property in options) {
					if (options.hasOwnProperty(property))
						head[property] = options[property];
				}
			}
		}
	}
	this.redraw();
};

BreadCrumb.prototype.removeLevel = function(level) {
	for (var i = 0, head = this.chain; i <= level; i++, head = head.next) {
		var flag = 0;

		if (i == level) {
			var toSendParams = null;

			this.tip = head;
			toSendParams = head.params;
			head.next = null;

			if (this._config.levelZeroResets && level == 0) {
				//special case: going to level 0.
				flag = 1;
			}

			this.redraw();
			var context = this;
			if (this._config.callbackContext)
				context = this._config.callbackContext;

			this.$element.trigger("cvBreadCrumbRemoveLevel", toSendParams);

			if (flag)
				break;
		}
	}
};

BreadCrumb.prototype.getTipLevel = function() {
	return this.tip.params.level;
}
BreadCrumb.prototype.getParamsByLevel = function(level) {
	for (var head = this.chain; head != null; head = head.next) {
		if (head.params.level == level)
			return head.params;
	}

	return false;
}

BreadCrumb.prototype.redraw = function() {
	this.$element.find("." + this.Constants.BREADCRUMB_HOLDER).empty();
	this._render();
	this._attachListeners();
}

BreadCrumb.prototype._attachListeners = function() {
	var self = this;
	if (this._config.crumbClickSelector) {
		this.$element.find("." + this.Constants.CRUMB).off("click").on("click",
				this._config.crumbClickSelector,
				function() {
					if ($(this).parents().find(".crumb").hasClass("leaf"))
						return;
					self.removeLevel($(this).data('level'));
				})
	} else {
		this.$element.find("." + this.Constants.CRUMB).off("click").on("click", function(e) {
			//do nothing if a leaf node
			if ($(this).hasClass("leaf"))
				return;

			self.removeLevel($(this).data('level'));
		});
	}
}
