<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib uri="/WEB-INF/webenhance.tld" prefix="wae"%>


<c:set var="tileReport" value = "false"/>
<c:if test="${param.tile == true && applicationScope.showTileBuilder == 'true' }">
	<c:set var="tileReport" value = "true"/>
</c:if>


<div class="sechead dynamicDropDown vw-row">
	<c:if test="${param.changePage != null && param.changePage != ''}">
		<c:choose>
		<c:when test="${param.isCustomReports =='true'}">
			<ul id='breadcrumbMain' class='breadcrumbMain2 vw-breadcrumbs vw-small vw-col-sm-12 hideOnExportFriendly'>
		</c:when>
		<c:otherwise>
			<ul id='breadcrumbMain' class='breadcrumbMain vw-breadcrumbs vw-small vw-col-sm-12 hideOnExportFriendly'>
		</c:otherwise>
		</c:choose>

		<li class="secTitleClickable smartlinkMain withSeparatorMain vw-breadcrumb-with-separator">
			<a class="smartLinkMain" href="${pageContext.request.contextPath}/survey/reports/dashboard.jsp"></a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg>
		</li>
		<c:set var="ReportsLink" value="${pageContext.request.contextPath}/reports/index.jsp?page=Reports"/>
        <c:if test="${sessionScope.SurveySingleCommcellUser != null}">
        	<c:set var="ReportsLink" value="${pageContext.request.contextPath}/survey/reports/commcellmonitoring.jsp?commUniId=${sessionScope.SurveySingleCommcellUser}"/>
        </c:if>
				<c:choose>
					<c:when test="${param.customDashBoard != null && param.customDashBoard != '' && param.customDashBoard != 'undefined'}">
					<ul id='breadcrumbMain' class='breadcrumbMain vw-breadcrumbs vw-small vw-col-sm-12'>
						<li class='smartlinkMain withSeparatorMain vw-breadcrumb-with-separator'><a class='smartLinkMain'  href='${ReportsLink}'>Reports</a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg></li>
						<li class='smartLinkMain dashboardList repDropdown'>Dashboard</li>
						<span class="sprite icon-arrow-dropdown hideOnExportFriendly" alt="down"></span>
						<span class='dashboardTitle'></span>
					</ul>
					</c:when>
					<c:when test="${empty param.commUniId}">
						<li class='secTitleClickable smartlinkMain withSeparatorMain vw-breadcrumb-with-separator repDropdown repDropdownTitle'>
							<a class='smartLinkMain'  href='${ReportsLink}'>Reports</a>
							<span class="sprite icon-arrow-dropdown hideOnExportFriendly" alt="down"></span><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg>
						</li>
					</c:when>
					<c:otherwise>
						<li class="secTitleClickable smartlinkMain withSeparatorMain vw-breadcrumb-with-separator">
							<a class="smartLinkMain" href="${pageContext.request.contextPath}/survey/reports/monitoringform.jsp">CommCells</a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8"><path d="M5,4.5l-5,3V6.1L4,4,0,1.7V0.5l5,3v1Z"/></svg>
						</li>
						<li class='secTitleClickable smartlinkMain withSeparatorMain vw-breadcrumb-with-separator repDropdown'>
							<a class='smartLinkMain'  href='${pageContext.request.contextPath}/survey/reports/commcellmonitoring.jsp?commUniId=${fn:escapeXml(param.commUniId)}'>Reports</a>
							<span class="sprite icon-arrow-dropdown hideOnExportFriendly" alt="down"></span><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg>
						</li>
					</c:otherwise>
				</c:choose>
				<c:if test="${param.exportType == null || empty param.exportType}">
					<li>
						<%@ include file="../common/pageSelection.jsp" %>
					</li>
				</c:if>
		<li><span class="custom-report-deployed-version"></span></li>
		<li><span class="custom-report-version"></span></li>
		</ul>
		<div id="generatedOnText" class="showOnExportFriendly rghtFloat clearfix reportView generatedOnSpan">
			<f:message key="GeneratedOn" /> <span id="generatedOnSpan"></span>
		</div>
	</c:if>
		<div id="secTitleDiv" class="clearfix">
		<c:if test="${param.includeTitle == null || (param.includeTitle != null && param.includeTitle != false)}">
			<inplace model="customReport.report.customReportName" ng-attr-placeholder="Untitled Report" id="sectionTitle" class="sectiontitle vw-page-title input-title" tooltip-placement="bottom" uib-tooltip="Rename" tooltip-enable="reportMode === 'builder'"/>
		</c:if>
		</div>
	<div id="views" uib-dropdown data-ng-show="pageViews && pageViews.length > 0">
		<span data-ng-include="'${pageContext.request.contextPath}/reportsplus/views/views.jsp'"></span>
	</div>
	<fmt:bundle basename="localization.ReportsMessages">
	<c:if test="${param.editEnabled != null && param.editEnabled == true}">
			<div id="reportButton" class="reportActionButtons"> <span class="reportActionButtonLabel">File</span> <span class="sprite icon-arrow-dropdown"></span>
							<div id="reportActionMenu" class="actionMenu">
								<ul id="reportMenu">
								<c:choose>
									<c:when test="${tileReport == true}">
										<li id="buildHealthTile"  class="actionMenuItem"><div id="newTileImageWrapper"><span class="sprite reports-actions-newtile"> </span></div><div class="actionMenuItemLabel"><span ><fmt:message key="CustomReport.New"/></span></div></li>
									</c:when>
									<c:otherwise>
										<li id="buildYourOwnReport"  class="actionMenuItem"><div class="actionMenuItemLabel"><span ><fmt:message key="CustomReport.New"/></span></div></li>
									</c:otherwise>
								</c:choose>
									<li data-ng-show="canDeleteReport" id="deleteButton" data-reportid="${fn:escapeXml(param.reportId)}" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Delete"/></span></div></li>
									<li id="securityButton" data-reportid="${fn:escapeXml(param.reportId)}" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Security"/></span></div></li>
									<li id="saveAsButton"  data-reportid="${fn:escapeXml(param.reportId)}" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Clone"/></span></div></li>
								</ul>
							</div>
			</div>


			<c:if test="${applicationScope.cloudSurveyEnabled == 'false' || sessionScope.cloudSurveyAdminUser == 'true'}">
				<div id="actionsButton" class="reportActionButtons"> <span class="reportActionButtonLabel"><fmt:message key="CustomReport.Actions"/></span> <span class="sprite icon-arrow-dropdown"></span>
					<div id="moreActionMenu" class="actionMenu">
						<ul id="moreMenu">
							<c:if test="${ sessionScope.COMMUNITY_REPORTS_IS_SUPPORTED == true}">
								<li id="publishToCloudButton" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.PublishToCloud"/></span></div></li>
							</c:if>
							<li id="importReportButton"  class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.ImportTemplate"/></span></div></li>
							<li id="exportReportButton"  class="actionMenuItem" data-ng-click="exportTemplate()"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.ExportTemplate"/></span></div></li>
							<c:if test="${sessionScope.readmeExportEnabled}">
								<li id=exportReadMeButton  class="actionMenuItem exportReadme"><div class="actionMenuItemLabel"><span ><fmt:message key="CustomReport.ExportPreview"/></span></div></li>
							</c:if>
							<li id="settingsLink"  class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="reportmanager"/></span></div></li>
						</ul>
					</div>
				</div>
			</c:if>
			<div id="saveButton" class="reportActionButtons" title="<fmt:message key="CustomReport.Save"/>"> <span class="reportActionButtonLabel"><fmt:message key="CustomReport.Save"/></span></div>
			<c:choose>
				<c:when test="${applicationScope.cloudSurveyEnabled == 'true'}">
					<div id="submitButton" class="reportActionButtons survey-button" title="Submit"> <span class="reportActionButtonLabel"><fmt:message key="Submit"/></span></div>
					<c:if test="${sessionScope.cloudSurveyAdminUser == 'true'}">
						<div id="surveyCloudDeployButton" class="reportActionButtons" title="<fmt:message key="CustomReport.CloudDeployment"/>" data-ng-show="customDCReportStatus == 0"> <span class="reportActionButtonLabel"><fmt:message key="CustomReport.CloudDeployment"/></span></div>
						<div id="deployButton" class="reportActionButtons" title="Deploy Report" > <span class="reportActionButtonLabel"><fmt:message key="CustomReport.Deploy"/></span></div>
					</c:if>
				</c:when>
				<c:otherwise>
					<div id="deployButton" class="reportActionButtons" title="Deploy Report"> <span class="reportActionButtonLabel"><fmt:message key="CustomReport.Deploy"/></span></div>
				</c:otherwise>
			</c:choose>
<!-- 			<div id="previewButton" class="reportActionButtons sprite reports-builder-preview"> <span class="reportActionButtonLabel previewButtonLabel">Preview</span></div>	 -->
				<div id="previewButton" class="reportActionButtons" title="<fmt:message key="CustomReport.PreviewTooltip"/>">
				<div  class=" sprite reports-builder-preview">
				</div>
				<span id="previewButtonLabel" class="reportActionButtonLabel"><fmt:message key="CustomReport.Preview"/></span>
			</div>
			<div  id="refreshButton" class="reportActionButtons" >
				<div  class=" sprite icon-refresh">
				</div>
				<span id="previewButtonLabel" class="reportActionButtonLabel" title="<fmt:message key="CustomReport.RefreshComponents"/>"><fmt:message key="CustomReport.Refresh"/></span>
			</div>
			<div  id="openReportButton" class="reportActionButtons" title="<fmt:message key="CustomReport.OpenReportTooltip"/>">
				<div class="sprite reports-openreport"></div>
				<span id="openReportButtonLabel" class="reportActionButtonSpriteLabel"><fmt:message key="CustomReport.OpenReport"/></span>
			</div>
			<c:if test="${param.customDashboard == null || empty param.customDashboard}">
				<div  id="saveAsView" class="reportActionButtons hideOnExportFriendly">
					<div  class="sprite icon-eye"></div><span id="previewButtonLabel" class="reportActionButtonLabel" title="<fmt:message key="CustomReport.SaveAsViewDescription"/>"><fmt:message key="CustomReport.SaveAsView"/></span>
				</div>
			</c:if>
	</c:if>
	<c:if test="${param.viewEnabled != null && param.viewEnabled == true}">
		<c:if test="${param.customDashboard == null || param.customDashboard == false}">
		<div id="reportButton" class="reportActionButtons hideOnExportFriendly" > <span class="reportActionButtonLabel"><fmt:message key="CustomReport.File"/></span> <span class="sprite icon-arrow-dropdown"></span>
					<div id="reportActionMenu" class="actionMenu hideOnExportFriendly">
						<ul id="reportMenu">
							<li id="exportAsButton" class="actionMenuItem"><div class="actionMenuItemLabel"><div id="exportRightArrow"><span><fmt:message key="CustomReport.SaveAs"/></span></div></div>
								<ul id ="exportMenu">
									<li id="exportpdf"  class="actionMenuItem exportatserver" data-ng-click="saveReportAs('pdf')"><div class=""><span class="imageSpan sprite icon-export-pdf"></span><span class="textSpan">PDF</span></div></li>
									<li data-ng-if="page && !isDataCubeDataSetExist()" id="exportCsv"  class="actionMenuItem exportatserver" data-ng-click="saveReportAs('csv')"><div class=""><span class="imageSpan sprite icon-export-csv"></span><span class="textSpan">CSV</span></div></li>
									<li id="exporthtml"  class="actionMenuItem exportatserver" data-ng-click="saveReportAs('html')"><div class=""><span class="imageSpan sprite icon-export-html"></span><span class="textSpan">HTML</span></div></li>
								</ul>
							</li>
							<!-- Print Option Deprecated -->
							<li id="exportSchedule"  class="actionMenuItem exportSchedule"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Schedule"/></span></div></li>
							<cv:reportsTag name="CustomReports" id="8">
								<li id="securityButton" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Security"/></span></div></li>
							</cv:reportsTag>
							<li id="exportEmail"  class="actionMenuItem exportSchedule "><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Email"/></span></div></li>
							<li id="downloadReports"  class="actionMenuItem downloadReports"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.DownloadReports"/></span></div></li>
							<c:if test="${param.customDashboard == null || empty param.customDashboard}">
							<cv:reportsTag name="CustomReports" id="8">
								<cv:reportsTag name="Reports.ManageReports" id="888">
					 				<li class="actionMenuItemSeparator"></li>
									<li data-ng-show="canEditReport" id="editLink"  class="actionMenuItem"><div class="actionMenuItemLabel"><span ><fmt:message key="CustomReport.Edit"/></span></div></li>
									<li data-ng-show="canDeleteReport" id="deleteButton" class="actionMenuItem"><div class="actionMenuItemLabel"><span><fmt:message key="CustomReport.Delete"/></span></div></li>
								</cv:reportsTag>
							</cv:reportsTag>
							</c:if>
						</ul>
					</div>
		</div>
		</c:if>
		<c:if test="${param.customDashboard != null && param.customDashboard != false}">
			<div id="securityButton" class="reportActionButtons"><span class="reportActionButtonLabel"><fmt:message key="CustomReport.Security"/></span></div>
			<div id="addNewReport" title="Add new report" class="reportActionButtons hideOnExportFriendly" data-ng-click="addNewTile()"><span  class="reportActionButtonLabel" title="Add report to Dashboard">Add Report</span></div>
			<div id="saveButton" class="reportActionButtons" title="<fmt:message key="CustomReport.Save"/>"> <span class="reportActionButtonLabel"><fmt:message key="CustomReport.Save"/></span></div>
			<script type="text/javascript" nonce="${sessionScope.cspNonce}">
				customReports.isDashboard = true;
			</script>
		</c:if>
		<div  id="refreshButton" class="reportActionButtons hideOnExportFriendly" >
				<div  class=" sprite icon-refresh">
				</div>
				<span id="previewButtonLabel" class="reportActionButtonLabel" title="<fmt:message key="CustomReport.RefreshComponents"/>"><fmt:message key="CustomReport.Refresh"/></span>
		</div>
		<c:if test="${param.customDashboard == null || empty param.customDashboard}">
			<div  id="saveAsView" class="reportActionButtons hideOnExportFriendly">
				<div  class="sprite icon-eye"></div><span id="previewButtonLabel" class="reportActionButtonLabel" title="<fmt:message key="CustomReport.SaveAsViewDescription"/>"><fmt:message key="CustomReport.SaveAsView"/></span>
			</div>
		</c:if>
	</c:if>
	<c:if test="${param.includeCrDescription != null && param.includeCrDescription != false}">
        	<div id="crdescription" class="crdescription"></div>
	</c:if>
	<c:if test="${param.editEnabled != null && param.editEnabled == true}">
			<div class="version-info"><span data-ng-show="customReport.deployedVersion > 0"><fmt:message key="CustomReport.DeployedVersion"/>
				<span class="custom-report-deployed-version" data-ng-show="customReport.deployedVersion && customReport.deployedVersion > 0"
					data-ng-bind="customReport.deployedVersion"></span></span>

					<span data-ng-show="customReport.reportVersion > 0">
					<fmt:message key="CustomReport.ReportVersion"/>
				<span
					class="custom-report-version"
					data-ng-bind="customReport.reportVersion"></span></span>
			</div>
		</c:if>
	</fmt:bundle>
</div>

