window.showAssociation = function(association, owner) {
  if (!owner) return true;

  return (owner.properties.isCreatorAssociation === false) ||
    !(((owner.userOrGroup[0].userId &&
        (association.userOrGroup[0].userId === owner.userOrGroup[0].userId)) ||
      (owner.userOrGroup[0].userGroupId &&
        (association.userOrGroup[0].userGroupId === owner.userOrGroup[0].userGroupId))
    ) && association.properties.isCreatorAssociation === false)
};

(function() {
  'use strict';

  var app = angular.module("reports");
  app
    .controller("showSecurityModalCtrl",
      [
        '$scope',
        'reportService',
        '$timeout',
        'customReportSvc',
        'entity',
        function($scope, reportService, $timeout, customReportSvc, entity) {
          $scope.entity = entity;
          $scope.userAssociations = [];
          $scope.currentUserOrGroups = [];
          $scope.userSearchResults = [];
          $scope.selectedUsers = [];
          $scope.showSearchresults = false;
          $scope.searchInProgress = false;
          $scope.selPermissions = {
        		  selectedPermissions : []
          }
          $scope.appName = customReports.appName;
          $scope.hasChanges = false;
          $scope.isLoading = true;
          $scope.CUSTOM_ENTITY_TYPE = "150";
          $scope.SEA_SEARCH_HANDLER_ENTITY = 157;
          var owner = null;

          $scope.permissionIdMappings = {
            31 : {
              "permissionId": 31,
              "permissionName" : "View",
              "permissionDesc" : "Can view",
              "categoryId" : 107,
              _type_ : 122
            },
            107 : {
              "permissionId" : 107,
              "permissionName" : "Change Security Settings",
              "permissionDesc" : "Can change the security settings",
              "categoryId" : 107,
              _type_ : 122
            },
            122 : {
              "permissionId" : 122,
              "permissionName" : "Edit Datasource",
              "permissionDesc" : "Can edit the datasource",
              "categoryId" : 110,
              _type_ : 122
            },
            123 : {
              "permissionId" : 123,
              "permissionName" : "Delete Datasource",
              "permissionDesc" : "Can delete the datasource",
              "categoryId" : 110,
              _type_ : 122
            },
            124 : {
              "permissionId" : 124,
              "permissionName" : "Query Datasource",
              "permissionDesc" : "Can query the datasource",
              "categoryId" : 110,
              _type_ : 122
            },
            130 : {
              "permissionId" : 130,
              "permissionName" : "Edit Report",
              "permissionDesc" : "Can edit the report",
              "categoryId" : 112,
              _type_ : 122
            },
            131 : {
              "permissionId" : 131,
              "permissionName" : "Delete Report",
              "permissionDesc" : "Can delete the report",
              "categoryId" : 112,
              _type_ : 122
            },
            132 : {
              "permissionId" : 132,
              "permissionName" : "Execute Report",
              "permissionDesc" : "Can view the data of the report",
              "categoryId" : 112,
              _type_ : 122
            },
            133 : {
              "permissionId" : 126,
              "permissionName" : "Edit Dataset",
              "permissionDesc" : "Can edit the dataset",
              "categoryId" : 112,
              _type_ : 122
            },
            134 : {
              "permissionId" : 127,
              "permissionName" : "Delete Dataset",
              "permissionDesc" : "Can delete the dataset",
              "categoryId" : 112,
              _type_ : 122
            },
            135 : {
              "permissionId" : 128,
              "permissionName" : "Query Dataset",
              "permissionDesc" : "Can view the data of the dataset",
              "categoryId" : 112,
              _type_ : 122
            },
            136 : {
              "permissionId" : 130,
              "permissionName" : "Edit Custom Dashboards",
              "permissionDesc" : "Can edit the report",
              "categoryId" : 112,
              _type_ : 122
            },
            137 : {
              "permissionId" : 131,
              "permissionName" : "Delete Custom Dashboards",
              "permissionDesc" : "Can delete the report",
              "categoryId" : 112,
              _type_ : 122
            },
            138 : {
              "permissionId" : 132,
              "permissionName" : "Execute Custom Dashboards",
              "permissionDesc" : "Can view the data of the report",
              "categoryId" : 112,
              _type_ : 122
            },
            235 : {
              "permissionId" : 235,
              "permissionName" : "Change Table Schema",
              "permissionDesc" : "Can change the schema of the table",
              "categoryId" : 230,
              _type_ : 122
            },
            236 : {
              "permissionId" : 236,
              "permissionName" : "Access Records",
              "permissionDesc" : "Can access records",
              "categoryId" : 230,
              _type_ : 122
            },
            238 : {
              "permissionId" : 238,
              "permissionName" : "Change App Schema",
              "permissionDesc" : "Can change application schema",
              "categoryId" : 231,
              _type_ : 122
            },
            239 : {
              "permissionId" : 239,
              "permissionName" : "Access App",
              "permissionDesc" : "Can access application",
              "categoryId" : 231,
              _type_ : 122
            },
            204 : {
              "permissionId" : 204,
              "permissionName" : "Data Cube Execute",
              "categoryId" : 130,
              _type_ : 122
            }
          };

          $scope.entityPermissionMappings = {
            131 : [ 107, 130, 131, 132 ],
            129 : [ 107, 133, 134, 135 ],
            128 : [ 122, 123, 124 ],
            1 : [ 122, 123, 124 ],
            179 : [ 236, 235, 107, 31 ],
            180 : [ 239, 238, 107, 31 ]
          };

          $scope.currentPermissionsIds = $scope.entityPermissionMappings[$scope.entity.entityType];
          if($scope.entity.entityType === 131 && $scope.entity.entitySubType === 'CustomDashboards'){
        	  $scope.currentPermissionsIds = [ 107, 136, 137, 138 ];
          }

          $scope.currentPermissionsList = [];
          for (var i = 0; i < $scope.currentPermissionsIds.length; i++) {
            $scope.currentPermissionsList
              .push($scope.permissionIdMappings[$scope.currentPermissionsIds[i]]);
          }

          $scope.updateSecurityRequest = {
            "entityAssociated" : {
              "entity" : [ {
                "entityType" : $scope.entity.entityType === 182 ? 131 : $scope.entity.entityType,
                "entityId" : $scope.entity.entityId,
                _type_ : $scope.CUSTOM_ENTITY_TYPE,
                entityTypeName : "Report"
              } ]
            },
            "securityAssociations" : {
              "associations" : [

              ],
              "associationsOperationType" : "OVERWRITE",
              "processHiddenPermission" : 1
            }
          };

          $scope.setOperation = function(value) {
            $scope.canEdit = "" + value;
            switch ($scope.canEdit) {
              case '0':
                $scope.operation = localMsg.customReport.canView;
                break;
              case '1':
                $scope.operation = localMsg.customReport.canEdit;
                break;
              case '2':
                $scope.operation = localMsg.customReport.canQuery;
                break;
              case '3':
                $scope.operation = localMsg.customReport.canEdit;
                break;
              default:

            }
          };

          if ($scope.entity.entityId && $scope.entity.entityType) {
            reportService
              .getDataForDataSetViaProxy("Security/" + $scope.entity.entityType + "/" +
                $scope.entity.entityId+"?processHiddenPermission=1",
                "/api/")
              .then(function(data) {
                  var associations = data.data.securityAssociations[0].securityAssociations.associations || [];
                  var ownerId = null;
                  owner = associations.find(function (e, i) {
                    ownerId = i;
                    return e.properties.isCreatorAssociation === true;
                  });
                  if (owner) {
                    associations.splice(ownerId, 1);
                    associations.splice(0, 0, owner);
                  }
                  $scope.updateSecurityRequest.securityAssociations.associations = associations;
                  $scope.isLoading = false
                },
                function(error) {
                  alert(error.data);
                  $scope.child.masked = false;
                });
          }
          var searchTimeout = null;
          /*
           * $scope.searchUsersList = function() { if ($scope.usearSearechText &&
           * searchTimeout) { $timeout.cancel(searchTimeout); } var searchTimeout =
           * $timeout(function() {
           * reportService.searchUsers($scope.usearSearechText).then(function(data) {
           * $scope.userSearchResults = JSON.parse(data.data.responseList);
           * $scope.showSearchresults = true; }, function(error) { alert(error.data);
           * $scope.child.masked = false; }); }, 150) }
           */
          var promise = '';
          $scope.searchUsersList = function() {
            if (promise) {
              $timeout.cancel(promise);
            }

            if (!$scope.usearSearechText) {
              $scope.userSearchResults = [];
              $scope.showSearchresults = false;
              $scope.searchInProgress = false;
              return;
            }
            $scope.searchInProgress = true;
            var url = "getADUserSuggestions?namePattern=" +
            encodeURIComponent($scope.usearSearechText) +
              "&pageSize=10&getDomainUsers=true&getCommcellUsers=true&getDomainGroups=true&getCommCellGroups=true&searchOnDisplayName=true&searchOnAliasName=true&ignoreSmtpRule=true"
            promise = $timeout(function() {
              reportService.getDataForDataSetViaProxy(url, "/api/").then(function(data) {
                //reportService.searchUsers($scope.usearSearechText).then(function(data) {
                $scope.searchInProgress = false;
                $scope.userSearchResults = data.data.users;
                $scope.showSearchresults = !!(data && data.data && data.data.users && data.data.users.length);
              }, function(error) {
                alert(error.data);
                $scope.child.masked = false;
              });
            }, 500);
          };

          $scope.addUserToList = function(user, index) {
            $scope.selectedUsers.push(user);
            $scope.showSearchresults = false;
            $scope.usearSearechText = "";
          };

          $scope.addUsersToSecurity = function(user, index) {
            if ($scope.selPermissions.selectedPermissions.length > 0 && $scope.selectedUsers.length > 0) {
              $scope.hasChanges = true;
            }
            angular.forEach($scope.selectedUsers, function(user, index) {
              var usr;
              if (user.entityType === 3 || user.entityType === 4) {
                usr = {
                  "userName" : user.loginName,
                  _type_ : 13
                }

              } else if (user.entityType === 1 || user.entityType === 2) {
                usr = {
                  "userGroupName" : user.loginName,
                  _type_ : 15
                }
              }

              $scope.updateSecurityRequest.securityAssociations.associations.push({
                userOrGroup : [ usr ],
                properties : {
                  categoryPermission : {
                    categoriesPermissionList : $scope.selPermissions.selectedPermissions
                  },
                  isCreatorAssociation : false
                }
              });

            });

            $scope.selectedUsers = [];
            $scope.selPermissions.selectedPermissions = [];
          };

          $scope.getAssociationName = function(association) {
				if(association.userOrGroup[0]['_type_'] === 15)
					return association.userOrGroup[0].userGroupName;
				else if(association.userOrGroup[0]['_type_'] === 62)
					if(association.userOrGroup[0].userGroupName)
						return association.userOrGroup[0].userGroupName;
					else if(association.userOrGroup[0].externalGroupName && association.userOrGroup[0].providerDomainName)
						return association.userOrGroup[0].providerDomainName + "\\" + association.userOrGroup[0].externalGroupName;
					else
						return association.userOrGroup[0].externalGroupName;
				else
					return association.userOrGroup[0].userName;
          };

          $scope.removeUser = function(index) {
            $scope.updateSecurityRequest.securityAssociations.associations.splice(index, 1);
            $scope.hasChanges = true;
          };

          // remove from searched users
          $scope.deleteUser = function(index) {
            $scope.selectedUsers.splice(index, 1);
          };

          $scope.updateSecurityAssociations = function() {
            if (!$scope.hasChanges) {
              return null
            }
            return reportService.postDataForDataSetViaProxy("Security", $scope.updateSecurityRequest, "/api/")
              .then(function(resultData) {
                if (resultData.data.response[0]['errorString']) {
                  customReportSvc.errorToast(resultData.data.response[0]['errorString'])
                }
                else {
                  //updateSecurityTile && updateSecurityTile($scope.updateSecurityRequest.securityAssociations);

                    // check if the report have data cube data sources
                    if ($scope.entity.dataCubeHandlerList) {
                        var handlerSecurityRequest = Object.assign({}, $scope.updateSecurityRequest);
                        handlerSecurityRequest.entityAssociated.entity = [];
                        angular.forEach(($scope.entity.dataCubeHandlerList || []), function(handlerId, index) {
                            // add handler entity as well along with report entity as data cube handlers need explicit sharing
                            if (handlerId > 0) {
                              handlerSecurityRequest.entityAssociated.entity.push({"entityId": parseInt(handlerId), "entityType": $scope.SEA_SEARCH_HANDLER_ENTITY, "_type_": $scope.CUSTOM_ENTITY_TYPE});
                            }
                        });
                        // add handler execute permission for each user
                        angular.forEach(handlerSecurityRequest.securityAssociations.associations, function(association, index) {
                          association.properties.categoryPermission.categoriesPermissionList = [$scope.permissionIdMappings["204"]];
                        });
                        handlerSecurityRequest.securityAssociations.associationsOperationType = "ADD";
                        handlerSecurityRequest.securityAssociations.processHiddenPermission = 1;
                        reportService.postDataForDataSetViaProxy("Security", handlerSecurityRequest, "/api/").then(function(resultData) {
                            if (resultData.data.response[0]['errorString']) {
                              customReportSvc.errorToast(localMsg.customReport.updateSecuritySuccess + "\n" + resultData.data.response[0]['errorString']);
                            }
                            else {
                              customReportSvc.toast(localMsg.customReport.updateSecuritySuccess);
                              $scope.$close();
                            }
                        }, function(xhr, ajaxOptions, thrownError) {
                            customReportSvc.errorToast(localMsg.customReport.updateSecuritySuccess + "\n" + localMsg.customReport.handlerSecurityUpdateFailed + " " + resultData.data.response[0]['errorString']);
                        });
                    } else {
                        customReportSvc.toast(localMsg.customReport.updateSecuritySuccess);
                        $scope.$close();
                      }
                    }
                }, function(xhr, ajaxOptions, thrownError) {
                console.log(xhr);
                customReportSvc.errorToast("Update failed");
              })
          };

          $scope.isChecked = function(permission, association) {
            if(association.properties.categoryPermission.categoriesPermissionList) {
              for (var i = 0; i < association.properties.categoryPermission.categoriesPermissionList.length; i++) {
                if (association.properties.categoryPermission.categoriesPermissionList[i]['permissionId'] === permission.permissionId) {
                  return true;
                }
              }
            }
          };

          $scope.getCurrentList = function() {
            return $scope.currentPermissionsList.slice(0)
          };

          $scope.check = function(permission, association, checked, event) {
            $scope.hasChanges = true;
            if (!checked) {
              var arr = association.properties.categoryPermission.categoriesPermissionList;
              for (var i = 0; i < arr.length; i++) {
                if (arr[i]['permissionId'] === permission.permissionId) {
                  arr.splice(i, 1);
                  break;
                }
              }
            }
          };

          $scope.getPermissionsString = function (user) {
            var permissionsToShow = '';

            if (user.properties.categoryPermission.categoriesPermissionList) {
              var association = user.properties.categoryPermission.categoriesPermissionList.sort(function (a, b) {
                if (a.permissionName > b.permissionName) return 1;else if (a.permissionName < b.permissionName) return -1;
                return 0;
              });

              for (var j in association) {
                permissionsToShow += association[j].permissionName;

                if (j < association.length - 1) {
                  permissionsToShow += ', ';
                }
              }
            }
            return permissionsToShow
          };

          $scope.showAssociation = function (association) {
            return showAssociation(association, owner);
          }

          $(document).on('click', '.security-modal .dropdown-menu', function(e) {
            e.stopPropagation();
          });

        } ]);

  app.directive("permissionList", function() {
    return {
      restrict : 'AE',
      templateUrl : customReports.contextPath + '/reportsplus/security/permissionList.jsp',
      controller : 'showSecurityModalCtrl'
    };
  });

})();
