<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
<div class="ui-grid-pager-panel bottom" data-ng-if="(params.lastPageNo > 1  || params.totalServerItems > 10) && $parent.$parent.$parent.appName == 'adminconsole'">
		<div class="ui-grid-pager-container">
			<div class="ui-grid-pager-control">
				<button type="button" ng-click="params.firstPage()"
					ng-disabled="params.currentPage <= 1" disabled="disabled">
					<div class="first-triangle">
						<div class="first-bar"></div>
					</div>
				</button>
				<button type="button" ng-click="params.previous(params.page())"
					ng-disabled="params.currentPage <= 1" disabled="disabled">
					<div class="first-triangle prev-triangle"></div>
				</button>
				<input type="number" ng-model="params.currentPage"
					min="1" max="params.lastPageNo" required="" data-ng-change="params.page(params.currentPage)"
					class="ng-pristine ng-valid ng-valid-min ng-valid-max ng-valid-required ng-touched">
				<span class="ui-grid-pager-max-pages-number ng-binding"
					ng-show="params.lastPageNo > 0">/ {{params.lastPageNo}}</span>
				<button type="button" ng-click="params.next(params.page())"
					ng-disabled="params.currentPage == params.lastPageNo">
					<div class="last-triangle next-triangle"></div>
				</button>
				<button type="button"
					ng-click="params.lastPage(params.lastPageNo)"
					ng-disabled="params.currentPage == params.lastPageNo">
					<div class="last-triangle">
						<div class="last-bar"></div>
					</div>
				</button>
			</div>
			<div class="ui-grid-pager-row-count-picker">
				<select data-ng-model="$parent.$parent.$parent.component.pageSize" data-ng-change="$parent.$parent.$parent.pageSizeChanged($parent.$parent.$parent.component.pageSize)"
					ng-options="size for size in $parent.$parent.$parent.pageSizes"
					class="ng-pristine ng-untouched ng-valid"></select><span
					class="ui-grid-pager-row-count-label ng-binding">&nbsp;items
					per page</span>
			</div>
		</div>
		<div class="ui-grid-pager-count-container"><div class="ui-grid-pager-count"><span ng-show="params.totalServerItems > 0">{{params.pageOffSet+1}} - {{params.pageOffSet + params.totalFilteredItems}} of {{params.totalServerItems}} items</span></div></div>
	</div>
<div class="bottom" data-ng-if="params.totalServerItems > 5 && $parent.$parent.$parent.appName != 'adminconsole'">
	<div data-ng-show="params.totalServerItems > 0" class="dataTables_info">
		<span class="tableInfoText" data-ng-show="!params.isExportTwoStep" ><fmt:message key="CustomReport.Showing"/> {{params.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{params.pageOffSet + params.totalFilteredItems}} <fmt:message key="CustomReport.Of"/> {{params.totalServerItems}} <fmt:message key="CustomReport.Entries"/></span>
		<span class="tableInfoText" data-ng-show="params.isExportTwoStep" ><fmt:message key="CustomReport.Showing"/> {{params.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{params.totalServerItems}} <fmt:message key="CustomReport.Of"/> {{params.totalServerItems}} <fmt:message key="CustomReport.Entries"/></span>
	</div>
	<div data-ng-show="params.totalServerItems > 0" class="dataTables_paginate paging_input hideOnExportFriendly hideOnReadme"
		id="previewTable_table_paginate">
		<!-- Comments are used here to prevent whitespace from creating a space between buttons -->
		<span class="paginate_button first" data-ng-class="{'enabled':params.currentPage > 1 , 'disabled':params.currentPage <= 1}" id="previewTable_table_first" data-ng-click="params.firstPage()"></span><!--
	 --><span class="paginate_button previous" data-ng-class="{'enabled':params.currentPage > 1 , 'disabled':params.currentPage <= 1}" id="previewTable_table_previous" data-ng-click="params.previous(params.page())"></span><!--
     --><input type="text" style="width: 20px; display: inline;" data-ng-model="params.currentPage" data-ng-enter="params.page(params.currentPage)"><!--
     --><span class="paginate_button next" data-ng-class="{'enabled':params.currentPage >= 1 , 'disabled':params.currentPage == params.lastPageNo}" id="previewTable_table_next" data-ng-click="params.next(params.page())"></span><!--
     --><span class="paginate_button last" data-ng-class="{'enabled':params.currentPage >= 1 , 'disabled':params.currentPage == params.lastPageNo}" id="previewTable_table_last" data-ng-click="params.lastPage(params.lastPageNo)"></span>
	</div>
</div>
</fmt:bundle>