import { exportConstants } from '../js/constants';
(function() {
	"use strict";
	var reports = angular.module("reports");

	reports
			.controller('ngTableCtrl',
					[
							'$scope',
							'ngTableParams',
							'customReportSvc',
							'reportService',
							'$uibModal',
							'$timeout',
							'dataSource',
							'$sce',
							function($scope, ngTableParams, customReportSvc, reportService, $uibModal, $timeout,
									$dataSource,$sce) {
								$scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
								$scope.setChildScope($scope);
								$scope.checkboxes = {};
								$scope.colOrder = {};
								$scope.lastVisibleColumnId;
								$scope.allRows = {selected:false}
								$scope.selectedRows = {};
								$scope.singleSelectValue="";
								$scope.showSelectedRowsLabel = false;
								$scope.colMenuVisible = false;
								$scope.tableMenuVisible = false;
								$scope.quickChart = null;
								$scope.quickAnalysisMaxHeight = 649;
								$scope.colsDropMaxHeight = 300;
								$scope.SYS_ROWID = 'sys_rowid';
								$scope.filterColumns = [];
								if($scope.component.shared && $scope.component.sys_rowid_col){
									$scope.SYS_ROWID = $scope.component.sys_rowid_col;
								}
								if(!$scope.requestParms){
									$scope.requestParms = {};
								}
								var exportType = customReportSvc.getParameterByName("exportType"), isPreview = customReportSvc
										.getParameterByName("isPreview", false), tableOptions = customReportSvc
										.getParameterByName(encodeURIComponent($scope.component.id) + ".options");
								$scope.isAlarm = customReportSvc.getParameterByName("isAlarm", undefined);
								$scope.htmlRegex = /<([A-Za-z!][A-Za-z0-9!]*)\b[^>]*>(.*?)(<\/\1>)*/i;
								$scope.removeHtmlRegex = /((<style>)[^]*(<\/style>))+|((<script>)[^]*(<\/script>))+|<\/?[^>]+>/ig;
								$scope.isReportInsideDetailedReport=customReportSvc.getParameterByName("dashboardExport") == "true" ? true : false;
								var isReadMe = customReportSvc.getParameterByName("readme");

								$scope.component.quickChart = {};

								if (customReports.appName === 'adminconsole') {
									$scope.component.hideAlarmOption = true;
								}
								$scope.isPreviewEnabled = isPreview;
								if ($scope.isPreview || $scope.reportMode === 'preview') {
									$scope.component.hideAlarmOption = true;
									$scope.component.hideCsvOption = true;
								}
								if (tableOptions)
									$scope.options = JSON.parse(decodeURIComponent(tableOptions));
								/*
								 * Call back registers for the current controller to act on various events,
								 * like preview changes or input changes or any property changes.
								 *
								 */

								// the object will hold the column defintion by unique name.
								$scope.columnDefinitionById = {};

								// the object will hold the column definition by unique name.
								$scope.columnDefinitionByDataField = {};
								// the object will hold the column definition by unique name.
								$scope.columnindexByDataField = {};
								$scope.actualHiddenColumns = []; // this is an support for v1 reports having actual hidden columns.

								// this will set the id value of the component from name variable , for all old reports. We can remove this later if needed.
								if ($scope.component.name && !$scope.component.id) {
									$scope.component.id = angular.copy($scope.component.name);
									$scope.component.name = undefined;
								}
								if (typeof $scope.component.filters === 'undefined') {
									$scope.component.filters = {};
								}

								if ($scope.component.applyPlainTableCSS) {
									$("#reportArea .reportTable").addClass("tableComponentStyle");
								}
								$scope.translatedColNames={};
								$scope.generateColumnId = function(dataField) {
									var id = "";
									var orginalId = "";
									if($scope.dataSet.endpoint === "MONITORING_POLICY"){
										id = dataField.replace(/\s/g, " ");
										orginalId = dataField.replace(/\s/g, " ");
									}
									else
									{
										id = dataField.replace(/\s/g, "");
										orginalId = dataField.replace(/\s/g, "");
									}

									var i = 1;
									while (id in $scope.columnDefinitionById) {
										id = orginalId + i;
										i++;
									}
									return $scope.clearSpecialCharecters(id);
								};

								$scope.clearSpecialCharecters = function(columnId){
									return columnId.replace(/[^a-zA-Z0-9_]/g,'');
								}

								angular.forEach($scope.component.columns, function(column, key) {
									// if the id of the column is not defined then it will set the datField.

									if (!column.id) {
										column.id = $scope.generateColumnId(column.dataField);
									}
									if (column.name)
										column.name = undefined;
									// making a map for easy access to the column, as we use the id to reference a column.
									column.id=$scope.clearSpecialCharecters(column.id);
									$scope.columnDefinitionById[column.id] = column;
									$scope.columnDefinitionByDataField[column.dataField] = column;
									$scope.columnindexByDataField[column.dataField] = key;
									if (column.dataField.indexOf("_ActualHidden") != -1) {
										$scope.actualHiddenColumns.push(column.dataField);
									}
									$scope.translatedColNames[column.id] = rpt.evalExpression({expression:column.displayName});
								});

								$scope.updateCachedColumns = function() {
									$scope.columnDefinitionByDataField = {};

									angular.forEach($scope.component.columns, function(column, key) {
										$scope.columnDefinitionByDataField[column.dataField] = column;
									});

//									if($scope.reportMode === 'builder'){
//										$scope.colsCopy = angular.copy($scope.component.columns); // to copy the client scripts when all columns is set to true.
//									}
								}

								angular.forEach($scope.component.sorting, function(sort, key) {
									if (!sort.columnId && sort.dataField) {
										sort.columnId = sort.dataField;
										sort.name = undefined;
									}
								});

								$scope.addColumn = function(colObj) {
									var column = $scope.getBasicColumnDef(colObj);
									$scope.addColumnToList(column);
									$scope.addFilter(column);
									return column;
								};

								$scope.addFilter = function(value) {
									var filter = {
										id : value.id,
										searchType : 'text',
										value : "",
										visible : value.visible,
										type : value.type,
										hidden : value.hidden,
									};
									$scope.filterColumns.push(filter);
								};

								$scope.getBasicColumnDef = function(col) {
									var column = {
										dataField : col.name,
										displayName : col.name,
										id : $scope.generateColumnId(col.name),
										type : col.type,
										origType : col.hasOwnProperty("origType") ? col.origType : "",
										visible : col.visible !== undefined ? col.visible : true,
										hidden : col.name.indexOf("!") == 0 || col.name.indexOf("ActualHidden") != -1 ? true
												: false,
										aggrType : 'None',
										mobileOptions: {
											visible: true,
											viewOnList: true,
											viewOnDetail: true
										}
									};

									if ($scope.reportMode === "preview" && $scope.component.columns.length > 9) {
										column.visible = false;
									}

									$scope.columnDefinitionById[column.id] = column;
									return column;
								};

								$scope.addColumnToList = function(column){
									if(column.dataField.toLowerCase() === $scope.SYS_ROWID && $scope.customReport.builderVersion < 2){
										column.hidden = true; // marking this column hidden by default. Not adding this columns to the list is not processing results correctly, as the results include the value for this field.
									}
									$scope.component.columns.push(column);
								}

								if($scope.component.allColumns && $scope.dataSet) {
									var columnsToDisplay = $scope.component.columnsToDisplay;
									if(columnsToDisplay ) {//when allColumns set to true and columnsToDisplay is given in the config then
										//we are adding those visible columns in the table so that we can get data only for visible columns and not for all
										var operator = "or",noOfColsToDisp = $scope.dataSet.fields.length;
										if(columnsToDisplay.operator)
											operator = columnsToDisplay.operator.toLowerCase().trim();
										if(columnsToDisplay.noOfColumns)
											noOfColsToDisp = columnsToDisplay.noOfColumns;
									}
									if(!$scope.component.columns)
										$scope.component.columns = []

									var remainingFields,col,field,isAddCol, columns = $scope.component.columns,
									isColDefAvailable =  columns.length > 0;

									if(!isColDefAvailable && columnsToDisplay && columnsToDisplay.columnProperties) {
										remainingFields = $.map($scope.dataSet.fields, function(field) {
											var filteredProp = columnsToDisplay.columnProperties.filter(function(property) {
												return field[property.propertyName] === property.propertyValue;

											}).length;
											isAddCol = operator === "or" ? filteredProp > 0 : filteredProp === columnsToDisplay.columnProperties.length;

											if(isAddCol && columns.length < noOfColsToDisp) {
												col = {
													name : field.name,
													dataField : field.dataField,
													type : field.type
												};
												col = $scope.addColumn(col);
											} else
												return field;
										});
										if(columns.length < noOfColsToDisp) { //add remaining columns
											for(var i = 0; i <remainingFields.length; i++) {
											    var field = remainingFields[i];
										 		col = {
														name : field.name,
														dataField : field.dataField,
														type : field.type
													};
												col = $scope.addColumn(col);
												if(columns.length >= noOfColsToDisp)
													break;
											 }
										}
									}

								}

								//making a copy of original definition from the table component.
								$scope.colsCopy = angular.copy($scope.component.columns) || [];

								$scope.registerLocalCallBack = function(name, callback) {
									if ($scope.reportMode !== 'preview') {
										customReportSvc.registerCallback(name, callback,$scope.component.id);
									}
								};

								// this gets called when the any of the input changes form the input controller event is generated.
								$scope.registerLocalCallBack("redrawAllComponents", function(data) {
									if($scope.dataSet.endpoint !== 'DATACUBE' && !dataSetUtility.checkIffiltercanBeApplied(data,$scope.dataSet)){
										return false;
									}
									$scope.gridInitialized = false;
									$scope.tableParams.pageOffSet = 0;
									$scope.tableParams.page(1);
									$scope.selectedRows = {};// resetting the selected rows in case an input change
									$scope.checkboxes = {};
									angular.forEach($scope.component.columns, function(column, key) {
										column.direction = undefined;
									});
									// hard coding for now , will have to make a frame work solution to reset filter and sort when table information changes. Probably not applicable for other reports
									if($scope.customReport && $scope.customReport.userReportId && $scope.customReport.userReportId === "Sales Force"){
										angular.forEach($scope.requestParms, function(value, key) {
											 if(key.indexOf(".sort") !== -1 || key.indexOf(".filter") !== -1){
												 delete $scope.requestParms[key];
											 }
										});
									}
									$scope.getTableData();
								});
								customReportSvc.registerCallback("refreshComponent", function(componentId) {
									if ($scope.component.allColumns) {
										$scope.colsCopy = angular.copy($scope.component.columns);
									}

									if ($scope.component.id === componentId) {
										$scope.getTableData();
									}
								}, $scope.component.id);

								$scope.getToolTip = function(data,column) {
									var columnId = column.id , FormatterType;
									if(column.cellExpression)
										FormatterType = column.cellExpression.type;
									var dataStr = (data[columnId+'_formatted'] === undefined || FormatterType === "boolean") ? data[columnId] : $sce.valueOf(data[columnId+'_formatted']);
									if (dataStr && typeof dataStr === "string" && $scope.htmlRegex.test(dataStr)) {
										dataStr = dataStr.replace($scope.removeHtmlRegex, '');
									}
									return dataStr;
								}

								/*
								 * // this gets called when preview is done in the dataset builder.
								 * customReportSvc.registerCallback("previewStarted",function(comp) {
								 * $scope.gridInitialized = false; if($scope.component.id == comp.id){
								 * $scope.dataSetPreview = true; $scope.MinimumColumnsToShow = 5;
								 * $scope.tableParams.count(5); // Commenting out following statement as it
								 * creates dataSet object in a new scope. // The dataset dialog controls are
								 * bind to this new dataset. // $scope.dataSet = comp.dataSet;
								 *
								 * $scope.tableParams.reload(); } });
								 */

								$scope.registerLocalCallBack("reInitializeTable", function(comp) {
									if ($scope.component.id == comp) {

										if ($scope.component.allColumns) {
											//$scope.colsCopy = angular.copy($scope.component.columns);
											if($scope.allColumnsDropped || $scope.dataSet.endpoint !== 'DATACUBE')
												$scope.component.columns = [];

										} else
											$scope.component.columns = angular.copy($scope.colsCopy);

										$scope.gridInitialized = false;
										$scope.getTableData();
									}
								});

								$scope.registerLocalCallBack("hiddenColumn", function(index) {
									$scope.filterColumns[index].hidden = !$scope.filterColumns[index].hidden;
								});

								//this gets triggered when any of the property changes in the properties section and requires a redraw of the table. like the sort columns added or removed.
								$scope.registerLocalCallBack("refreshTableData", function(name) {
									if ($scope.component.id === name)
										$scope.getTableData();
								});

								//this gets triggered when any of the property changes in the properties section and requires a redraw of the table. like the sort columns added or removed.
								$scope.registerLocalCallBack("columnRemoved", function(col) {
									$scope.component.allColumns = false;
									if ($scope.component.id === col.componentId) {
										col.componentId = undefined;
										var columnIndex = $scope.getColumnIndexByID(col.id);
										$scope.filterColumns.splice(columnIndex, 1);
										if ($scope.component.allColumns) {
											col.hidden = true;
										} else {
											$scope.component.columns.splice(columnIndex, 1);
										}
										if ($scope.component.columns.length == 0)
											$scope.component.dataSet = undefined;
										$scope.setActiveComponent($scope.component);
										$scope.getTableData();
									}
								});

								//this gets triggered when data Set changes.
								//this gets triggered when data Set changes.

								$scope.updateComponentFields = function(dataSet) {
									//if(dataSet.dataSet.originalDataSetName && $scope.component.dataSet.dataSetName && dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName)
									//check for the name of the dataset. Data Set name might have changed, so check with old dataset name.
									if ($scope.component.dataSet &&
											dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName) {
										var isRefreshRequired = false;
										// set the new name
										$scope.component.dataSet.dataSetName = dataSet.dataSet.dataSetName;
										$scope.dataSet = dataSet;
										angular.forEach($scope.dataSet.fields, function(field) {
											angular.forEach($scope.component.columns, function(column) {
												if (column.dataField === field.originalName &&
														field.originalName !== field.name) {
													column.dataField = field.name;
													isRefreshRequired = true;
												}
											});
										});
										if (isRefreshRequired)
											$scope.getTableData(true);
									}
								}

								//this gets called when the dataset gets deleted, so that the current table component should be automatically removed.
								$scope.registerLocalCallBack("dataSetDeleted", function(dataSet) {
									if (typeof $scope.component.dataSet === "object" &&
											dataSet.dataSet.dataSetName === $scope.component.dataSet.dataSetName) {
										$scope.deleteComponentByName($scope.component.id);
									}
								});

								var includeDrafts = customReportSvc.getParameterByName("includeDrafts") || false;
								$scope.includeDrafts = includeDrafts;
								$scope.isFromOldUrl = customReportSvc.getParameterByName("fromOldUrl", false);
								$scope.oldReportColumns = undefined;
								$scope.showFilter = $scope.component.showFilterByDefault || false;
								var oldColumns = customReportSvc.getParameterByName($scope.component.id +
										".oldReportColumns");
								if (oldColumns) {
									$scope.oldReportColumns = oldColumns.split(",").map(function(value) {
										return value.toLowerCase();
									});
								}

								$scope.pageSizes = [ 5, 10, 20, 50, 100, 200, 500 ];
								if (isReadMe) {
									$scope.pageSizes = [ 5 ];
								}

								$scope.visibleColumnLength = 0;
								var pageSizeUrl = customReportSvc
										.getParameterByName(encodeURIComponent($scope.component.id) + ".limit");
								var exportPageSize = customReportSvc.getParameterByName("pageSize");
								$scope.component.pageSize = pageSizeUrl != "" ? parseInt(pageSizeUrl)
										: $scope.component.pageSize;
								if (exportPageSize == "-1" && $scope.dataSet.endpoint !== 'DATACUBE')//For Data cube reports we don't want to export all records. It should export only what user is seeing.
									$scope.component.pageSize = 1000;

								if($scope.exportType === "csv" || $scope.exportType === "pdf" || $scope.exportType === "html"){
									if($scope.dataSet.endpoint !== 'DATACUBE'){// TEMPORARY Check for HotFix
										$scope.component.pageSize = 2;
									}
								}

								if($scope.isReportInsideDetailedReport){
									var exportPageSizeForInsideReport = 100;
									if(!isNaN( parseInt(exportPageSize) ) && parseInt(exportPageSize) != -1  ){
										exportPageSizeForInsideReport = parseInt(exportPageSize) ;
									}
									$scope.component.pageSize = exportPageSizeForInsideReport;
								}

								if(isReadMe){
									$scope.component.pageSize = 5;
								}

								var data = [];
								// var columnsProcessed = false;
								$scope.MinimumColumnsToShow = 9;

								$scope.showColMenu = function($event, id) {
									$('#col_menu_' + id + '.fadeOutSection').toggle();
									$scope.colMenuVisible = !$scope.colMenuVisible;
									$scope.tableMenuVisible = false;
									$('#table_menu_' + $scope.component.id).hide();
									$("li[comp=" + $scope.component.id + "]").addClass("visible-overflow");
									$event.stopPropagation();
								}

								// toggles the slide of the column menu relative to the current controller.
								$scope.showTableMenu = function($event, id) {
									var menu = $('#table_menu_' + id);
									menu.toggle();
									$scope.tableMenuVisible = !$scope.tableMenuVisible;
									if ($("li[comp=" + $scope.component.id + "]").hasClass("visible-overflow"))
										$("li[comp=" + $scope.component.id + "]").removeClass("visible-overflow");
									else
										$("li[comp=" + $scope.component.id + "]").addClass("visible-overflow");
									$event.stopPropagation();
								};

								$scope.showQuickAnalysis = function($event) {
									// setTimeout($scope.calcQuickAnalysisHeight, 301)
									$scope.quickAnalysisMode = !$scope.quickAnalysisMode;
									$scope.$broadcast("ngTableAfterReloadData", true);
									$event.stopPropagation();
								};

								$scope.calcQuickAnalysisHeight = function() {
									// var divHeight = $("li[comp=" + $scope.component.id + "]").find(".qcContainer").height();
									// if (divHeight < 300 || $scope.component.quickChart.height < 300) {
									// 	$scope.component.quickChart.height = $scope.quickAnalysisMaxHeight;
									// 	return;
									// }
									// $scope.component.quickChart.height = divHeight > $scope.quickAnalysisMaxHeight ? $scope.quickAnalysisMaxHeight : divHeight;
									$scope.component.quickChart.height = $scope.quickAnalysisMaxHeight;
								}

								$scope.calcQuickAnalysisHeight();

								//export all of the table data to csv.
								/*$scope.exportToCSV = function() {
									var dataSetsToExport = customReportSvc.getDataSetstoExport([ $scope.component ]);
									var filePrefix = $scope.component.id;
									if ($scope.component.name)
										filePrefix = $scope.component.name;
									$scope.masked = true;
									reportService.retrieveCsvData(dataSetsToExport, filePrefix, 'csv').then(function(
											data) {
										var data1 = data.data;
										$scope.masked = false;
										if (!data1 || data1 == "" || data1 == 'null')
											alert(localMsg['ExportError']);
										else {
											$("#fileNameToDownload").val(data1);
											$("#exportForm").submit();
										}
									},
											function(error) {
												alert(error.data);
												$scope.masked = false;
											});
								};*/

								// will open the alarm dialog by passing in the current columns.
								$scope.openAlarmsDialog = function() {
									$uibModal.open({
										templateUrl : customReports.contextPath + "/reportsplus/alarms/alarmsModal.jsp",
										controller : 'alarmsCtrl',
										windowClass : 'reportsPlusAlarm',
										scope:$scope,
										resolve : {
											columns : function() {
												return $scope.component.columns;
											}
										}
									});
								};

								$scope.getColumnByName = function(name) {
									return $scope.columnDefinitionById[name];
								};

								$scope.getColumnInfo = function(col) {
									var retCol;
									for (var k = 0; k < $scope.colsCopy.length; k++) {
										if($scope.colsCopy[k].dataField.toLowerCase() === col.dataField.toLowerCase() || (col.name && $scope.colsCopy[k].id.toLowerCase() === col.name.toLowerCase())){
											retCol = $scope.colsCopy[k];
											break;
										}
									}
									return retCol;
								};

								$scope.colClicksCount = {};
								//this will handle any sorting clicks
								$scope.resetPreviousSort = function(column) {
									var sort = $scope.requestParms[$scope.component.id + ".sort"];
									if (sort) {
										var columnId = sort.indexOf("-") == 0 ? sort.substring(1, sort.length) : sort;
										if (columnId != column.id) {
											var idx = $scope.getColumnIndexByID(columnId);
											if(idx){
												$scope.component.columns[idx].direction = undefined;
											}
										}
									}
								};

								$scope.sort = function(column, index,event) {
									$scope.resetPreviousSort(column);
									// var colFound=undefined;
									var direction = column.direction === undefined ||
											column.direction === "sorting_desc" ? "asc" : "desc";
									column.direction = "sorting_" + direction;
									if ($scope.colClicksCount[column.id] == undefined) {
										$scope.colClicksCount = {};
										$scope.colClicksCount[column.id] = 1;
									} else {
										$scope.colClicksCount[column.id] = ++$scope.colClicksCount[column.id];
										if ($scope.colClicksCount[column.id] == 3) {
											$scope.colClicksCount[column.id] = 0;
											direction = "";
											column.direction = undefined;
										}
									}

									var value = "";
									if (direction) {
										value = direction == "desc" ? "-" : "";
										value = value + column.id;
									}
									$scope.addParameter($scope.component.id + ".sort", value);
									$scope.tableParams.reload();
								};

								$scope.showDirections = function(index, retDir) {
									$('#table_' + $scope.component.id + ' th').removeClass('sorting_desc');
									$('#table_' + $scope.component.id + ' th').removeClass('sorting_asc');
									if (retDir != "")
										$($('#table_' + $scope.component.id + ' th')[index]).addClass(retDir
												.toLocaleLowerCase() == "desc" ? 'sorting_desc' : 'sorting_asc');
								};

								// this will handle filtering
								$scope.filter = function() {
									angular.forEach($scope.filterColumns, function(column, value) {
									    var valueColumn;
									    var doNotUpdate = value === $scope.filterColumns.length-1 ? false : true ;
										//$scope.addColOption(column.id,"filter",column.value);
										if(column.type === "Integer" || column.type === "Long") {
											valueColumn = column.value.replace(/,/g, '');
					                    } else {
											valueColumn = column.value;
					                    }

										if ($scope.dataSet.endpoint !== "DATACUBE" || $scope.useCREApiForSolr ) {

											$scope.addParameter($scope.component.id+".filter."+column.id, valueColumn,doNotUpdate);
										} else {
											var advancedFilter = customReportSvc.getDefaultAdvancedFilter(column.id, valueColumn);
											$scope.addFilters(column.id, advancedFilter, $scope.component, false, false, [], true, 'viewer', 'include', true);
										}
									});
									//For data cube, once filters are applied we do redrawAllComponents so no need to reload the table
									if ($scope.dataSet.endpoint !== "DATACUBE" || $scope.useCREApiForSolr) {
										// resetting page size to 0 , so that filtered results are shown from page 0, even though current page may be 5.
										$scope.tableParams.page(1);
										$scope.tableParams.pageOffSet = 0;
										$scope.tableParams.reload();
									} else if ($scope.dataSet.endpoint === "DATACUBE") {
										customReportSvc.triggerCallback("redrawAllComponents");
									}
								};

								$scope.pageSizeChanged = function(pageSize) {
									//$scope.addOption("pageSize", pageSize);
									$scope.addParameter($scope.component.id + ".limit", pageSize);
									$scope.tableParams.count(pageSize);
								};

								$scope.hiddenColumns = [];
/*								var hiddenColumnStr = $scope.requestParms[$scope.component.id + ".hide"];
								if (hiddenColumnStr) {
									$scope.hiddenColumns = hiddenColumnStr.split(",");
								}*/

								$scope.visibleColumns = [];
//								var visibleColumnStr = $scope.requestParms[$scope.component.id + ".show"];
//								if (visibleColumnStr) {
//									$scope.visibleColumns = visibleColumnStr.split(",");
//								}

								$scope.isLastVisible = function(){
									$scope.visColumns=[];
									angular.forEach($scope.component.columns, function(col, key) {
										if(col.visible){
											$scope.visColumns.push(col);
										}
									});

									if($scope.visColumns.length > 1){
										return false;
									}else{
										return true;
									}
								}

								$scope.toggleColVisibility = function(column,event) {
									if(column.visible && $scope.isLastVisible()){
										return false; // do not allow user to unslect the last column.
									}
									var index = $scope.component.columns.indexOf(column);
									$scope.filterColumns[index].visible = !$scope.filterColumns[index].visible;
									column.visible = !column.visible;
									var columnId = column.id;

									if (column.visible) {
										var hidIndex = $scope.hiddenColumns.indexOf(columnId);
										if (hidIndex !== -1)
											$scope.hiddenColumns.splice(hidIndex, 1);
										$scope.visibleColumns.push(column.id);
									} else {
										var showIndex = $scope.visibleColumns.indexOf(columnId);
										if (showIndex !== -1)
											$scope.visibleColumns.splice(showIndex, 1);

										$scope.hiddenColumns.push(column.id);
									}
									var hiddenColumnString = $scope.hiddenColumns.join(",");
									var visibleColumnString = $scope.visibleColumns.join(",");
									$scope.addParameter($scope.component.id + ".hide", hiddenColumnString);
									$scope.addParameter($scope.component.id + ".show", visibleColumnString);
									event.stopPropagation();
									$scope.calculaLastVisiblecolumn();
								};

								// this will hanlde filtering
								$scope.toggleColumnSelection = function(column, index, event) {
									angular.element("table td").removeClass('selectedCol'); //remove the selectedCol class for the current selection of the column.
									if($scope.component.enableButtonPanel && $scope.component.enableRowSelection){
										index = index + 2; // two additional tds are being added to the dom for the enableSingleRowSelection and enableMultipleRowSelection.
									}else{
										index = index + 1; // two additional tds are being added to the dom for the enableSingleRowSelection and enableMultipleRowSelection.
									}
									angular.element("#table_" + $scope.component.id + " td:nth-child(" + index + ")").addClass('selectedCol'); //add the selectedCol class to the newly selected Column.
									column.componentId = $scope.component.id;
									column.columns = customReportSvc.getDeepCopy($scope.component.columns);
									$scope.setActiveComponent(column);
									event.preventDefault();
									event.stopPropagation();
								};

								$scope.applyOldUrlColumns = function() {
									angular.forEach($scope.component.columns, function(col, key) {
										if ($scope.oldReportColumns.indexOf(col.displayName.toLowerCase()) == -1) {
											$scope.filterColumns[key].visible = false;
											col.visible = false;
										}
									});
								};

								$scope.gridInitialized = false;



								$scope.addOfflineBehavior = function() {
									var commcellID = $scope.getBasicColumnDef({
										name : "CommCellID",
										dataField : "CommCell ID",
										type : "String"
									});
									commcellID.visible = false;
									var CommServUniqueId = $scope.getBasicColumnDef({
										name : "!CommServUniqueId",
										dataField : "!CommServUniqueId",
										type : "String"
									});
									CommServUniqueId.hidden = true;
									var CustomerName = $scope.getBasicColumnDef({
										name : "!CustomerName",
										dataField : "!CustomerName",
										type : "String"
									});
									CustomerName.hidden = true;
									var CommcellName = $scope.getBasicColumnDef({
										name : "CommcellName",
										dataField : "Commcell Name",
										type : "String"
									});
									CommcellName.cellExpression = "='<a target=\"_top\" href=\"../survey/reports/dashboard.jsp?commUniId=' + row['!CommServUniqueId'] + '\">' + row['!CustomerName'] + '</a>'";
									$scope.component.columns.splice(0, 0, commcellID);
									$scope.component.columns.splice(1, 0, CommServUniqueId);
									$scope.component.columns.splice(2, 0, CustomerName);
									$scope.component.columns.splice(3, 0, CommcellName);
								};

								$scope.getIdforTheColumn = function(id) {
									var columnId = id;
									angular.forEach($scope.component.columns, function(column, key) {
										if (column.dataField.toLowerCase() == id.toLowerCase()) {
											columnId = column.id;
										}
									});
									return columnId;
								};

								$scope.processColumns = function(columns) {
									if ($scope.noColumndefintions)
										$scope.component.columns = [];
									for (var j = 0; j < columns.length; j++) {
										var col = columns[j];
										if ($scope.noColumndefintions) {
											var column = $scope.addColumn({
												name : col.name,
												dataField : col.dataField,
												type : col.type
											});
											$scope.columnDefinitionById[column.id] = column;
											$scope.columnDefinitionByDataField[column.dataField] = column;
										} else {
											var column = $scope.columnDefinitionByDataField[col.dataField];
											if (column) {
												column.type = col.type;
											}
										}
									}
								};

								//Check for determining whether we need to process columns. If the columns are undefined or if the columns defined do not have a type we to fetch the information again and merge the columns
								$scope.isColumnProcessingRequired = function() {
									if (!$scope.component.columns) {
										$scope.noColumndefintions = true;
										return true;
									} else {
										if($scope.component.columns.length === 0 && $scope.reportMode === "viewer"){
	                                        $scope.noColumndefintions = true;
	                                        return true;
										}
										for (var i = 0; i < $scope.component.columns.length; i++) {
											if (!$scope.component.columns[i].type)
												return true;
										}
									}

									return false;
								};
								if(!$scope.component.autoHeight)
									$scope.component.autoHeight = "On";

								$scope.tableParams = new ngTableParams({
									page : 1, // show first page
									count : $scope.component.pageSize
								// count per page
								}, {
									total : data.length, // length of data
									getData : function($defer, params) {

										// this will be needed to reset the table . As of now used when pivot table changes are made.
										if ($scope.resetTable) {
											$scope.component.columns = [];
											$defer.resolve([]);
											params.totalServerItems = 0;
											$scope.totalServerItems = 0;
											$scope.resetTable = false;
											$scope.gridInitialized = false;
											return;
										}

										// if it is a selected rows Operation
										if($scope.showSelectedRowsOperation){
											$scope.showSelectedRowsOperation = false;
											$defer.resolve($scope.datToDefer);
											return;
										}
										if (!$scope.gridInitialized && $scope.dataSet && $scope.dataSet.endpoint === "DATACUBE") {
											$scope.initFilters();
											$scope.initTableState();
										}


										var isColumnProcessingRequired = $scope.isColumnProcessingRequired();
										//Check if this condition is needed
										if (isColumnProcessingRequired && $scope.dataSet &&
												$scope.dataSet.endpoint !== 'DATACUBE') {
											var isPivot = $scope.component.type === "PIVOT_TABLE";
											if (isPivot) {
												var options = customReportSvc.getDataSetOptions($scope.component, false);
											}

											window.pendingRequests += 1; // To make sure export waits till the below timeout is called.
											$timeout(function() {
												window.pendingRequests -= 1;
												$scope.getFieldsForDataSet($scope.dataSet).then(function(data) {
													if ($scope.reportMode === 'viewer') {
														$scope.dataSet.fields = data.data.columns; // chart interactivity
													}
													$scope.processColumns(data.data.columns);
													$scope.processData($defer, params);
												}, function(error) {
													$scope.errorFunc(error.data,error.status);
												});
											},1000)
										} else
											$scope.processData($defer, params);
									}
								});

								$scope.processData = function($defer, params) {

									if (!$scope.dataSet) {
										return;
									}
									params.pageOffSet = (params.page() - 1) * params.count();
									$scope.pageOffSet = params.pageOffSet;
									params.currentPage = params.page();

									//TODO: Data Cube doesn't need the below step to be executed; check how to avoid
									var options = customReportSvc.getDataSetOptions($scope.component,
											false,
											$scope.requestParms);

									$scope.tableColumns = {
										"valueFieldsList" : options.valueFieldsList,
										"groupByFieldsList" : options.groupByFieldsList
									};
									$scope.totalServerItems = 0;

									if (!$scope.component.allColumns && options.valueFieldsList.length == 0) {
										params.totalServerItems = 0; // reseting the totalServerItems = 0; when the last column is removed from the label which will show the No data available message in the footer.
										$scope.totalServerItems = 0;
										$scope.masked = false;
										return;
									}

									params.showFooter = false;
									$scope.masked = true;

									if ($scope.reportMode === "preview" && !$scope.showPreviewTable)
										return;

									if ($scope.component && $scope.dataSet && $scope.dataSet.dataSet.dataSetName) {
										var dataSetName = $scope.dataSet.dataSet.dataSetName;
										$scope.component.isComponentLoading = true;
										if ($scope.isLayoutAvailable)
											$scope.loadingButton();
										if ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) {
											if ($scope.component.type === "PIVOT_TABLE") {
												//currently sorting, filter not honored for pivot table
												var dimensionDataField = [], measureDataField = [];
												var pRow = $scope.component.pivotRow.column;
												var pCol = $scope.component.pivotColumn.column;
												dimensionDataField.push({
													column : pRow
												});
												dimensionDataField.push({
													column : pCol
												});
												measureDataField.push({
													column : $scope.component.pivotCell.column,
													aggrType : $scope.component.pivotCell.aggrType,
													sortOrder : "desc"
												});

												$dataSource
														.getDataSource($scope.dataSet.endpoint)
														.getChartData({
															dataSet : $scope.dataSet,
															componentType : $scope.component.type,
															measureDataField : measureDataField,
															dimensionDataField : dimensionDataField,
															sortOptions : $scope.component.sorting ? $scope.component.sorting[0]
																	: undefined,
															filters : $scope.component.filters &&
																	$scope.component.filters['builder'] ? $scope.component.filters['builder'][dataSetName]
																	: {},
															inputParams : customReportSvc
																.applyInputsToDataSet($scope.dataSet,
																		$scope.page.inputs)
														},
																function(response) {
																	var records = response.data.records;
																	var resp = {
																		data : {
																			//currently no pagination support for now
																			recordsCount : records.length,
																			totalRecordCount : records.length,
																			records : records,
																			columns : [ {
																				dataField : pRow,
																				name : pRow,
																				id : pRow,
																				type : ""
																			} ]
																		}
																	};
																	//TODO:check for the alternative component for pivot table; ngTable is not fit for it
																	if (!$.isEmptyObject(response.data.moreInfo) &&
																			response.data.moreInfo.hasOwnProperty(pCol)) {
																		$.each(response.data.moreInfo[pCol].keyMap,
																				function(k, v) {
																					resp.data.columns.push({
																						dataField : k,
																						name : k,
																						id : v,
																						type : "" //not sure what should be the type
																					});
																				});
																	}
																	successCallback(resp, $defer, params);
																});
											} else {
												var urlOptions = customReportSvc.getUrlOptions($scope.component.id,$scope.requestParms);
												var tableParams = {
													columns : $scope.component.allColumns && $scope.allColumnsDropped ? $scope.dataSet.fields
															: customReportSvc.getSelectedColumnsDefn($scope.dataSet.fields, $scope.component.columns),

													offset : $scope.pageOffSet,
													limit : $scope.component.pageSize,
													sort : $.extend(true, $scope.component.sorting, urlOptions.sorting),
													customFilterQuery: $scope.component.filters ? $scope.component.filters.customFilterQuery: undefined
												};
												$dataSource.getDataSource($scope.dataSet.endpoint).getTableData({
													dataSet : $scope.dataSet,
													componentType : $scope.component.type,
													tableParams : tableParams,
													filters : $scope.component.filters &&
															$scope.component.filters['builder'] ? $scope.component.filters['builder'][dataSetName]
															: {},
													inputParams : customReportSvc
																.applyInputsToDataSet($scope.dataSet,
																		$scope.page.inputs)
												}, function(resp, reqObj) {
													//console.log(reqObj.params);
													$scope.tempComponent.latestSearchParams = [reqObj.params];
													successCallback({
														data : resp
													}, $defer, params);
												});
											}
										} else {
											$scope.getData().then(function(resultData) {
												successCallback(resultData, $defer, params);
											});
										}
									}
								};

								var successCallback = function(resultData, $defer, params) {
									if (!$scope.gridInitialized) {
										/**
										 * When all column is set to true reset the columns , so that column
										 * definition is prepared on grid initialization from the data set
										 * results set.
										 */
										if ($scope.component.allColumns && ($scope.allColumnsDropped || $scope.dataSet.endpoint !== 'DATACUBE')) {
											$scope.updateCachedColumns();
											$scope.component.columns = [];
											$scope.columnDefinitionById = [];
										}
									}
									onSuccessGetDataForDataSet(resultData, $defer, params);
								};


								var applyCellExpr = function(resultData, row, rowIndex) {
									var rowStyleExpression = $scope.component.rowStyleExpression;
									if (rowStyleExpression)
										resultData['rowStyle'] = customReportSvc.evalExpression(rowStyleExpression,
												row,
												rowIndex);
									for (var j = 0; j < $scope.component.columns.length; j++) {
										var col = $scope.component.columns[j];
										var cellExpression = col.cellExpression || $scope.component.allCellExpression;
										var tagAttributes = col.cellAttributes;
										if(col.components && col.components.length > 0){
											if(!tagAttributes){
												tagAttributes = {};
											}
											tagAttributes['cv-column-actions']="true";
										}

										var cellData = resultData[col.id];
										var columnIndex = j;
										if (cellExpression){
											resultData[col.id+"_formatted"] = customReportSvc.getFormattedValue(cellData,
													cellExpression,
													row,
													rowIndex,
													columnIndex,
													col, $scope.dataSet);

                      if (col.type === 'FileList' || typeof resultData[col.id+"_formatted"] === "string"){
                        resultData[col.id+"_formatted"] = $sce.trustAsHtml(resultData[col.id+"_formatted"])
                      }
										}
										if (tagAttributes) {
											for ( var key in tagAttributes) {
												var objKey = col.id + "tagAttributes";
												if (!resultData[objKey])
													resultData[objKey] = {};
												if (tagAttributes[key]) {
													resultData[objKey][key] = customReportSvc
															.evalExpression(tagAttributes[key],
																	row,
																	col,
																	rowIndex,
																	cellData,
																	columnIndex);
												}
											}
										}

										if (col.hasOwnProperty("splitByCharacter") && col.splitByCharacter != "") {
											var currData = resultData[col.id + "_formatted"] !== undefined ? resultData[col.id + "_formatted"] : resultData[col.id];
											if (cellData != null) {
												cellData = currData.toString();
												if (cellData.indexOf(col.splitByCharacter) != -1) {
													currData = cellData.split(col.splitByCharacter)
															.join("<br/>");
												} else {
													currData = cellData;
												}
											}
											if (resultData[col.id + "_formatted"]) {
												resultData[col.id + "_formatted"] = currData;
											} else {
												resultData[col.id] = currData;
											}
										}
										if (resultData[col.id + "_formatted"] &&
												typeof resultData[col.id + "_formatted"] === 'object' &&
													Array.isArray(resultData[col.id + "_formatted"])) {
												resultData[col.id + "_formatted"] = resultData[col.id + "_formatted"].join("<br/>");
										}
										if (typeof resultData[col.id] === 'object' &&
													Array.isArray(resultData[col.id])) {
												resultData[col.id] = resultData[col.id].join("<br/>");
										}

										if(col.components && col.components.length > 0){
											var params = {row:row,col:col,rowIndex:rowIndex,cellData:cellData,columnIndex:columnIndex};
											resultData[col.id+"_components"] = {};
											var finalActionsHtml = '<ul class="column-components">';
											for(var t=0;t<col.components.length;t++){
												var ccomp = col.components[t];
												resultData[col.id+"_components"][ccomp.id] = rpt.getColumCompHtml(ccomp,params);
												finalActionsHtml = finalActionsHtml + "<li class='column-item'>" +resultData[col.id+"_components"][ccomp.id]+"</li>";
											}
											finalActionsHtml = finalActionsHtml + "</ul>"
											resultData[col.id+ "_formatted"] = $sce.trustAsHtml(finalActionsHtml);
										}
									}

									if($scope.component.showAsSearchResults && $scope.component.rowTemplate){
										resultData['rowTemplate'] = customReportSvc.evalExpression($scope.component.rowTemplate,resultData,rowIndex);
									}
								}

								$scope.calculaLastVisiblecolumn = function(){
									for (var j = 0; j < $scope.component.columns.length; j++) {
										var column =  $scope.component.columns[j];
										if(column.id && column.visible && !column.hidden){
											$scope.lastVisibleColumnId = column.id;
										}
									}
								}

								var acMenuActions= {
										hideMenu : function(e) {
											var id = $scope.component.id;
											$scope.showMenu = false;
											$('#ac-table-menu-' + id ).hide();
											$('li[comp=' + id + ']').removeClass('visible-overflow');
										},
										showMenu : function(e) {
											var id = $scope.component.id;
											$scope.showMenu = true;
											$('#ac-table-menu-' + id ).show();
											$('li[comp=' + id + ']').addClass('visible-overflow');
										}
								};

								$scope.toggleMenu = function(e){
									if ($scope.showMenu) {
										acMenuActions.hideMenu();
									} else {
										acMenuActions.showMenu();
									}

									e.stopPropagation();
									e.preventDefault();
								}

								$scope.createTableView = function(action,index,e){
									$scope.viewMode = action;
									$scope.currentIndex = index;
									$scope.tableMode = true;
									$uibModal.open({
						                templateUrl: customReports.contextPath + "/reportsplus/views/tableViewModal.jsp",
						                controller: 'viewModalCtrl',
										scope:$scope
						            });
									e.stopPropagation();
									e.preventDefault();
								}


								$scope.isUserView = function(view){
									var retValue = false;
									angular.forEach($scope.page.userViews,function(userView){
										if(view.id === userView.id ){
											retValue = true;
										}
									});
									return retValue;
								}

								$scope.isExportTwoStep = function(){
									if( ($scope.exportType=='pdf' || $scope.exportType=='html') && $scope.dataSet.endpoint !== 'DATACUBE' && !$scope.isReportInsideDetailedReport ){
										return true;
									}
									else{
										return false;
									}
								}

								var getComputedColumnsInfo = function(name) {
									var columnObj = {
										"name" : "",
										"dataField" : "",
										"type" : "",
										"isComputedColumn" : true
									};

									columnObj.name = name;
									columnObj.dataField = name;
									//columnObj.type = "String";
									columnObj.type = "Double";
									return columnObj;
								}

								var addComputedColumnToLeftPane = function(columns){
									var alreadyAdded = false;
									var computedColList = [];
									for(var i=0;i<columns.length;i++){
										var curCol = columns[i].name;
										alreadyAdded = false;
										angular.forEach($scope.dataSet.fields, function(field) {
											if (field.name == curCol) {
												alreadyAdded = true;
											}
										});

										if(alreadyAdded == false){
											computedColList.push(curCol);
											var columnObj = getComputedColumnsInfo(curCol);
											$scope.dataSet.fields.push(columnObj);
											//break;
										}
									}
									if($.isEmptyObject($scope.dataSet.computedColumns) == false && computedColList.length > 0)
									    $scope.dataSet.computedColumns.columnList = computedColList;
								}

								var processRFields = function(columns){
									for(var i=0;i<$scope.dataSet.fields.length;i++){
										var isFound= false;
										for(var j=0;j<columns.length;j++){
											if($scope.dataSet.fields[i].name == columns[j].name){
												isFound = true;
												break;
											}
										}//for

										if(isFound == false){
											$scope.dataSet.fields.splice(i,1);
										}
									}
								}

								var onSuccessGetDataForDataSet = function(resultData, $defer, params) {
									var response = resultData.data;
									var records = response.records;
									var columns = response.columns;
									//Add below as temporary;;;
									//$scope.isComputedColumnAddedToFields("computedColumn1");

									if($scope.reportMode == "preview")
										addComputedColumnToLeftPane(columns);

									if($scope.dataSet.endpoint == "R" && $scope.reportMode == "preview"){
										processRFields(columns);
									}

									var failures = response.failures;
									$scope.totalServerItems = response.totalRecordCount;
									$scope.totalFilteredItems = response.recordsCount;
									params.total(response.totalRecordCount);
									params.totalServerItems = response.totalRecordCount;
									params.totalFilteredItems = response.recordsCount;
									params.exportType=$scope.exportType;
									params.isExportTwoStep =$scope.isExportTwoStep();
									data = [];
									$scope.masked = false;
									$scope.component.isComponentLoading = false;
									if (!$scope.gridInitialized) {
										params.showFooter = !$scope.showDraggingInfo();
										if($scope.component.allColumns){
											$scope.translatedColNames={}; // columns may change between the requests and so translations will have to be reevaluated.
										}
										for (var j = 0; j < columns.length; j++) {
											var col = columns[j];
											var addedCol = null;
											if ($scope.component.allColumns && ($scope.allColumnsDropped || $scope.dataSet.endpoint !== 'DATACUBE')) {
												var column = $scope.getColumnInfo(col);
												if (column) {
													column.type = col.type;
													addedCol = $scope.addColumnToList(column);
													$scope.translatedColNames[column.id] = rpt.evalExpression({expression:column.displayName});
													if(column.dataField.toLowerCase() === "data source"){
														$scope.checkDataSourceColumnAndHide(column);
													}
												} else{
													addedCol = $scope.addColumn({
														name : col.name,
														dataField : col.dataField,
														type : col.type
													});
													$scope.translatedColNames[addedCol.id] = addedCol.displayName;
													$scope.hideSystemColumn(addedCol); // When allColumns is enabled on table , hide the sys_rowid and set the data source visibility to false.
												}
												if($scope.component.noOfColumnsToDisplay &&  j > $scope.component.noOfColumnsToDisplay+1 ){ // when allColumns set to true and want to limit the number of visible columns in the gui.
													$scope.component.columns[j].visible = false;
												}
											} else {
												for (var i = 0; i < $scope.component.columns.length; i++) {
													if (col.dataField.toLowerCase() === $scope.component.columns[i].dataField.toLowerCase()) {
														$scope.component.columns[i].type = col.type;
														addedCol = $scope.component.columns[i];
													}
												}

											}

						                      if(addedCol && addedCol.type === 'FileList'){
						                        addedCol.cellExpression = '=convertFilesToLinks(cellData, col, row)';
						                        addedCol.shareId = $scope.dataSet.fields[j].shareId;
						                        addedCol.fieldGuid = $scope.dataSet.fields[j].fieldGuid;
						                      }
										}

										if ($scope.component.allColumns && $scope.dataSet &&
												$scope.dataSet.queryPlan && $scope.dataSet.queryPlan.offline && $scope.reportMode == "viewer" &&
												!$scope.isPreviewEnabled) {
											//check if it is private or public
											var privateIndex = $scope.getColumnIndexByID("IsPrivate");
											var cvIndex = $scope.getColumnIndexByID("CommcellVersion");
											var isPrivate;
											if(records.length > 0){
												isPrivate = records[0][privateIndex];
											}
											var cIdx = $scope.getColumnIndexByID("CommcellName");
											if (isPrivate) {
												if (cIdx)
													$scope.component.columns[cIdx].cellExpression = "='<a target=\"_top\" href=\"../survey/reports/dashboard.jsp?commUniId=' + row['CommServUniqueId'] + '\">' + row['CommcellName'] + '</a>'";
											} else {
												var cName = $scope.getColumnIndexByID("CustomerName");
												if (cName) {
													$scope.component.columns[cName].cellExpression = "='<a target=\"_top\" href=\"../survey/reports/dashboard.jsp?commUniId=' + row['CommServUniqueId'] + '\">' + row['CustomerName'] + '</a>'";
													$scope.component.columns[cName].hidden = false;
													$scope.component.columns[cName].displayName = "Customer";
													$scope.component.columns[cIdx].hidden = true;
													$scope.translatedColNames["CustomerName"] = "Customer";
												}
											}

											var lctIndex = $scope.getColumnIndexByID("Lastcollectiontime");

											var CommCellIDIdx = $scope.getColumnIndexByID("CommCellID");
											if(lctIndex){
												$scope.component.columns[lctIndex].visible = false;
											}

											if(CommCellIDIdx){
												$scope.component.columns[CommCellIDIdx].visible = false;
											}

											$scope.component.columns.splice(2,0,$scope.component.columns.splice(cvIndex,1)[0]);
											/*if(cvIndex && isPrivate){
												$scope.component.columns[cvIndex].visible = false;
											}*/
										}

										$scope.initTableActions(params);
										// Reintialize the filters based on the new column defintions.
										if ($scope.dataSet.endpoint !== 'DATACUBE')
											$scope.initFilters();

										if ($scope.isFromOldUrl && $scope.oldReportColumns &&
												$scope.oldReportColumns.length > 0)
											$scope.applyOldUrlColumns();
										if($scope.dataSet.endpoint === "DATACUBE")
											$scope.gridInitialized = true;
									}

									var colOrder = $scope.mergedParams[$scope.component.id+".colOrder"];
									if(colOrder){
										colOrder.split(",").map(a=>{
											var k = a.split(':');
											var toPosition = parseInt(k[1]);
											$scope.colOrder[k[0]] = toPosition;
											var fromPosition = $scope.getColumnIndexByID(k[0]);
											reorderColumns(fromPosition,toPosition);
										});
									}
									if ($scope.component.allColumns && $scope.filterColumns.length == 0) {
										$scope.initFilters();
									}
									if ($scope.dataSet.endpoint !== 'DATACUBE' || $scope.useCREApiForSolr) {
										var data = [];
										var row = {};
										var addToSelectedRow = false;
										for (var i = 0; i < records.length; i++) {
											var resultRow = records[i];
											var resultDataSet = {};
											var rowIndex = i;
											for (var j = 0; j < columns.length; j++) {
												var col = columns[j];
												var id = col.name;
												if ($scope.component.allColumns)
													id = $scope.getIdforTheColumn(id);
												resultDataSet[id] = resultRow[j] === 0 || resultRow[j] === false ? "" +
														resultRow[j] : resultRow[j];
												row[id] = resultRow[j]; // first prepare the row object so that row[columId] needs to be evaluated. This will have the raw data value
											}
											if (!$scope.avoidClientScripts)
												applyCellExpr(resultDataSet, row, rowIndex);
											data.push(resultDataSet);
											if($scope.component.selectedValues && $scope.component.selectedValues.length > 0 && $scope.component.selectedValues.indexOf(resultDataSet[$scope.SYS_ROWID]) !== -1){
												//add to selected Rows to initialize the row selection.
												if ($scope.component.enableMultiRowSelection) {
													$scope.selectedRows[resultDataSet[$scope.SYS_ROWID]] = resultDataSet;
													$scope.checkboxes[resultDataSet[$scope.SYS_ROWID]] = true;
												}else{
													$scope.selectedRows[0] = resultDataSet;
													$scope.singleSelectValue = resultDataSet[$scope.SYS_ROWID];
												}
												$scope.showSelectedRowsLabel = true;
											}
										}
										records = null;
										$defer.resolve(data);

										/*
										 * initAlarmDialog - verify if alarmDetails cached and componentName maps.
										 * $scope.requestParms.alarmId - check if alarmId being passed from alert manager page and if alarmDetails is already cached, we will not initiate the call again.
										 *
										 */

						            	$scope.initAlarmDialog = function (){
						        			if($scope.alarmDetails && !$scope.alarmDetails.error && $scope.alarmDetails.componentName == $scope.component.id){
				        		        		$scope.openAlarmsDialog();
						        			}
						            	}
							            if(!$scope.requestParms){
							            	$scope.requestParms = customReportSvc.getUrlParams();
							            }

							            if($scope.requestParms.alarmId && $scope.requestParms.alarmId > 0){
							            	var param = {};
							            	param.alarmId = $scope.requestParms.alarmId;
							            	var alarmDetails ;
							            	if(!$scope.alarmDetails){
							            		reportService.getAlarmDetails(param).success(function (data) {
								        			if (data && data.length) {
								            			alarmDetails = data[0];
								        				if(alarmDetails.error){
								        					var errorMessage = "Unable to find alert details for alarmId ["+alarmDetails.alarmId+"], Error Message :" + alarmDetails.error;
								                			console.error(errorMessage);
								                     		$scope.alarmDetails = {};
								                    		$scope.alarmDetails.error = errorMessage;
								                			customReportSvc.errorToast(alarmDetails.error);
								        				}else{
								                			var alarmURL = decodeURIComponent(alarmDetails.alarmURL);
								                			var alarmDataSetName = customReportSvc.getParameter("alarmDataSetName", alarmURL);
								                			var componentName = customReportSvc.getParameter("componentName", alarmURL);
								                			alarmDataSetName = parseInt(alarmDataSetName,0);
								        					alarmDetails.alarmDataSetName = alarmDataSetName;
								        					alarmDetails.componentName = componentName;
								        					$scope.alarmDetails = alarmDetails;
								        					$scope.initAlarmDialog();
								        				}

								        			}

								        		}).error(function(e){
								        				var errorMessage = "Unable to find alert details for alarmId ["+param.alarmId+"], Error Message :" + e;
								                		console.error(errorMessage);
								                		$scope.alarmDetails = {};
							                    		$scope.alarmDetails.error = errorMessage;
								                		customReportSvc.errorToast(alarmDetails.error);
								        		});
							            	}else if(!$scope.alarmDetails.error){
							            		$scope.initAlarmDialog();
							            	}

							            }
									} else {
										//we are already getting the records as key value pairs(array of objects), so need of conversion
										if (!$scope.avoidClientScripts) {
											angular.forEach($scope.component.columns, function(col, index) {
													var cellExpression = col.cellExpression || $scope.component.allCellExpression;
													if(cellExpression && cellExpression.type === "date" && $scope.tempComponent && $scope.tempComponent.latestSearchParams) {
														var searchParams = JSON.parse($scope.tempComponent.latestSearchParams).searchParams;
														var DateFormat = {};
														var timeZone = {};
														DateFormat["key"] = "clientDateTime";
														var fmt = cellExpression.fmt;
														if (fmt === 'AutoDateTime') {
															fmt = "MMM dd, YYYY hh:mm:ss a";
														} else if (fmt === 'Auto') {
															fmt = "MMM dd, YYYY";
														} else if (fmt === 'Custom') {
															fmt = cellExpression.customDateFormat;
														}
														DateFormat["value"] = fmt;
														timeZone["key"] = "clientTimezone";
														timeZone["value"] = moment.tz.guess(); //destination time zone will be always browser's timezone
														searchParams.push(DateFormat);
														searchParams.push(timeZone);
														var tempObj = {};
														tempObj["searchParams"] = searchParams;
														$scope.tempComponent.latestSearchParams = JSON.stringify(tempObj);
														return;
													}
											});
											angular.forEach(records, function(obj, index) {
												if(obj.hasOwnProperty("contentid"))
													obj.sys_rowid = obj.contentid;
												applyCellExpr(obj, obj, index);
											});
										}
										$defer.resolve(records);
									}

									// this is to trigger the close Loading call backs for the sorting and preview.
									if ($scope.component.id === 'PreviewTable') {
										/*
										 * $scope.processFields(columns);
										 *
										 * if (typeof response.rowExpression === "string") {
										 * $scope.processRowExpression(response.rowExpression) }
										 */

										if (typeof response.rawData === "object") {
											$scope.processRawData(response.rawData);
										}
									}

									 if (!$scope.gridInitialized) {
                                    	  $scope.initTableState();
                                     	  $scope.gridInitialized = true;
                                    }

									$scope.calculaLastVisiblecolumn();

									if ($scope.isAlarm) {
										//remove the columns which are hidden and not visible. we are doing this after all the data is processed , only to execute the expressions. A visible column expression may depend on the data of invisible column
										for (var j = 0; j < $scope.component.columns.length; j++) {
											var col = $scope.component.columns[j];
											if (!col.visible) {
												console.log("removing the column " + col.displayName +
														" becuase it is either not visible or hidden");
												$scope.component.columns.splice(j, 1);
												$scope.filterColumns.splice(j, 1);
												j--;
											}
										}
									}

									params.lastPageNo = Math.ceil(params.total() / params.count());

									$scope.handleErrorsOrWarnings(failures, false);

									if ($scope.reportMode === 'preview') {
										$scope.handleErrorsOrWarnings(response.warnings, true);
									}

									if( $scope.isExportTwoStep() )
									{
										if(angular.isUndefined(window.reportMetaData))
											window.reportMetaData={
												"tableMetaData" :{}
										};

										//Setting values for final Export Size
										var loadLimit=10000;
										$scope.dataSetParams.limit=loadLimit;
										var tempComponent=$scope.component;
										tempComponent.pageSize=loadLimit;

										window.reportMetaData.tableMetaData[$scope.component.id]={
										"allCellExpression": $scope.component.allCellExpression,
										//"requestParams": resultData.config.data,
										"dataURL": dataSetUtility.getUrlForDataComponent(tempComponent,$scope.dataSet, $scope.page, $scope.dataSetParams,$scope.mergedParams),
										"customJsCode" :$scope.page.body.customJsCode,
										"tableWrapperDivID": "table_"+$scope.component.id,
										"rowSelector" : "tbody tr[data-ng-repeat=data in $data]",
										"jsFilesList"  : exportConstants.customReportJSFileList,
										"rowStyleExpression": $scope.component.rowStyleExpression,
										"class" :{
												"odd" : "odd",
											    "even": "even",
											    "generic": "" },
										"columns":$scope.component.columns,
										"currentURL" : window.location.href,
										"customReports" : customReports
										};
										$scope.dataSetParams.limit=$scope.component.pageSize;
									}

									if ($scope.exportType)
										$scope.setAllComponentsIntialized($scope.component);
									//If user wants to show preview in component then will need to update preview when data changes.
									$timeout(function() {
										if ($scope.component.rowFormatter && $scope.component.rowFormatter.action === "ShowPreview"
											&& $scope.component.rowFormatter.previewComponentId && $scope.isCustomHtmlCompPresent($scope.component.rowFormatter.previewComponentId))
											$scope.showPreview($scope.component.rowFormatter);
									});



								};

								$scope.initFilters = function() {
									$scope.filterColumns = [];
									// initialize filters with defaults.
									angular.forEach($scope.component.columns, function(value, key) {

										var filter = {
											id : value.id,
											searchType : 'text',
											value : "",
											visible : value.visible,
											type : value.type,
											hidden : value.hidden
										};
										$scope.filterColumns.push(filter);
									});
								};



								$scope.getColumnIndexByID = function(colId) {
									for (var i = 0; i < $scope.component.columns.length; i++) {
										if (colId.toLowerCase() === $scope.component.columns[i].id.toLowerCase())
											return i;
									}
									return -1;
								};

								$scope.initFilter = function(columnId, filterValue) {
									for (var i = 0; i < $scope.filterColumns.length; i++) {
										var filterCol = $scope.filterColumns[i];
										if (filterCol.id == columnId) {
											filterCol.value = filterValue;
										}
									}
									;
								};

								$scope.updateColumnVisibility = function(columnIds, visibility) {
									if(!angular.isDefined($scope.dataSetMap)) {
										$scope.dataSetMap = {};
										angular.forEach($scope.dataSet.fields, function(col) {
											var colId = $scope.generateColumnId(col.name);
											$scope.dataSetMap[colId] = col;
										});
									}
									angular.forEach(columnIds, function(columnId, index) {
										var colIndex = $scope.getColumnIndexByID(columnId);
										if(colIndex === -1) {
											var column = $scope.addColumn($scope.dataSetMap[columnId]);
											column.visible = visibility;
											$scope.filterColumns.push(column);
											$scope.colsCopy.push(column);
										} else {
											$scope.filterColumns[colIndex].visible = visibility;
											$scope.component.columns[colIndex].visible = visibility;
										}
										if (visibility)
											$scope.visibleColumns.push(columnId);
										else
											$scope.hiddenColumns.push(columnId);

									});
								};

								$scope.initTableState = function() {
									var urlParams = $scope.mergedParams;
									if (urlParams) {
										angular.forEach(urlParams, function(param, key) {
											var comp = key.substring(0, key.indexOf('.')); // get the component name from the key
											if (comp === $scope.component.id) { // if key starts with the comnponent id
												var type = key.substring(key.indexOf("."), key.length);
												if (type == ".sort") {
													var colIds = param.split(",");

													angular.forEach(colIds, function(colId, key) {
														var direction = colId.indexOf("-") === 0 ? "desc" : "asc";
														colId = colId.indexOf("-") == 0 ? colId.substring(1,
																colId.length) : colId;
														var idx = $scope.getColumnIndexByID(colId);
														if (idx)
															$scope.component.columns[idx].direction = "sorting_" +
																	direction;
													});
												}
												if (type.indexOf(".filter.") != -1) {
													var columnId = key.substring(key.indexOf(".filter.") + 8,
															key.length);
													var colIndex = $scope.getColumnIndexByID(columnId);
													$scope.filterColumns[colIndex].value = param;
													if (!$scope.avoidClientScripts)
														$scope.component.showFilterByDefault = true;
												}
												if (type == ".show") {
													$scope.updateColumnVisibility(param.split(","), true);
												}

												if (type == ".hide") {
													$scope.updateColumnVisibility(param.split(","), false);
												}
											}
										});
									}
								};

								$scope.initTableActions = function(params) {
									params.currentPage = params.page();
									params.next = function(page) {
										page = page + 1;
										if (page <= params.lastPageNo) {
											params.currentPage = page;
											$scope.tableParams.page(page);
										}
									};
									params.previous = function(page) {
										page = page - 1;
										if (page > 0) {
											params.currentPage = page;
											$scope.tableParams.page(page);
										}
									};
									params.lastPage = function(page) {
										params.currentPage = page;
										$scope.tableParams.page(page);
									};

									params.firstPage = function() {
										params.currentPage = 1;
										$scope.tableParams.page(1);
									};
								};


								$scope.checkDataSourceColumnAndHide = function(column){
									if (customReports.appName === 'adminconsole') {
										column.hidden = true;
									}else{
										column.visible = false;
									}

//									if (customReports.appName === 'webconsole') {
//										var col =  angular.copy(column,{});
//										column.aggrType = 'CountDistinct';
//										$scope.getData($scope.dataSet, false, false, {columns:[col]}, false).then(function(data) {
//											if(data.data.records.length > 1){
//												column.hidden = false;
//												column.visible = true;
//											}
//										});
//									}
								}

								$scope.hideSystemColumn = function(column){
									if(!$scope.component.sys_rowid_col && column.dataField.toLowerCase() === $scope.SYS_ROWID){
										column.hidden = true;
									}

									if($scope.component.sys_rowid_col && column.dataField.toLowerCase() === "sys_rowid"){
										column.hidden = true;
									}

									if(column.dataField.toLowerCase() === "data source"){
										$scope.checkDataSourceColumnAndHide(column);
									}
								}

								$scope.columnAlreadyExist = function(columnName) {
									var alreadyFound = false;
									for (var i = 0; i < $scope.component.columns.length; i++) {
										var col = $scope.component.columns[i];
										if (col.dataField == columnName) {
											alreadyFound = true;
											break;
										}
									}
									;
									return alreadyFound;
								};

								$scope.addedColumns = [];
								$scope.numberArray = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];

								$scope.dropped = function(dragEl, dropEl) {
									if ($scope.reportMode == "viewer") {
										return;
									}

									if (!$scope.component.isSelected) {
										customReportSvc.errorToast('Select the component to add a column.');
										return;
									}
									var dest = document.getElementById(dropEl);
									var src = document.getElementById(dragEl);

									var drag = angular.element(src);
									var drop = angular.element(dest);
									if (drag.data("componenttype") != "COLUMN") { //check is needed because rearranging columns also triggered drop
										$scope.columnRearranged = true;
										return;
									}

									var columnName = drag.attr("data-name");
									var columnType = drag.attr("data-type");
									var origType = drag.attr("data-origtype");
									var dataField = drag.attr("data-datafield");
									var dataSetEntity = drag.data("datasetentity");
									var dataSetName = dataSetEntity.dataSetName;
									if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
										$scope.associateDataSetToComponent(dataSetEntity);
									} else if ($scope.component.dataSet.dataSetName != dataSetName) {
										alert("Mismatched data Sets");
										return;
									}

									if ($scope.component.type == 'TABLE') {

										$scope.addedColumns.push(columnName);
										$scope.columnRearranged = false;
										if (columnName == "allColumns") {
											$scope.component.allColumns = true;
											$scope.allColumnsDropped = true;
										} else {
											if (!$scope.component.allColumns) {
												$scope.addColumn({
													name : columnName,
													dataField : dataField,
													type : columnType,
													origType : origType
												});
											} else {
												for (var i = 0; i < $scope.component.columns.length; i++) {
													if (dataField === $scope.component.columns[i].dataField)
														$scope.component.columns[i].hidden = false;
												}
											}
										}
										$scope.getTableData();
									} else if ($scope.component.type == 'PIVOT_TABLE') {

										if (drop.data('droptype') == "pivotRow") {
											$scope.component.pivotRow = {
												title : {
													text : columnName
												},
												column : columnName
											};
											$scope.$apply();
										} else if (drop.data('droptype') == "pivotColumn") {
											$scope.component.pivotColumn = {
												column : columnName
											};
											var showNumberOps = false;
											if ($scope.numberArray.indexOf(columnType) != -1)
												showNumberOps = true;
											$scope.$apply();
										} else if (drop.data('droptype') == "pivotCell") {
											var showNumberOps = false;
											if ($scope.numberArray.indexOf(columnType) != -1)
												showNumberOps = true;
											$scope.component.pivotCell = {
												column : columnName,
												aggrType : "Count",
												showNumberOps : showNumberOps
											};
										} else {
											alert('Drop the column in the designated fields above');
											return;
										}

										if ($scope.component.pivotRow.column && $scope.component.pivotColumn) {
											if (!$scope.component.pivotCell || !$scope.component.pivotCell.column) {
												$scope.component.pivotCell = {
													column : columnName,
													aggrType : "Count",
													showNumberOps : showNumberOps
												};
											}
											$scope.getTableData();
										}

									}

								};

								$scope.deleteColumn = function(type) {
									$scope.resetTable = true;
									$scope.component[type] = undefined;
									$scope.getTableData();
									if (!$scope.component['pivotRow'] && !$scope.component['pivotColumn'] &&
											!$scope.component['pivotCell']) {
										$scope.component.dataSet = undefined;
									}
								}

								$scope.reloadComponent = function(refreshCache) {
									$scope.gridInitialized = false;
									$scope.getTableData(true);
								};

								$scope.getTableData = function(refreshCache) {
									if (refreshCache)
										$scope.clearAndResetCacheId();
									$scope.tableParams.reload();
								};

								/*
								 * if(!$scope.component.columns) $scope.component.columns = [];
								 */

								/*
								 * $scope.addParameterToUrl = function(name,value){ if($scope.reportMode ==
								 * "viewer" && $scope.gridInitialized){
								 * customReportSvc.addParameterToUrl(name,value); }else{
								 * customReportSvc.sharedData.requestString[name] = value; } };
								 */

								$scope.$on("LVL-DRAG-START", function(event, dragEl) {
									if (!$scope.component.isSelected)
										return;
									var drag = angular.element(dragEl);

									if (drag.data("componenttype") != "COLUMN")
										return;

									angular.element("#table_" + $scope.component.id).addClass("tableDropTarget");
								});

								//TODO
								//to be fixed
								$scope.$on("LVL-DRAG-END",
										function(event, column) {
											if ($scope.component.isSelected)
												angular.element("#table_" + $scope.component.id)
														.removeClass("tableDropTarget");

											if ($scope.reportMode == "viewer")
												return;
											/*
											 * if ($scope.columnRearranged) { $scope.columnRearranged = false;
											 * $scope.reorderColumns() return; }
											 */
											//
											//			if(column.parentElement.parentElement.parentElement.parentElement.parentElement.parentElement.attributes["data-name"].value == $scope.component.id){
											//				if($scope.component.allColumns){
											//					customReportSvc.toast('Cannot remove column when the allColumns is selected');
											//					return;
											//				}
											//				var i = 0;
											//				angular.forEach($scope.gridOptions.$gridScope.columns, function(value,key){
											//					if(value.displayName == column.innerText.trimRight()) {
											//						value.visible = false;
											//						$scope.gridOptions.$gridScope.columns.splice(i,1);
											//						$scope.component.columns.splice(i,1);
											//					}
											//					i++;
											//				});
											//			}
											//			$scope.getTableData(null,true); // need to refetch the data incase of aggreagtaion ot group by is applied in the table.
											//			$scope.$apply();
										});

								$scope.dragHead = '';
								$scope.dragImageId = "dragtable";
								$scope.showDraggingInfo = function() {
									var ret = true;
									if ($scope.component.allColumns || $scope.reportMode != 'builder') {
										ret = false;
									} else if ($scope.tableColumns && $scope.tableColumns.valueFieldsList &&
											$scope.tableColumns.valueFieldsList.length > 0)
										ret = false;

									$scope.showDraggingDiv = ret;

									return ret;
								};

								var reorderColumns = function(fromPostion,toPosition){
									var column = $scope.component.columns[fromPostion]; //reference to element
									var filterColumn = $scope.filterColumns[fromPostion]; //reference to element
									$scope.component.columns.splice(fromPostion, 1);
									$scope.component.columns.splice(toPosition, 0, column);
									$scope.filterColumns.splice(fromPostion, 1);
									$scope.filterColumns.splice(toPosition, 0, filterColumn);
								}

								$scope.handleDrop = function(fromPostion, targetElem) {
									var toPosition = $(targetElem).closest('th').attr('dragdata');
									var column = $scope.component.columns[fromPostion];
									reorderColumns(fromPostion,toPosition);
									$scope.colOrder[column.id] = toPosition;
									var colOrderString = "";
									for(var i in $scope.colOrder){
										colOrderString = colOrderString + i + ":" + $scope.colOrder[i]+","
									}
									colOrderString=colOrderString.substring(0,colOrderString.length-1);
									$scope.addParameter($scope.component.id + ".colOrder", colOrderString);
								};

								if ($scope.isDcubeEnabledInCustomReports) {
									// var calculateItemHeight = function(height) {
									// 	var residue = height - parseInt(height);
									// 	if (residue<=0.5)
									// 		return parseInt(height);
									// 	else
									// 		return parseInt(height)+1;
									// }
									// handler to listen for ngTableAfterReloadData to recalculate number of rows
									$scope
											.$on("ngTableAfterReloadData",
													function(event, redraw) { // will need to change when ngTable is getting updated
														$timeout(function() {
															/*if (!redraw) {
																$('li[comp=' + $scope.component.id + '] .tableContainer' +
																		' tbody tr td')
																		.each(function(index, value) {
																			$(value)
																					.attr('data-label',
																							$('li[comp=' +
																									$scope.component.id +
																									'] .tableContainer' +
																									'  thead th')[index %
																									($('li[comp=' +
																											$scope.component.id +
																											'] .tableContainer' +
																											' thead th').length)].innerText);
																		});
															}*/
															if ($scope.quickAnalysisMode) {
																$scope.gridsterItem.sizeY = Math.ceil(($scope.quickAnalysisMode ? $scope.quickAnalysisMaxHeight : tableHeight) /
																$scope.gridster.rowHeight);
																$scope.calcQuickAnalysisHeight();
															}

															if ($("li[comp=" + $scope.component.id + "]").find(".tableContainer table").height() > 30) {

																$("li[comp=" + $scope.component.id + "]").find('.bottom').parent().parent().css('height','40px');

																if($scope.component.autoHeight === "Off") {
																	var panelHeight = $("li[comp=" + $scope.component.id + "]").find(".component-body").outerHeight(true) + 11;//table is taking extra 11 px
																	var headerHeight = 30;
																	var footerHeight =  40;
																	var tbodyHeight = panelHeight - headerHeight - footerHeight;
																	$("li[comp=" + $scope.component.id + "]").find(".table-scroll tbody").css('min-height', tbodyHeight+'px');
																} else {

																	var tableHeight = $("li[comp=" + $scope.component.id + "]")
																		.find(".tableContainer table").height() +
																		$("li[comp=" + $scope.component.id + "]")
																				.find(".reportstabletitle")
																				.outerHeight(true) +
																		$("li[comp=" + $scope.component.id + "]").find('.bottom').parent().parent().height();
																		if($scope.component.enableButtonPanel){
																			tableHeight += $("li[comp=" + $scope.component.id + "]").find('.buttonPanel').outerHeight(true);
																		}

																		if ($scope.component.showFilterByDefault) {
																			tableHeight += $("li[comp=" + $scope.component.id + "]")
																					.find("#filterRow_previewTable").height() - 10;
																		} else {
																			tableHeight+=10;
																		}
																		if ($scope.exportType) {
																			tableHeight += 30;
																		}

																		if(tableHeight < 300){
																			$scope.colsDropMaxHeight = tableHeight - 30;
																		}else{
																			$scope.colsDropMaxHeight = 300;
																		}

																		var tableWidth = $("li[comp=" + $scope.component.id + "]")
																				.find(".tableContainer").width();
																		var gridsterCurColWidth = $("#reportContentWrapper").size() > 0 ? $("#reportContentWrapper").width() / 12 : $scope.gridster.curColWidth;
																		if ($scope.gridsterItem && $scope.gridsterItem.$element &&
																				!$scope.component.collapsed && tableWidth > 0 &&
																				gridsterCurColWidth > 0) {
																			if (!$scope.isFullScreen)
																				$scope.gridsterItem.sizeX = Math.ceil(tableWidth /
																						gridsterCurColWidth);
																			$scope.gridsterItem.sizeY = Math.ceil(tableHeight /
																					$scope.gridster.rowHeight);
																		}
																}
															}
														});

														if($scope.component.enableButtonPanel){
															$scope.checkAllRowsEnabled();
														}
													});

								}


								//Button Panel changes

								$scope.registerLocalCallBack("resetSelectedRows", function(componentId) {
									if ($scope.component.id === componentId) {
										$scope.resetSelectedRows();
									}
								});

								$scope.resetSelectedRows = function(){
									$scope.selectedRows = {};
									$scope.checkboxes = {};
									$scope.singleSelectValue="";
								}

								$scope.checkAllRowsEnabled = function(){
									var allrows = true;
									angular.forEach($scope.tableParams.data,function(dataObj,index){
										if(!$scope.checkboxes[dataObj[$scope.SYS_ROWID]]){
											allrows = false;
										}
									});

									$scope.allRows.selected = allrows;
								}

								$scope.rowChanged = function(key,dataIndex){
									if ($scope.component.enableMultiRowSelection) {
										if ($scope.checkboxes[key]) {
											var temp = angular.copy($scope.tableParams.data[dataIndex],{});//cloning the object , so that any changes to the selectedRows will not be reflected in the table
											$scope.selectedRows[key] = temp;
											$scope.checkAllRowsEnabled();
										} else {
											delete $scope.selectedRows[key];
											if ($scope.allRows.selected) {
												$scope.allRows.selected = false;
											}
										}
									}else{
										$scope.selectedRows[key] = $scope.tableParams.data[dataIndex];
										$scope.singleSelectValue = $scope.selectedRows[key][$scope.SYS_ROWID];
									}
									if(Object.keys($scope.selectedRows).length > 0){
										$scope.showSelectedRowsLabel = true;
									}else{
										$scope.showSelectedRowsLabel = false;
									}
									$scope.evalButtonStates();
								}

								$scope.allRowsChanged = function(){
									//	$scope.selectedRows = $scope.tableParams.data;
										if($scope.allRows.selected){
											angular.forEach($scope.tableParams.data,function(dataObj,index){
												var temp = angular.copy(dataObj,{});//cloning the object , so that any changes to the selectedRows will not be reflected in the table
												$scope.selectedRows[dataObj[$scope.SYS_ROWID]] = temp;
												$scope.checkboxes[dataObj[$scope.SYS_ROWID]] = true;
											});
										}else{
											$scope.selectedRows = {};
											$scope.checkboxes = {};
										}
										$scope.evalButtonStates();
								}

								$scope.toggleSelectedRows = false;

								$scope.showSelectedRows = function(toggle){
									if(!$scope.orginalData){ // keep a copy of the orginal computed data to switch between.
										$scope.orginalData=$scope.tableParams.data;
									}
									$scope.showSelectedRowsOperation = true;
									//$scope.toggleSelectedRows = !$scope.toggleSelectedRows;

									if(toggle){
										$scope.datToDefer=$scope.cleanUpObject($scope.selectedRows);
									}else{
										$scope.datToDefer=$scope.orginalData;
									}

									$scope.tableParams.reload();
								}

								$scope.validateExpression = function(selectedComponent, rowIndexVal, cellData, isEnable) {
									var retVal = false;
									var validateObject = isEnable ? selectedComponent.enable
											: selectedComponent.visible;
									if (validateObject === "always") {
										retVal = true;
									} else {
										var args = {};
										args["expression"] = isEnable ? selectedComponent.enableExpression
												: selectedComponent.visibleExpression
										args["cellData"] = cellData
										args["row"] = $scope.tableParams.data[rowIndexVal];
										args["rowIndex"] = rowIndexVal;
										retVal = rpt.evalExpression(args);
									}
									return retVal;
								}


								$scope.evalItemExpression = function(itemExpression, rowIndexVal,cellData, isURL) {
									if (itemExpression) {
										var args = {};
										if (typeof itemExpression === "string"
												&& itemExpression.substring(0, 2) !== ":=") {
											if (!isURL) {
												itemExpression = ":=" + itemExpression;
											}
										}
										args["expression"] = itemExpression;
										args["cellData"] = cellData

										args["row"] = $scope.tableParams.data[rowIndexVal];
										args["rowIndex"] = rowIndexVal;
										var value = rpt.evalExpression(args);
										return value;
									}

								}

								$scope.evalComponentExpression = function(component, rowIndexVal,cellData, isURL) {
									var itemExpression="";
									if (component.type === "button" || component.type === "link"){
										itemExpression = component.clickExpression;
										if(!itemExpression){
											itemExpression = $scope.generateItemExpression(component.clickParams);
										}
									} else if (component.type === "image") {
										itemExpression = component.clickExpression;
									}
									return $scope.evalItemExpression(itemExpression, rowIndexVal,cellData, isURL);
								}

								$scope.generateItemExpression = function(clickParams) {
									var generatedExpression;
									if (clickParams.type === "Custom"){
										generatedExpression = clickParams.customExpression;
									} else if (clickParams.type === "Workflow"){
										generatedExpression = "return openForm({'workflowName':'" + clickParams.name + "'";
										var inputs = [];
										for (var i = 0; i < clickParams.inputs.length; i++){
											if (clickParams.inputs[i].value){
												inputs.push("'" + clickParams.inputs[i].id + "': " + clickParams.inputs[i].value);
											}
										}
										if (inputs.length !== 0) {
											generatedExpression += ", inputs:{";
											for (var i = 0; i < inputs.length; i++){
												generatedExpression += inputs[i] + ",";
											}
											generatedExpression = generatedExpression.substring(0, generatedExpression.length - 1) + "}";
										}

										var autoSubmit = false;
										if (clickParams.autoSubmit) {
											autoSubmit = clickParams.autoSubmit;
										}

										var refresh = false;
										if (clickParams.refreshOnSuccess) {
											refresh = clickParams.refreshOnSuccess;
										}

										generatedExpression += ",_submit:" + autoSubmit + ",refreshOnSuccess:" + refresh;

										if (clickParams.fullPage != undefined && clickParams.fullPage === true) {
											generatedExpression += ", fullPage:true";
										}

										generatedExpression += ", targetElement:'#reportArea'";

										generatedExpression += "})";
									} else if (clickParams.type === "Report"){
										var baseUrl = window.location.pathname.substring(window.location.pathname.lastIndexOf("/") + 1);
										var urlParams = [];
										var url = "";
										urlParams.push("reportId=" + clickParams.reportId);
										if (clickParams.pageName) {
											urlParams.push("pageName=" + clickParams.pageName);
										}
										if (clickParams.inputs.length !== 0){
											for (var i = 0; i < clickParams.inputs.length; i++){
												if (clickParams.inputs[i].value){
													urlParams.push("input." + clickParams.inputs[i].id + "=\"+" + clickParams.inputs[i].value+"+\"");
												}
											}
										}
										for (var i = 0; i < urlParams.length; i++){
											url += urlParams[i] + "&";
										}
										url = url.substring(0, url.length - 1);
										url = document.location.href=document.location.origin+document.location.pathname+"?"+url
										generatedExpression = "=document.location.href="+url;
									} else if (clickParams.action === "EditTableRecords") {
										var baseUrl = window.location.origin + customReports.contextPath + "/tableForm.do?";
										var urlParams = [];
										var url = ""
										urlParams.push("tableId=" + encodeURIComponent(clickParams.tableId));
										if (clickParams.pageName) {
											urlParams.push("pageName=" + encodeURIComponent(clickParams.pageName));
										}
										if (clickParams.rowId) {
											urlParams.push("sysRowId=" + encodeURIComponent(clickParams.rowId));
										}
										if (clickParams.inputs.length !== 0) {
											angular.forEach(clickParams.inputs, function(input, idx) {
												if (input.value) {
													urlParams.push(input.id + "=" + $scope.getReportInputValue(input.isMulti, $scope.evalExpression(input.value)));
												}
											})
										}
										angular.forEach(urlParams, function(param, idx) {
											url += param + "&";
										})
										url = url.substring(0, url.length - 1);
										if (clickParams.openInNewTab) {
											generatedExpression = "=window.open(\'" + baseUrl + url + "\',\'_blank\')";
										} else {
											generatedExpression = "=document.location.href=\'" + baseUrl + url + "\'";
										}
									}
									return generatedExpression;
								}

								$scope.evalTitleExpression = function(itemExpression, rowIndexVal,colIndexVal,cellData, isURL) {
									if (itemExpression) {
										itemExpression = customReportSvc.checkExpressionToLocalize(itemExpression);
										var args = {};
										args["expression"] = itemExpression;
										if(itemExpression.indexOf("=rpt.translate") !== 0){
											args["cellData"] = cellData;
											args["row"] = $scope.tableParams.data[rowIndexVal];
											args["rowIndex"] = rowIndexVal;
											args["colIndex"] = colIndexVal;
										}
										var value = rpt.evalExpression(args);
										return value;
									}
								}

								/*$scope.validateVisibilityExpression = function(selectedComponent) {
									var retVal = false;
									if (selectedComponent.visible === "always") {
										retVal = true;
									} else {
										var args = {};
										args["expression"] = selectedComponent.visibleExpression;
										retVal = rpt.evalExpression(args);
									}
									return retVal;
								}

																$scope.callEventListner = function(eventName, eventParams, rowIndexVal, cellData) {
																	var row = $scope.tableParams.data[rowIndexVal];
																	data = {};
																	for (var i = 0; i < eventParams.length; i++) {
																		//data[eventParams[i].paramKey] = row[eventParams[i].paramValue];
																		var args = {};
																		args["expression"] = "=" + eventParams[i].paramValue;
																		data[eventParams[i].paramKey] = rpt.evalExpression(args);
																	}
																	$scope.$emit(eventName, data);
																}*/



								$scope.updatePropertyOfObject = function(array,prop,value){
									angular.forEach(array,function(dataObj,index){
										dataObj[prop] = value;
									});
								}

								$scope.toggleFilters = function(e){
						    		$scope.component.showFilterByDefault=!$scope.component.showFilterByDefault;
						    		if(e){
							    		e.stopPropagation();
										e.preventDefault();
						    		}
						    	}

								$scope.showNoResultMsg = function() {
									return angular.element("li[comp=" + $scope.component.id + "] .colList").children().not( ".noResultInfo" ).length === 0;
						    	}



						    	$scope.openColumnSettingModal = function() {
						    		 var modalInstance = $uibModal.open({
					                   templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/columnSettingModal.jsp",
					                   controller: "columnSettingCtrl",
					                   windowClass: 'colSettingModalWindow reportModal',
					                   resolve: {
					                   		columns : function() {
					                   			var fields = $scope.dataSet.fields,columns=[];
					                   			angular.forEach($scope.component.columns,function(column) {
					                   				columns.push({
					                   							 	dataField : column.dataField,
					                   							  	displayName : column.displayName,
					                   							  	visible : column.visible,
					                   							  	hidden : column.hidden
					                   							});

					                   			});
					                   			return columns;
					                   		},
					                   		dataSet : function() {
					                   			return $scope.dataSet;
					                   		},
					                   		Title : function() {
					                   			return localMsg["ColumnSettings"];
					                   		}
					                   }
					                });

						    		modalInstance.result.then(function (selectedCols) {
						    				angular.forEach($scope.component.columns,function(column,index) {
									      		var isColPresent = selectedCols.filter(function(col) {
													return col.dataField === column.dataField;
												}).length > 0;
												if(!isColPresent) {
													column.visible = $scope.filterColumns[index].visible = false;
												} else {
													column.visible = $scope.filterColumns[index].visible = true;
												}
									      	});
					    					var colsToBeAdded = selectedCols.filter(function(col) {
					    						return $scope.component.columns.filter(function(column) {
					    							return col.dataField === column.dataField
					    						}).length === 0;
					    					});
					    					if(colsToBeAdded) {
					    						angular.forEach(colsToBeAdded,function(col) {
						    						col = $scope.addColumn(col);
						    						$scope.colsCopy.push(col);
						    					});
						    					$scope.getTableData();
					    					}


									   });

						    	}

						    	$scope.getVisibleColCnt = function() {
						    		return $scope.component.columns.filter(function(col) {
						    			return (col.visible && !col.hidden);
						    		}).length;
						    	}


						    	$scope.$on('resize',function(sizes, gridster) {
									$scope.$broadcast('ngTableAfterReloadData',true);
								});

								$scope.$watch('component.showFilterByDefault', function() {
									$scope.$broadcast('ngTableAfterReloadData',true);
								});

								$scope.$watch('component.autoHeight', function(newVal,oldVal) {
									$scope.$broadcast('ngTableAfterReloadData',true);
								});

								angular.element("html").bind("click", function(e) {
									acMenuActions.hideMenu();
									if (angular.element(e.target).closest("#col_menu_" + $scope.component.id + ".fadeOutSection").length > 0) {
										return false;
									}
									angular.element("li[comp=" + $scope.component.id + "] .reportColums_container").slideUp();
									$("li[comp=" + $scope.component.id + "]").removeClass("visible-overflow");
								});

								var selector = '#'+$scope.component.id;
								$('body').off('click', selector+' .page-action-button.menu');
								$('body').on('click', selector+' .page-action-button.menu', function (event) {
									var targetElement = event.target.parentElement;
									var menuSelector = $(targetElement).find('.dropdown-selector-menu');
									if ($(menuSelector).hasClass('show')) {
										$(menuSelector).removeClass('show').addClass('hide');
									} else {
										$(menuSelector).removeClass('hide').addClass('show');

										$(targetElement).find('[data-toggle="dropdown-selector"]').focusout(function() {
											setTimeout(function() {
												$(menuSelector).removeClass('show').addClass('hide');
											}, 500);
										});
									}

									event.stopPropagation();
									event.preventDefault();
								});

								var handleClickEvent = function(target){
									var expression = $(target).data('action');
									var data = angular.element(target).scope().data;
									var rowIndexVal = $(target).data('rowindex');
									var colIndexVal = $(target).data('colindex');
									var params = {row:data,cellData:$(target).data('celldata'),rowIndex:rowIndexVal,colIndex:colIndexVal}
									if (expression && typeof expression === "string" &&
											expression.substring(0, 1) !== "=" && expression.substring(0, 2) !== ":=") {
										expression = "="+expression;
									}
									rpt.evalExpression($.extend({}, {expression: expression}, params));
								}

								$('body').off('click', selector+' .column-action-component');
								$('body').off('click', selector+' .customIcon.column-action-component > *');

								$('body').on('click', selector+' .column-action-component', function (event) {
									handleClickEvent(event.target);
									event.stopPropagation();
									event.preventDefault();
								});

								$('body').on('click', selector+' .customIcon.column-action-component > *', function (event) {
									handleClickEvent(event.target.parentElement);
									event.stopPropagation();
									event.preventDefault();
								});

							} ]);

})();