<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="aceEditorModal">
		<div class="modal-header">
            <div class="col-lg-8"> 
                <h3 class="modal-title pull-left" id="modal-title" data-ng-bind="title"></h3>
                <span data-ng-if="helpText" data-placement="bottom" class="tooltipElm glyphicon glyphicon-info-sign customExpInfo" title='{{helpText}}'></span>
            </div>
            <div class="col-lg-4 noRightPadding">
                <span class="ico ico-cross2 pull-right modalCloseIcon" data-ng-click="cancel()"></span>
                <h3 data-ng-if="treeParent" class="modal-title ng-binding "><fmt:message key="CustomReport.InputVariables"/></h3>                
            </div>            
        </div>
        <div class="modal-body" id="modal-body">
            <div data-ng-class="{'border-right col-xs-8':treeParent,'col-xs-12' : !treeParent}" class="modeDropDwn" data-ng-if="editorModes && editorModes.length > 0">
                <div class="dropdown pull-right">
                    <button class="btn btn-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"><fmt:message key='CustomReport.Mode'/> <span class="caret"></span></button>
                    <ul class="dropdown-menu">
                      <li data-ng-class="{'active' : mode === editorOptions.mode}" data-ng-click="changeEditorMode(mode)" data-ng-repeat="mode in editorModes"><a href="javascript:void(0);">{{mode}}</a></li>                
                    </ul>
                </div>
            </div>
          	<div ui-ace="editorOptions" data-ng-model="editorContent" data-ng-class="{'border-right col-xs-8':treeParent,'col-xs-12' : !treeParent}" class="aceEditorStyle noLftRghtPadding " data-ng-style="editorModes && editorModes.length > 0 ? {'height': '95.5%'} : ''"></div>
            <div data-ng-if="treeParent" class="col-xs-4 noLftRghtPadding" data-ng-class="{'columnListMargin' : editorModes && editorModes.length > 0}">
                <cvtree tree-root="treeParent" selected-items="selectedItems" isloadchildren="false" on-item-selection="onItemSelection(selectedItem)"></cvtree>
            </div>
        </div>
        <div class="modal-footer">            
            <button class="btn btn-default" type="button" ng-click="cancel()"><fmt:message key='CustomReport.Cancel'/></button>
            <button class="btn btn-primary" type="button" ng-click="ok()"><fmt:message key='CustomReport.Save'/></button>
        </div>
	</div>
</fmt:bundle>