<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.ReportsPlusMessages">

<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
      var localMsg = localMsg || {};
      localMsg.customReport = localMsg.customReport || {};

      localMsg.customReport.customIcon = localMsg.customReport.customIcon || {};
      localMsg.customReport.customIcon.none = '<fmt:message key="CustomIcon.label.none" />';
      localMsg.customReport.customIcon.custom = '<fmt:message key="CustomIcon.label.custom"/>';
      localMsg.customReport.customIcon.enterValidSVG = '<fmt:message key="CustomIcon.error.enterValidSVG"/>';
      localMsg.customReport.customIcon.enterSingleSVG = '<fmt:message key="CustomIcon.error.enterSingleSVG"/>';
</script>

<div class="row full-height" data-ng-controller="leftPanelCtrl">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 panel-one primary-background-color">
        <div class="later">
            <div title="Report" data-ng-click="toggleLeftPanel('report')" data-ng-class="{'lft-active-panel-tab': displayProperties.selectedPanel==='report'}" class="left-tabs-bg" style="top:-2px;"><fmt:message key='CustomReport.Report'/></div>
            <div title="DataSet" data-ng-click="clearSelection();selectedNode.type = 'dataset';toggleLeftPanel('dataset')" data-ng-class="{'lft-active-panel-tab': displayProperties.selectedPanel==='dataset'}" class="left-tabs-bg"><fmt:message key='CustomReport.Dataset'/></div>
            <div title="Input" data-ng-click="clearSelection();selectedNode.type = 'input';toggleLeftPanel('input')" data-ng-class="{'lft-active-panel-tab': displayProperties.selectedPanel==='input'}" class="left-tabs-bg"><fmt:message key='CustomReport.Inputs'/></div>
        </div>
    </div>
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 panel-two primary-background-color">
        <div data-ng-show="displayProperties.selectedPanel==='report'" style="margin-right:2px;">
            <div class="m-header primary-background-color"><fmt:message key='CustomReport.Report'/>
                <span class="ico ico-chevron-left left-toggle-icon" data-ng-click="toggleLeftPanel()" title="<fmt:message key='CustomReport.CollapsePanel'/>"></span>
            </div>
            <form action="">
                  <div class="col-xs-12 report-label">
                    <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key='Report_Name'/>'><fmt:message key='Report_Name'/></label>
                        <div class="col-sm-8 noLftRghtPadding">
                             <input type="text" class="form-control" placeholder="<fmt:message key='CustomReport.Untitled'/>" data-ng-model="customReport.report.customReportName" title='<fmt:message key="CustomReport.Properties.ReportName"/>'>
                        </div>
                    </div>
                </div>
                  <div class="col-xs-12 report-id">
                    <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title="<fmt:message key='CustomReport.Properties.ID'/>"><fmt:message key='CustomReport.Properties.ID'/></label>
                        <div class="col-sm-8 noLftRghtPadding">
                            <input type="text" class="form-control" placeholder="{{customReport.report.customReportName}}" data-ng-model="customReport.userReportId">
                        </div>
                    </div>
                </div>
                  <div class="col-xs-12">
                    <div class="form-group">
                        <label for="" class="co-sm-12 control-label noLftRghtPadding"><fmt:message key="CustomReport.Properties.Description"/></label>
                        <div class="col-sm-12 margin-bottom-10 noLftRghtPadding">
                            <textarea rows="3" placeholder="<fmt:message key='CustomReport.DescriptionNote'/>" data-ng-model="customReport.reportDescription" title='<fmt:message key="CustomReport.Properties.Description"/>'></textarea>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12" data-ng-show="customReport.pages.length > 1" title='<fmt:message key="CustomReport.ShowPagesAsTabsHelp"/>'>
                    <div class="form-group">
                         <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"><fmt:message key="CustomReport.ShowPagesAsTabs"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="customReport.showPagesAsTabs" id="pagesAsTabs">
                </div>
                    </div>
                </div>
                <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['storeProperties']=!collapsed['storeProperties']" data-ng-init="collapsed['storeProperties']=true">
                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['storeProperties'], 'ico-chevron-right':collapsed['storeProperties']}"></span>
                       <span><span class="groupName" title='<fmt:message key="CustomReport.Properties.StoreSettings"/>'><fmt:message key="CustomReport.Properties.StoreSettings"/></span>
                   </div>
                </div>
               <div class="row noLftRghtMargin" data-ng-class="{'collapsed':collapsed['storeProperties']}">
                <div class="col-xs-12">
                      <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="CustomReport.Properties.ReleaseVersion"/></label>
                            <div class="col-sm-8 noLftRghtPadding">
                                <select class="form-control input-sm"  data-ng-model="customReport.minCommCellVersion.releaseID" data-ng-options="robj.value as robj.label for robj in minReleaseIDs">
                                </select>
                            </div>
                      </div>
                </div>
                <div class="col-xs-12">
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="CustomReport.Properties.ServicePack"/></label>
                            <div class="col-sm-8 noLftRghtPadding">
                                <select class="form-control input-sm"  data-ng-model="customReport.minCommCellVersion.servicePack" data-ng-options="robj.value as robj.label for robj in minSPValues">
                               </select>
                            </div>
                        </div>
                 </div>
                 <div class="col-xs-12">
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-12 control-label noLftRghtPadding"><fmt:message key="CustomReport.Properties.WhatsNew"/></label>
                            <div class="col-sm-12 noLftRghtPadding">
                                <textarea data-ng-model="propData.whatsNew" placeholder='<fmt:message key="CustomReport.Properties.WhatsNew.Placeholder"/>' rows="5" cols="30"></textarea>
                            </div>
                        </div>
                  </div>
                </div>
                <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['locale']=!collapsed['locale']" data-ng-init="collapsed['locale']=true">
                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['locale'], 'ico-chevron-right':collapsed['locale']}"></span>
                       <span><span class="groupName"><fmt:message key="CustomReport.Localization"/></span>
                   </div>
                </div>
                <div data-ng-class="{'collapsed': collapsed['locale']}">
                    <div class="row noLftRghtMargin newLink" data-ng-show="customReport.translations === undefined || customReport.translations.length === 0">
                        <a  data-ng-click="showLocaleModal()"><fmt:message key="CustomReport.CreateLocalizableString"/></a>
                    </div>
                    <div class="row noLftRghtMargin newLink" data-ng-show="customReport.translations !== undefined && customReport.translations.length > 0">
                        <a data-ng-click="showLocaleModal()"><fmt:message key="CustomReport.ViewEditLocalizableString"/></a>
                    </div>
                </div>
                <!-- Add Tag UI -->

					<div class="sectionWrapper" data-ng-show="!isTileBuilder">
		               	<div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['uiTags']=!collapsed['uiTags']" data-ng-init="collapsed['uiTags']=true">
		                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
		                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['uiTags'], 'ico-chevron-right':collapsed['uiTags']}"></span>
		                       <span class="groupName" title="<fmt:message key="CustomReport.UITags"/>"><fmt:message key="CustomReport.UITags"/></span>
		                       <span class="pull-right ico ico-plus-circle" data-ng-click="collapsed['uiTags']=false; addCustomuiTags($event)"></span>
		                   </div>
		                </div>

		               <div  data-ng-class="{'collapsed': collapsed['uiTags']}" class="row noLftRghtMargin" data-ng-repeat="uiTag in customReport.uiTags track by $index">
			               <div class="form-group">
				                <div class="col-sm-9" style="padding-right:0px">
				                   <div class="tagsDiv">
				                    <span><input class="tagsTextField" type="text" data-ng-model="customReport.uiTags[$index]">
					                    <select class="form-control input-sm tagsSelect" data-ng-model="customReport.uiTags[$index]">
			 								<option  data-ng-repeat="tag in tags track by $index">{{tags[$index]}}</option>
					                    </select>
				                    </span>
				                    </div>
				                </div>

				                <span class="pull-right deleteButton ico ico-trash2 pro-dlt-btn " data-ng-click="deleteElement(customReport.uiTags, $index);"></span>
			             </div>
			           </div>

			           <!-- Add System Tag UI -->
		               	<div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['SystemTags']=!collapsed['SystemTags']" data-ng-init="collapsed['SystemTags']=true;">
		                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
		                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['SystemTags'], 'ico-chevron-right':collapsed['SystemTags']}"></span>
		                       <span class="groupName" title="<fmt:message key="CustomReport.SystemTags"/>"><fmt:message key="CustomReport.SystemTags"/></span>
		                       <span class="pull-right ico ico-plus-circle"  data-ng-show="customReport.systemTags.length!==systemPrevTags.length"   data-ng-click="collapsed['SystemTags']=false;addSystemTags($event)"></span>
		                   </div>
		                </div>

		                <div  data-ng-class="{'collapsed': collapsed['SystemTags']}" class="row noLftRghtMargin" data-ng-repeat="systemTag in customReport.systemTags track by $index">
			               <div class="form-group">
				                <div class="col-sm-9" style="padding-right:0px">
				                   <div class="tagsDiv">
				                    <span>
				                        <input class="tagsTextField" type="text" data-ng-model="customReport.systemTags[$index]" disabled>
				                   	 	<select class="form-control input-sm tagsSelect"  data-ng-model="customReport.systemTags[$index]">
				                          <option  data-ng-repeat="tag in systemPrevTags track by $index">{{systemPrevTags[$index]}}</option>
				                        </select>
				                    </span>
				                    </div>
				                </div>
				                <span class="pull-right deleteButton ico ico-trash2 pro-dlt-btn " data-ng-click="deleteElement(customReport.systemTags, $index);"></span>
			             </div>
			           </div>
			           </div>

			           <div class="sectionWrapper" >
			           <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['Advanced']=!collapsed['Advanced']" data-ng-init="collapsed['Advanced']=true;">
		                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
		                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['Advanced'], 'ico-chevron-right':collapsed['Advanced']}"></span>
		                       <span class="groupName" title="<fmt:message key="CustomReport.AdvancedSettings"/>"><fmt:message key="CustomReport.AdvancedSettings"/></span>
		                   </div>
		               </div>

		               <div data-ng-class="{'collapsed': collapsed['Advanced']}" class="row noLftRghtMargin">
		               	<div class="row noLftRghtMargin">
					       <div class="col-xs-12" >
					            <div class="form-group">
				                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Hidden"/>'><fmt:message key="CustomReport.Hidden"/></label>
				                    <div class="col-sm-3 noLftRghtPadding">
				                          <input type="checkbox" cv-toggle-switch data-ng-model="customReport.hidden" id="hideReport">
				                    </div>
					              </div>
					        </div>
				   	 	</div>
				   	 	<div class="row noLftRghtMargin">
					       <div class="col-xs-12" >
					            <div class="form-group">
				                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.VisibileToAll"/>'><fmt:message key="CustomReport.VisibileToAll"/></label>
				                    <div class="col-sm-3 noLftRghtPadding">
				                          <input type="checkbox" cv-toggle-switch data-ng-model="customReport.visibleAll" id="visibleAll">
				                    </div>
					              </div>
					        </div>
				   	 	</div>
				   	 	<div class="row noLftRghtMargin">
					       <div class="col-xs-12" >
					            <div class="form-group">
				                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.VisibileToTenantAdmins"/>'><fmt:message key="CustomReport.VisibileToTenantAdmins"/></label>
				                    <div class="col-sm-3 noLftRghtPadding">
				                          <input type="checkbox" cv-toggle-switch data-ng-model="customReport.visibleToTenantAdmins" id="visibleToTenantAdmins">
				                    </div>
					              </div>
					        </div>
				   	 	</div>
				   	 	<div class="row noLftRghtMargin">
					       <div class="col-xs-12" >
					            <div class="form-group">
				                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.ReadOnly"/>'><fmt:message key="CustomReport.ReadOnly"/></label>
				                    <div class="col-sm-3 noLftRghtPadding">
				                          <input type="checkbox" cv-toggle-switch data-ng-model="customReport.readOnly" id="readOnlyReport">
				                    </div>
					              </div>
					        </div>
                        </div>
                        <div class="row noLftRghtMargin">
                            <div class="col-xs-12" >
                                <div class="form-group">
                                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.MetricsReport"/>'><fmt:message key="CustomReport.MetricsReport"/></label>
                                    <div class="col-sm-3 noLftRghtPadding">
                                        <input type="checkbox" cv-toggle-switch data-ng-model="customReport.isMetrics" id="isMetricsReport">
                                    </div>
                                </div>
                            </div>
                        </div>
				   	 	<div class="row noLftRghtMargin formatter-option">
					       <div class="col-xs-12" >
					            <div class="form-group">
				                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomIcon.CustomIcon"/>'><fmt:message key="CustomIcon.CustomIcon"/></label>
				                    <div class="col-sm-3 noLftRghtPadding">
				                         <span class="pull-right">
				                            <span class="label label-info cursor-pointer" data-ng-click="showEditIconDialog()"> {{ getCustomIconLinkText() }} </span>
				                        </span>
				                    </div>
					              </div>
					        </div>
				   	 	</div>
		               </div>

			        </div>

					<div class="sectionWrapper" data-ng-show="isTileBuilder">
						 <!-- Add Tile Properties -->
		               	<div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['TileSettings']=!collapsed['TileSettings']" data-ng-init="collapsed['TileSettings']=true;">
		                   <div class="col-xs-12 noLftRghtPadding text-ellipsis">
		                       <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['TileSettings'], 'ico-chevron-right':collapsed['TileSettings']}"></span>
		                       <span class="groupName" title='<fmt:message key="Tile_Settings"/>'><fmt:message key="Tile_Settings"/></span>
		                   </div>
		                </div>

		                <div class="row noLftRghtMargin" data-ng-class="{'collapsed':collapsed['TileSettings']}">
			                <div class="col-xs-12">
			                      <div class="form-group">
			                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Category"/></label>
			                            <div class="col-sm-8 noLftRghtPadding">
			                                <select class="form-control input-sm"  data-ng-model="tileProperties.category" data-ng-options="category.name for category in tileCategories track by category.id">
			                                </select>
			                            </div>
			                      </div>
			                </div>
			                <div class="col-xs-12">
			                        <div class="form-group">
			                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Height"/></label>
			                            <div class="col-sm-8 noLftRghtPadding">
			                            	<select class="form-control input-sm" data-ng-model="tileProperties.height">
			                            		<option value="FULL"><fmt:message key="Tile_Full"/> </option>
			                            		<option value="HALF"><fmt:message key="Tile_Half"/> </option>
			                            	</select>
			                            </div>
			                        </div>
			                 </div>
			                 <div class="col-xs-12">
			                        <div class="form-group">
			                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Status_Dataset"/></label>
			                            <div class="col-sm-8 noLftRghtPadding">
			                            	<select class="form-control input-sm" data-ng-model="tileDSProps.tileStatusDataSet"
			                            	 data-ng-options="dataSet.dataSet.dataSetName for dataSet in dataSets track by dataSet.dataSet.dataSetGuid">
			                            	</select>
			                            </div>
			                        </div>
			                 </div>
			                  <div class="col-xs-12">
			                        <div class="form-group">
			                            <label class="col-xs-12 col-sm-12 col-md-12 control-label noLftRghtPadding"><fmt:message key="Tile_Detail"/></label>
			                            <div class="col-xs-12">
	      									<div class="form-group">
				                            	<div >
				                            		<label class="col-sm-12 noLftRghtPadding">
			                            			<input   type="radio" class="ng-pristine ng-valid ng-empty ng-touched detailTypeBtns" data-ng-model="tileProperties.detailType" value="1">
			                            			<fmt:message key="Tile_Custom_Report"/>
			                            			</label>
			                            			<label class="col-sm-12 noLftRghtPadding">
			                            			<input   type="radio" class="ng-pristine ng-valid ng-empty ng-touched detailTypeBtns" data-ng-model="tileProperties.detailType" value="2">
			                            			<fmt:message key="Tile_Relative_URL"/>
			                            			</label>
			                            		</div>
				                        	</div>
	  									</div>

	  									<div class="col-xs-12">
	      									<div class="form-group">
				                            	<div class="col-sm-12 noLftRghtPadding">
			                            			<input type="text" class="form-control ng-pristine ng-valid ng-empty ng-touched" placeholder='<fmt:message key="Tile_Detail_Placeholder"/>' data-ng-model="tileProperties.detailReportName">
			                            		</div>
			                            		<div class="col-sm-12 noLftRghtPadding">
			                            			<label id="detailNote">Example: /reports/sla.jsp</label>
			                            		</div>
				                        	</div>
	  									</div>



			                        </div>
			                 </div>
			                  <div class="col-xs-12">
			                        <div class="form-group">
			                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Threshold"/></label>
			                             <div class="col-xs-12">
	      									<div class="form-group">
				                           		<label class="col-xs-11 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Good"/></label>
				                            	<div class="col-sm-8 noLftRghtPadding">
			                            			<input type="text" class="form-control ng-pristine ng-valid ng-empty ng-touched" placeholder="<fmt:message key='Tile_Not_Applicable'/>" data-ng-model="tileProperties.thGood">
			                            		</div>
				                        	</div>
	  									</div>
	  									<div class="col-xs-12">
	      									<div class="form-group">
				                           		<label class="col-xs-11 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Warning"/></label>
				                            	<div class="col-sm-8 noLftRghtPadding">
			                            			<input type="text" class="form-control ng-pristine ng-valid ng-empty ng-touched" placeholder="<fmt:message key='Tile_Not_Applicable'/>" data-ng-model="tileProperties.thWarning">
			                            		</div>
				                        	</div>
	  									</div>
	  									<div class="col-xs-12">
	      									<div class="form-group">
				                           		<label class="col-xs-11 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message key="Tile_Critical"/></label>
				                            	<div class="col-sm-8 noLftRghtPadding">
			                            			<input type="text" class="form-control ng-pristine ng-valid ng-empty ng-touched" placeholder="<fmt:message key='Tile_Not_Applicable'/>" data-ng-model="tileProperties.thCritical">
			                            		</div>
				                        	</div>
	  									</div>
					     			</div>
               				 	</div>
               			</div>
				</div>
            </form>
        </div>
        <div data-ng-show="displayProperties.selectedPanel==='dataset'">
            <div class="m-header primary-background-color">
                <span style = "margin-right: 5px;"><fmt:message key="CustomReport.DataSets"/></span>
                <span class="ico ico-chevron-left left-toggle-icon" data-ng-click="toggleLeftPanel()" title="<fmt:message key='CustomReport.CollapsePanel'/>"></span>
                <span class="ico-plus-circle alignLeft left-toggle-icon" title='<fmt:message key="CustomReport.Add"/>' data-ng-click="showAddDataSetModal()" style="font-size: 15px; font-family: "Open Sans", "Segoe UI";><fmt:message key='CustomReport.Add'/></span>
            </div>
            <div class="panel-two-scroll">
                <div class="row dataset-list" data-ng-show="dataSets != undefined && dataSets.length >0">
                    <div class="col-xs-12">
                        <ul>
                            <li data-ng-repeat="dataSet in dataSets"
                                class="secondary-header secondary-background-color"
                                data-ng-class="{selected:dataSet==selectedNode.node}"
                                data-ng-click="selectDataSet(dataSet,$index)"
                                data-id="dataSet{{$index + 1}}"
                                data-datasetguid="{{dataSet.guid}}"
                                data-datasetname="{{dataSet.dataSet.dataSetName}}"
                                >

                                <div class="labelWrapper parentNode secondary-background-color row noLftRghtMargin" x-lvl-draggable="true"
                                           data-name="allColumns"
                                           data-componentType="COLUMN"
                                           data-dataSetName="{{dataSet.dataSet.dataSetName}}"
                                           data-datasetentity="{{dataSet.dataSet}}"
                                           data-dataField="allColumns">
                                    <div class="col-lg-9 noLftRghtPadding dataset-title">
                                    <span class="ico" data-ng-class="{'ico-chevron-down':!dataSet.hidden, 'ico-chevron-right':dataSet.hidden}" data-ng-click="toggleCollapse(dataSet)" style="font-size: 13px;"></span>
                                     <span title="{{dataSet.dataSet.dataSetName}}">{{dataSet.dataSet.dataSetName}}</span>
                                     </div>
                                     <div class="col-lg-3 noLftRghtPadding txtalgnrht">
                                     <span>
                                        <span class="ico-pencil ico-size" title='<fmt:message key="CustomReport.Edit"/>' data-ng-click="selectedNode.node=dataSet;showEditModal()"></span>
                                        <span class="ico-trash2 ico-size" title='<fmt:message key="CustomReport.Delete"/>' data-ng-click="selectedNode.node=dataSet;deleteNode()"></span>
                                     </span>
                                     </div>
                                    </div>
                                    <div data-ng-hide="dataSet.hidden" class="form-group has-feedback" style="margin-bottom:0px;margin-top:5px;">
                                        <input type="text" placeholder="Search..." class="form-control" ng-model="searchFields"/>
                                        <span class="ico-magnifier form-control-feedback"></span>
                                    </div>
                                <ul data-ng-hide="dataSet.hidden" class="data-fields">
                                    <li data-ng-show="dataSet.allColumns == true"
                                        class="labelWrapper childNode left-panel-color"
                                        data-dataField="allColumns"
                                        data-name="allColumns"
                                        data-type=""
                                        data-componentType="COLUMN"
                                        data-dataSetName="{{dataSet.dataSet.dataSetName}}"
                                        x-lvl-draggable="true"
                                        data-datasetentity="{{dataSet.dataSet}}"
                                        data-datasetguid="{{dataSet.guid}}">
                                        <span class="field"><fmt:message key="CustomReport.AllFields"/></span>
                                    </li>
                                    <li data-ng-repeat="field in dataSet.fields | orderBy:'name'| filter: searchFields"
                                        data-ng-show="!dataSet.allColumns && field.name.indexOf('!') != 0"
                                        class="labelWrapper childNode left-panel-color"
                                        data-ng-class="field.type"
                                        data-dataField="{{field.dataField}}"
                                        data-type="{{field.type}}"
                                        data-origType="{{field.origType ? field.origType : field.type}}"
                                        data-name="{{field.name}}"
                                        data-componentType="COLUMN"
                                        data-dataSetName="{{dataSet.dataSet.dataSetName}}"
                                        data-index="{{$index + 1}}"
                                        x-lvl-draggable="true"
                                        data-datasetentity="{{dataSet.dataSet}}"
                                        data-datasetguid="{{dataSet.guid}}">
                                        <span class="sprite datatype-icons left-panel-color" data-ng-class="dataTypesIcons[field.type.toLowerCase()]"></span>
                                        <span class="field" title="{{field.name}}">{{field.name}}</span>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div data-ng-show="displayProperties.selectedPanel==='input'" class="panel-two-scroll">
            <div class="m-header primary-background-color">
                <div class="pull-left">
                    <fmt:message key="CustomReport.Inputs"/>
                </div>
                <div class="pull-right">
                    <span class="glyphicon glyphicon-arrow-down input-arrow-buttons" data-ng-show="inputs != undefined && inputs.length > 1" data-ng-class="{'actionDisabled': selectedInputIndex === inputs.length-1 || !selectedNode.node}" data-ng-click="moveInput('DOWN')" title="Move Down"></span>
                    <span class="glyphicon glyphicon-arrow-up input-arrow-buttons" data-ng-show="inputs != undefined && inputs.length > 1"  data-ng-class="{'actionDisabled': selectedInputIndex === 0 || !selectedNode.node}" data-ng-click="moveInput('UP')" title="Move Down"></span>
                    <span class="ico ico-chevron-left left-toggle-icon" data-ng-click="toggleLeftPanel()" title="<fmt:message key='CustomReport.CollapsePanel'/>"></span>
                    <span class="ico-plus-circle left-toggle-icon" title='<fmt:message key="CustomReport.CreateInput"/>' data-ng-click="showInputModal()"><fmt:message key='CustomReport.Add'/></span>
                </div>
            </div>
            <div class="row data-fields noLftRghtMargin" data-ng-show="inputs != undefined && inputs.length >0">
                <div class="col-xs-12">
                    <ul>
                        <li data-ng-repeat="input in inputs"
                            data-ng-class="{'selected-input':input==selectedNode.node}"
                            data-ng-click="selectInput(input,$index)" class="left-panel-color treeNode childNode cursor-pointer">

                            <div class="labelWrapper">
                                 <span class="col-lg-10 noLftRghtPadding input-title" title="{{input.displayName}}({{input.id}})">{{input.displayName}}({{input.id}})</span>
                                 <span class="pull-right col-lg-2 noLftRghtPadding">
                                    <span class="ico-pencil ico-size" title='<fmt:message key="CustomReport.Edit"/>' data-ng-click="selectedNode.node=input;showEditModal()"></span>
                                    <span class="ico-trash2 ico-size" title='<fmt:message key="CustomReport.Delete"/>' data-ng-click="selectedNode.node=input;deleteNode()"></span>
                                 </span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="left-splitter ui-resizable-handle ui-resizable-e"></div>
    </div>
</div>
</fmt:bundle>


<!-- End data set tree -->