(function(){
	'use strict';

	angular
		.module('reports')
		.factory('dataSource', dataSource);

	dataSource.$inject = ['dataCubeService', 'otherDataService'];

	function dataSource(dataCubeService, otherDataService) {
		return {
			getDataSource: getDataSource
		};
		/*
		This method will be called by the component's controllers based on the data set type (endpoint)
		This has to be called in getData() because component doesn't know the endpoint during the initialization.
		*/

		function getDataSource(endpoint) {
			if (endpoint === 'DATACUBE') {
				return dataCubeService;
			}
			else {
			 	return otherDataService;
			}
		}
	}

})();