var reports = angular.module("reports");
reports.directive("cvchart", function(){
    function chartLink(scope,element,attrs){
    	scope.getChartTemplate = function() {
    		  return customReports.contextPath + '/reportsplus/templates/reportComponents/charts/chart.jsp';
       };
    	
    	
    }return{
        link:chartLink,
        restrict:'E',        
        template: '<div ng-include="getChartTemplate()" class="full-height"></div>'
    };
});

reports.directive("tileStatusChart", function() {
	function chartLink(scope, element, attrs) {
		scope.getChartTemplate = function() {
			return customReports.contextPath + '/reportsplus/templates/reportComponents/charts/tileStatusChart.jsp';
		};

	}
	return {
		link : chartLink,
		restrict : 'E',
		template : '<div ng-include="getChartTemplate()" class="full-height"></div>'
	};
});

reports.directive('dropdownMultiselectArrayStrings', function(){
	   return {
	       restrict: 'E',
	       scope:{           
	            model: '=',
	            options: '=',
	            pre_selected: '=preSelected'
	       },
	       template: "<div class='btn-group' data-ng-class='{open: open}'>"+
	        "<button class='btn btn-small'>Select</button>"+
	                "<button class='btn btn-small dropdown-toggle' data-ng-click='open=!open;openDropdown()'><span class='caret'></span></button>"+
	                "<ul class='dropdown-menu' aria-labelledby='dropdownMenu'>" + 
	                    "<li><a data-ng-click='selectAll()'><i class='icon-ok-sign'></i>  Check All</a></li>" +
	                    "<li><a data-ng-click='deselectAll();'><i class='icon-remove-sign'></i>  Uncheck All</a></li>" +                    
	                    "<li class='divider'></li>" +
	                    "<li data-ng-repeat='option in options'> <a data-ng-click='setSelectedItem()'>{{option}}<span data-ng-class='isChecked(option)'></span></a></li>" +                                        
	                "</ul>" +
	            "</div>" ,
	       controller: function($scope){
	           
	           $scope.openDropdown = function(){        
	                    $scope.selected_items = [];
	                    for(var i=0; i<$scope.pre_selected.length; i++){                        $scope.selected_items.push($scope.pre_selected[i].id);
	                    }                                        
	            };
	           
	            $scope.selectAll = function () {
	                $scope.model = _.clone($scope.options, 'id');
	                for(var i=0; i<$scope.options.length; i++){ 
	                	$scope.model.push($scope.options[i]);
                    }
	                console.log($scope.model);
	            };            
	            $scope.deselectAll = function() {
	                $scope.model=[];
	                console.log($scope.model);
	            };
	            $scope.setSelectedItem = function(){
	                var id = this.option;
	                if (_.indexOf($scope.model, id) > -1) {
	                    $scope.model = _.without($scope.model, id);
	                } else {
	                    $scope.model.push(id);
	                }
	                console.log($scope.model);
	                return false;
	            };
	            $scope.isChecked = function (id) {                 
	                if (_.indexOf($scope.model, id) > -1) {
	                    return 'icon-ok pull-right';
	                }
	                return false;
	            };                                 
	       }
	   }
});


