(function() {
	'use strict';

	var reports = angular.module("reports");
	var COLORS = {
			GOOD : "#00b300",
			WARNING : "#ff9900",
			CRITICAL : "#cc3300",
			UNKNOWN : "#a6a6a6"
		}
	var STATUS = {
			CRITICAL: 4, 
			WARNING: 3,
			GOOD : 2,
			INFO: 1, 
	}
	
	var CHARTABLE_STATUS = [2,3,4];
	
	

	reports.controller("tileStatusChartCtrl", [
			"$scope",
			"customReportSvc",
			"$timeout",
			function($scope, customReportSvc, $timeout) {
				$scope.init = function() {
					$scope.componentLoaded = false;
					$scope.component.tileData = $scope.component.tileData || {};
					$scope.chartData = [];
					$scope.chartData = [];
					$scope.masked = false;
					$scope.componentLoaded = true;
					$scope.nameColumnIndex =0, $scope.idColumnIndex =0, $scope.valueColumnIndex=0;
					
					$scope.getChartData();
				}

				$scope.dropped = function(dragEl, dropEl) {
					var dest = document.getElementById(dropEl);
					var src = document.getElementById(dragEl);

					var drag = angular.element(src);
					var drop = angular.element(dest);
					var columnName = drag.attr("data-name");
					var dropType = drop.data("droptype");
					
					if (columnName == "allColumns") {
						customReportSvc.errorToast('All Fields cannot be used to draw a chart.');
						return;
					}
					
					var dataSetEntity = drag.data("datasetentity");
					var dataSetName = drag.parent().parent().data("datasetname");
					
					if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
						$scope.associateDataSetToComponent(dataSetEntity);
					} else if ($scope.component.dataSet.dataSetName != dataSetName) {
						alert("Mismatched data Sets");
						return;
					}
					
					if (columnName === $scope.component.tileData.nameColumn || columnName === $scope.component.tileData.valueColumn || columnName === $scope.component.tileData.idColumn) {
						return;
					}
					if (dropType === "nameColumn") {
						var guid = drag.data("datasetguid");
						if (!guid) {
							guid = dataSetEntity.dataSetGuid;
						}
						$scope.component.tileData.nameColumn = columnName;
						$scope.tileProperties.outcomeDataset = guid;
						$scope.tileProperties.outcomeColumn = columnName;
					}
					
					if (dropType === "idColumn") {
						$scope.component.tileData.idColumn = columnName;
					}
					
					if (dropType === "valueColumn") {
						$scope.component.tileData.valueColumn = columnName;
					}
					
					$scope.$apply();
				}
					
				$scope.isShowNoChartDiv = function() {
					return (!$scope.masked && $scope.componentLoaded && $scope.chartData.length ==0);
				}
				
				$scope.deleteColumn = function(columnName) {
					$scope.chartData = [];
					$scope.otherData = [];
					$scope.component.tileData[columnName] = undefined;
				}
				

				$scope.$watch('component.tileData.nameColumn', function() {
					if (!$scope.componentLoaded || $scope.processing) {
						return;
					}
					$scope.getChartData();

				}, true);

				$scope.$watch('component.tileData.idColumn', function() {
					if (!$scope.componentLoaded || $scope.processing) {
						return;
					}
					$scope.getChartData();

				}, true);

				
				$scope.$watch('component.tileData.valueColumn', function() {
					if (!$scope.componentLoaded || $scope.processing) {
						return;
					}
					$scope.getChartData();
					
				}, true);

				
				$scope.getChartData = function() {
					var isValid = false;
					
					if ($scope.component.tileData.nameColumn && $scope.component.tileData.idColumn && $scope.component.tileData.valueColumn) {
						isValid = true;
					}
					
					if (isValid) {
						$scope.chartData = [];
						$scope.otherData = [];
						$scope.processing = true;
						$scope.componentLoaded = false;
						$scope.component.isComponentLoading = true;
//						$scope.loadingButton();
						$scope.getData().then(function(data) {
							onSuccessGetChartDataForDataSet(data);
						});
					}
					
					$timeout(function() {
						$scope.processing = false;
						$scope.componentLoaded = true;
					});
					
				}
				
				var onSuccessGetChartDataForDataSet = function(result) {
					var response = result.data || result;
					
					angular.forEach(response.columns, function(columnData, index) {
							if ($scope.component.tileData.nameColumn === columnData.name) {
								$scope.nameColumnIndex = index;
							}
							if ($scope.component.tileData.idColumn === columnData.name) {
								$scope.idColumnIndex = index;
							}
							if ($scope.component.tileData.valueColumn === columnData.name) {
								$scope.valueColumnIndex = index;
							}
					});

					angular.forEach(response.records, function(rowData, index) {
						var obj =  {name: rowData[$scope.nameColumnIndex], 
								    value: rowData[$scope.valueColumnIndex],
								    id: rowData[$scope.idColumnIndex]
									};
						
						if (CHARTABLE_STATUS.indexOf(rowData[$scope.idColumnIndex]) != -1) {
							$scope.chartData.push(obj);
						} else {
							$scope.otherData.push(obj);
						}
					});
					
					$scope.component.isComponentLoading = false;
				}
				
				$scope.init();
				

			} ]);
	
	reports.controller("tileSolidDonutController", ["$scope", function($scope) {
			
			$scope.chartConfig = getChartConfig();
//			$scope.statusDisplayName = getStatusDisplayName($scope.cData.statusId);
		
//			
//			function getStatusDisplayName(status) {
//				if (status == STATUS.CRITICAL) {
//					return localMsg.criticalStatus;
//				} else if (status == STATUS.WARNING) {
//					return localMsg.warningStatus;
//				} else if (status == STATUS.GOOD) {
//					return localMsg.goodStatus;
//				} else {
//					return localMsg.unknownStatus;
//				}
//			}
			function getChartConfig() {
				var chartConfig = {
					size : {
						width : 110,
						height : 110
					},
					options : {
						chart : {
							type : "pie",
							zoomType : 'x',
							animation : false,
							interactiveEnabled : false,
							marginTop : 0,
							spacingTop : 0,
							spacingBottom : 0,
							spacingLeft : 0,
							spacingRight : 0
						},
						exporting : {
							enabled : false
						},
						legend : {
							enabled : false,
						},
						credits : {
							enabled : false
						},
						tooltip : {
							enabled : false,
							animation : false
						},
						plotOptions : {
							series : {
								animation : false,
							},
							pie : {
								size : "100%",
								borderWidth : 0,
								dataLabels : {
									enabled : false,
									format : undefined
								},
							}
						}
					},
					title : {
						text : "" + $scope.cData.value,
						align : "center",
						verticalAlign : "middle",
						y : 5,
						style : {
							"color" : "#777",
							"font-family" : "Helvetica,Arial,sans-serif",
							"font-size" : "22px",
							"font-weight" : "bold"
						}
	
					},
					series : [ {
						data : [ {
							color : getColor(),
							y : 100,
							name : 100
						} ],
						size : "100%",
						innerSize : 84,
						startAngle : 0,
						endAngle : 360,
						pointPadding : 0,
						stacking : "normal",
	
					} ],
					loading : false,
					noData : true
				}
	
				return chartConfig;
			}

			function getColor() {
				if ($scope.cData.id === STATUS.GOOD) {
					return COLORS.GOOD;
				} else if ($scope.cData.id === STATUS.WARNING) {
					return COLORS.WARNING;
				} else if ($scope.cData.id === STATUS.CRITICAL) {
					return COLORS.CRITICAL;
				} else {
					return COLORS.UNKNOWN;
				}
			}
	                
			
			} ]);
	
}());