// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Create report builder module
	var app = angular.module("reports"); // end module reportBuilder
	window.pendingRequests = 0; // parameter is used inside phantom js to determine whether all angular calls are completed. If not it will wait for it to complete.

	app.run([ "$http", "customReportSvc", function(http, customReportSvc) {
		http.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest"
	} ]);

	app.config([ '$httpProvider', '$sceProvider', '$provide', function($httpProvider, $sceProvider, $provide) {
		$httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';
		//$locationProvider.html5Mode(true);
		$sceProvider.enabled(false);
		// this is a workaround for the issue where we get into infinite digest loops when using history api with angular.js
		$provide.decorator('$location', [ '$delegate', '$browser', function($delegate, $browser) {
			$delegate.absUrl = function() {
				return $browser.url();
			};
			return $delegate;
		} ]);
		// uiSelectConfig.theme = 'bootstrap';
		// Override $http service's default transformRequest
		$httpProvider.defaults.transformRequest = [ function(data) {
			/**
			 * The workhorse; converts an object to x-www-form-urlencoded serialization.
			 * 
			 * @param {Object}
			 *            obj
			 * @return {String}
			 */

			var param = function(obj) {
				var query = '';
				var name, value, fullSubName, subName, subValue, innerObj, i;
				for (name in obj) {
					value = obj[name];
					if (value instanceof Array) {
						for (i = 0; i < value.length; ++i) {
							subValue = value[i];
							fullSubName = name + '[' + i + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value instanceof Object) {
						for (subName in value) {
							subValue = value[subName];
							fullSubName = name + '[' + subName + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value !== undefined && value !== null) {
						query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
					}
				}
				return query.length ? query.substr(0, query.length - 1) : query;
			};
			return angular.isObject(data) && String(data) !== '[object File]' ? param(data) : data;
		} ];

		$httpProvider.interceptors.push([ '$q', 'crUtilSvc', function($q, crUtilSvc) {
			return {
				response : function(response) {
					window.pendingRequests--;
					return response;
				},
				responseError : function(rejection) {
					window.pendingRequests--;
					return $q.reject(rejection);
				},
				request : function(config) {
					window.pendingRequests++;
					var csrfParam = crUtilSvc.readCookie('csrf');
					config.headers['X-CSRF-Token'] = csrfParam;
					config.headers['timeZoneInfo'] = moment().format("Z");
					config.headers['Accept-Language'] = customReports.prefLocale;
					return config;
				},
				requestError : function(rejection) {
					window.pendingRequests--;
					return $q.reject(rejection);
				}
			};
		} ]);
	} ]);
	app.run([ 'gridsterConfig', '$rootScope', function(gridsterConfig, $rootScope) {
		gridsterConfig.resizable.stop = function(event, uiWidget, $element) {
			$rootScope.$broadcast('resize', [ event, uiWidget ]);
		}
		// https://github.com/ManifestWebDesign/angular-gridster/issues/84 (don't know if they fixed it or not)
	} ]);
})();