// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");
	reports.directive("cvRptMultiSelect", function() {
		return {
			restrict : 'AEC',
			templateUrl : customReports.contextPath + '/reportsplus/inputs/multiselect/cvMultiSelect.jsp',
			controller : 'cvMultiSelectCtrl'
		};
	});

	reports.controller('cvMultiSelectCtrl', [
			"$scope",
			"reportService",
			"customReportSvc",
			"$timeout",
			function($scope, reportService, customReportSvc, $timeout) {
				$scope.options = [];
				$scope.allSelected = false;
				$scope.selectionChanged = false;
				$scope.showSearchBar = true;
				$scope.totalRecordCount = 0;
				$scope.filteredRecordCount = 0;
				$scope.fetchedRecordCount = 0;
				$scope.offset = 0;
				$scope.originalOptions = [];
				$scope.setChildScope($scope);
				$scope.disableLoadMoreButton = false;
				$scope.component = {};
				$scope.reintialize = false;
				$scope.selected = {
					options : []
				};
				$scope.viewSelected = false;
				var promise = '';

				$scope.handleSearchText = function(search) {
					$scope.input.searching = true;
					if ($scope.input.fromDataSet == true) {
						if (promise) {
							$timeout.cancel(promise);
						}
						promise = $timeout(function() {
							$scope.component.searchText = '';
							if (search) {
								var labelField = "["+$scope.input.labelField+"]"; //data fields having spaces in it require wrapping in square brackets.
								$scope.component.searchText = dataSetUtility.getNewFilter(search,
										labelField,
										'string',
										true);
							}
							$scope.component.pageOffset = 0;
							$scope.getData($scope.inputDS, $scope.component).then(function(data) {
								$scope.options = data.data.records;
								$scope.input.searching = false;
								if ($scope.allSelected) {
									$scope.handleSelectAll();
								}
							});
						}, 500);

					} else {
						if ($scope.originalOptions.length === 0) {
							angular.copy($scope.options, $scope.originalOptions); // keep a copy of original options
						}
						if (search) {
							$scope.options = _.filter($scope.originalOptions, function(item) {
								return item.label.toLowerCase().indexOf(search.toLowerCase()) > -1;
							});
						} else {
							$scope.options = $scope.originalOptions;
						}
						$scope.input.searching = false;
					}
				}

				$scope.updateLabel = function() {
					var label = "";
					if ($scope.allSelected) {
						label = localMsg.customReport.All;
						if(!$scope.exportType){
							label = $scope.translatedLabel;
						}
					} else if ($scope.selected.options.length > 0) {
						if(!$scope.exportType){
							label = $scope.selected.options[0].label +
									($scope.input.allowMultipleSelection && $scope.selected.options.length > 1 ? ' + ' +
											($scope.selected.options.length - 1) : '');
						}else{
							_.map($scope.selected.options, function(option,i) {
								if(i < 10){
									label = label + option.label + ", ";
								}
							});
							label = label.substring(0,label.lastIndexOf(','));
						}



					} else {
						label = $scope.translatedLabel;
						if($scope.exportType){
							label = localMsg.customReport.All;
						}
					}

					$timeout(function() {
						$scope.inputLabel = label;
					});
				}

				$scope.clearSelection = function(resetOptions) {
					$scope.allSelected = false;
					$scope.valueSelected = false;
					$scope.selected.options = [];
					if(resetOptions){
						$scope.options = [];
						$scope.reintialize = true;
					}
					$scope.updateLabel();
				}

				$scope.handleSelectAll = function(update) {

					$scope.allSelected = !$scope.allSelected;

					if (update) {
						$scope.selectionChanged = true;
						$scope.valueSelected = $scope.input.required && $scope.allSelected ? true : false;
					}

					if ($scope.allSelected) {
						$scope.selected.options = angular.copy($scope.options, []);
						$scope.viewSelected = false;
					} else {
						$scope.selected.options = []
					}

					$scope.updateValue();
				}

				$scope.handleViewSelected = function(event) {
					$scope.viewSelected = !$scope.viewSelected;
					event.stopPropagation();
				}

				$scope.updateValue = function() {
					if ($scope.allSelected && !$scope.input.required && !$scope.component.searchText && $scope.customReport.builderVersion !== 1 && $scope.input.controlType !== "CheckBox") {
						$scope.input.value = 'All';
					} else {
						if ($scope.input.allowMultipleSelection) {
							$scope.input.value = _.map($scope.selected.options, 'value');
						} else {
							$scope.input.value = _.map($scope.selected.options, 'value')[0];
						}
						if($scope.input.required && !$scope.initializedInputs[$scope.input.id] && $scope.input.defaultValue && $scope.input.defaultValue.toLowerCase() === 'all'){
							$scope.setInputInitialized($scope.input.id, true, false);
						}
					}

					$scope.updateLabel();
				}

				$scope.updateSelection = function(option, checked) {
					//fix for the selection.
					setTimeout(function(){
						$scope.selectionChanged = true;
						$scope.highlightRequiredInput = false;
						if ($scope.input.allowMultipleSelection) {
							$scope.valueSelected = checked || $scope.selected.options.length > 0 ? true : false;
							if (!$scope.component.searchText) {
								if ($scope.selected.options.length === $scope.options.length) {
									$scope.handleSelectAll();
								} else if ($scope.allSelected) {
									$scope.allSelected = false;
								}
							}
						} else {
							$scope.selected.options = [];
							$scope.selected.options.push(option);
							$scope.valueSelected = true;
							$scope.status.isopen = false;
						}
						$scope.updateValue();
					});
				}

				$scope.removeSelection = function(event, option, checked) {
					$scope.selected.options = $scope.selected.options.filter(selected => selected.value !== option.value);
					$scope.updateSelection(option, checked);
					event.stopPropagation();
				}

				// initialize the inputs once the data is loaded. This function will mark the options checked , so that gui will show it as slected
				$scope.initialize = function() {
					if ($scope.input.allowMultipleSelection) {
						//handle all selected
						if ((!$scope.input.required && (typeof $scope.input.value === 'string' && $scope.input.value.toLowerCase() === "all")) ||
								($scope.input.required && $scope.input.value && $scope.input.value.length === $scope.options.length) || ($scope.input.required && typeof $scope.input.value === 'string' && $scope.input.value.toLowerCase() === "all")) {
							$scope.handleSelectAll();
						} else {
							if (_.isArray($scope.input.value)) {
								$scope.selected.options = _.filter($scope.options, function(element) {
									if ($scope.input.value.indexOf(element.value) !== -1) {
										$scope.valueSelected = true;
										return element;
									}
								});
							}
							$scope.updateLabel();
						}
					} else if (typeof $scope.input.value != 'undefined') {
						var opt = _.find($scope.options, {
							'value' : $scope.input.value
						});
						$scope.selected.options = [];
						if (opt) {
							$scope.selected.options.push(opt);
							$scope.updateLabel();
						}
					}
				}

				$scope.checkIfdependsOnInputsinitilized = function() {
					if (!$scope.input.dependsOn || $scope.input.dependsOn && $scope.input.dependsOn.length === 0) {
						return true;
					}
					for ( var k in $scope.input.dependsOn) {
						return $scope.initializedInputs[$scope.input.dependsOn[k]];
					}
				}

				$scope.getNextpage = function() {
					if(!$scope.applyingWhereCondition){
						$scope.offset = $scope.offset + 100;
					}
					$scope.loadDataForInput(true);

				}

				$scope.loadDataForInput = function(merge) {
					if (customReports.appName === 'adminconsole' && $scope.input.type === 'Commcell') {
						return;
					}
					//dummy component to satisfy the dataset util request.
					var readyToLoadInput = $scope.checkIfdependsOnInputsinitilized();
					if (!readyToLoadInput) {
						return;
					}
					$scope.component = {
						type : 'INPUT',
						title : {
							text : $scope.input.displayName
						},
						pageSize : 100,
						pageOffset : $scope.offset,
						skipFilters : true
					};

					var fields = [ "distinct([" + $scope.input.valueField + "]) AS value" ];
					if ($scope.input.labelField == undefined || $scope.input.labelField == "") {
						fields.push("[" + $scope.input.valueField + "] AS label");
					} else {
						fields.push("[" + $scope.input.labelField + "] AS label");
					}

					if($scope.input.type === 'Commcell' && $scope.input.valueField !== 'id'){
						fields.push("[id] AS valueId");
					}

					//fields.push([ "count([" + $scope.input.valueField + "]) AS count" ]);

					var orderByClause = "";
					if ($scope.input.sort && $scope.input.sort.columnId && $scope.input.sort.columnId !== "None") {
						orderByClause = "[" + $scope.input.sort.columnId + "]";
						if ($scope.input.sort.columnId !== "value" && $scope.input.sort.columnId !== "label") {
							fields.push("[" + $scope.input.sort.columnId + "]");// adding third column if the sort column is not the same as  the label or value fields.
						}
						if ($scope.input.sort.direction) {
							orderByClause = orderByClause + " " + $scope.input.sort.direction;
						}
					}else {
						orderByClause = "label";
					}


					var whereClause = [];
					// In schedules or exports entities from paged results are not shown in the summary.
					if($scope.exportType && $scope.requestParms["input."+$scope.input.id] && $scope.requestParms["input."+$scope.input.id] !== "All"){
						$scope.input.value.forEach( (inputValue) => {
							whereClause.push(' ['+$scope.input.valueField+'] =  _exprString ("' + inputValue + '","exact")');
						});
					}

					$scope.component.columns = fields;
					//$scope.component.groupby = [ 'value', 'label' ];
					$scope.component.orderByClause = orderByClause;
					$scope.component.where = whereClause;
					$scope.inputDS = null;
					if ($scope.input.dataSetEntity) {
						$scope.inputDS = $scope.getDataSet($scope.input.dataSetEntity.dataSetName, 'name');
					}
					if (!$scope.inputDS) {
						if ($scope.input.apiName) {
							$scope.inputDS = "System.HTTPWrapper";
							$scope.component.additionalParams = {
								"parameter.api" : $scope.input.apiName
							};
						} else {
							$scope.inputDS = $scope.input.dataSetEntity.dataSetName; //shared dataset to be queried.
						}
					}
					$scope.getData($scope.inputDS, $scope.component, function(data) {
						// ask archana or anita to see if they can support the object format for regular request and remove this additonal zipping.
						if ($scope.inputDS && $scope.inputDS.endpoint && $scope.inputDS.endpoint === "DATACUBE") {
							$scope.options = _.map(data.data.records, function(val) {
								return _.zipObject([ 'value', 'label' ], [ val[0], val[1] ]);
							});
						} else {
							if (merge) {
								$scope.options = $scope.options.concat(data.data.records);
							} else {
								$scope.options = data.data.records;
								if(_.isArray($scope.selected.options)){
									var changeInSelectedOption = false;
									$scope.selected.options = _.filter($scope.selected.options,function(selectedOption){
										if (_.find($scope.options,{ value: selectedOption.value })){
											return selectedOption;
										}else if(!changeInSelectedOption){
											changeInSelectedOption = true;
										}
									})
									if(changeInSelectedOption){
										$scope.updateSelection();
									}
								}
							}

							$scope.totalRecordCount = data.data.totalRecordCount
							if($scope.fetchedDataCountWithWhereConditionApplied){
								//totalRecordCount -> selected options(taken by applying 'where' clause to the query) + unselected options
								$scope.totalRecordCount += $scope.fetchedDataCountWithWhereConditionApplied;
							}
							$scope.filteredRecordCount = data.data.recordsCount;
							$scope.fetchedRecordCount += $scope.filteredRecordCount;
							if ($scope.reportMode === "viewer" && $scope.input.type === 'Commcell') {
								if(data.data.records.length > 1){
									$scope.input.hidden = false;
									if(typeof $scope.input.value !== "undefined" && $scope.input.valueField !== 'id'){
										if($scope.input.allowMultipleSelection){
											for(var i =0; i < $scope.input.value.length;i++){
												let val = $scope.input.value[i];
												if(!isNaN(val)){
													val = parseInt(val);
													let local = _.find(data.data.records, ['valueId', val]);
													$scope.input.value[i] = local.value;
												}
											}
										}else{
											let val = parseInt($scope.input.value);
											if(!isNaN(val)){
												let local = _.find(data.data.records, ['valueId', val]);
												$scope.input.value = local.value;
											}
										}
									}
								}else if($scope.input.required && data.data.records.length === 1){
									$scope.input.value = 2;
									$scope.initializedInputs[$scope.input.id] = true;
									$scope.checkAndReloadDependents();
								}
							}
						}

						if (data.data.records.length < 10) {
							$scope.showSearchBar = false;
						}else{
							$scope.showSearchBar = true;
						}

						if ($scope.reintialize) {
							$scope.initializeInput($scope.input,true,true);
							$scope.reintialize = false;
						}else{
							$scope.initialize();
						}
					});
				}

				$scope.$on('reloadDependents', function(event, args) {
					if (args.id === $scope.input.id) {
						$scope.fetchedRecordCount = 0;
						$scope.offset = 0;
						$scope.loadDataForInput();
					}
				});

				if ($scope.input.fromDataSet == true) {
					$scope.loadDataForInput();
				} else {

					var a = _.map($scope.input.possibleValues, function(val) {
						return {
							value : $scope.convertStringType(val, $scope.input)
						};
					});
					var b = _.map($scope.input.possibleValueLabels, function(val) {
						return {
							label : rpt.translate(val)
						};
					});
					$scope.options = _.merge(a, b);
					if ($scope.options.length < 10) {
						$scope.showSearchBar = false;
					}
					$scope.initialize();

				}

			} ]);

})();
