<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
<div class="chartArea full-height" id="chart_{{$index}}">
	<div ng-controller="tagCloudCtrl" class="maskLayer full-height" data-ng-class="{'isMasked':masked}">
	<label class='maskLayerLabel hideOnExportFriendly' data-ng-show="masked" ><fmt:message key="CustomReport.Loading"/></label>
	<div class="clearFloat"></div>
	<div class="yAxisColGroup" data-ng-show="reportMode === 'builder'">
		<fieldset class="axisColumnDrop" data-ng-class="{'dashboardAxisColumnDrop' : isDcubeEnabledInCustomReports}"  
			data-ng-class="{'disableColumnDrop':  !component.isSelected || disableMeasureDrop}" 
			x-lvl-drop-target="true"
			data-droptype="yAxis" 
			x-on-drop="dropped(dragEl, dropEl)">
			<legend class="fieldsetLegend">Drop Measure{{getFieldLabel(component.chartType, 'y')}}</legend>			
			<div data-ng-if ="!disableMeasureDrop && component.measureDataField.length!=0" data-ng-repeat="field in component.measureDataField" class="chartColumns groupingCol">
	 				<label>  				
	 				<select data-ng-model="field.aggrType" data-ng-change="aggregateSelectionChanged()" class="colNoBorder">
	                <option data-ng-if="field.showNumberOps && component.chartType != 'TimeSeries'" value="None"><fmt:message key="CustomReport.None"/></option>
	                   <option value="Count"><fmt:message key="CustomReport.Count"/></option>
	                   <option value="CountDistinct" data-ng-if="component.chartType != 'TimeSeries'"><fmt:message key="CustomReport.Distinct"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
	                   <option data-ng-if="field.showNumberOps"  value="Min"><fmt:message key="CustomReport.Min"/></option>
	                   <option data-ng-if="field.showNumberOps" value="Max"><fmt:message key="CustomReport.Max"/></option>
	               </select> ({{field.column}})
	               </label>
	        	<span class="deleteColumn" data-ng-click="deleteColumn(component.measureDataField, $index)">&times;</span>
			</div>
		</fieldset>
	</div>	
		<div class="clearFloat"></div>
			
			<div class="noChartDiv"  data-ng-show="isShowNoChartDiv()" data-ng-click="setActiveComponent()">
					<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message key="CustomReport.NoDataAvailable"/></label>
			</div>
			<tag-cloud data-ng-show="!$scope.masked && component.isChartExist" tagcloudconfig="tagcloudconfig" component="component" filters="page.body.filters"></tag-cloud>
		<div class="xAxisColGroup" data-ng-show="reportMode === 'builder'">
			<fieldset class="axisColumnDrop" data-droptype="xAxis" 
				data-ng-class="{'dashboardAxisColumnDrop' : isDcubeEnabledInCustomReports}" 
				data-ng-class="{'disableColumnDrop':!component.isSelected}" 
				x-lvl-drop-target="true" 
				x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend">Drop Dimension {{getFieldLabel(component.chartType, 'x')}}</legend>
				<div data-ng-repeat="field in component.dimensionDataField" class="chartColumns groupingCol" data-ng-class="{'hidden':component.dimensionDataField == undefined || component.dimensionDataField.length == 0 }">
						<label> 
						({{field.column}})
					</label>
					<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->
					<span class="deleteColumn" data-ng-click="deleteColumn(component.dimensionDataField, $index)">&times;</span>
				</div>
			</fieldset>
		</div>
		<div class="clearFloat"></div>
  </div>
</div>
</fmt:bundle>