<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Tabs" data-ng-class="{'sub-header-active': selectedPropertyCategory==='tabs'}" data-ng-click="selectedPropertyCategory='tabs'">
        <span class="ico ico-form-field"></span>
    </li>
</ul>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">        
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.title.text"
                       type="text"
                       placeholder="<fmt:message key="CustomReport.Properties.Title"/>">
                </div>
            </div>                  
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">                
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div> 
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">                        
                </div>
            </div>            
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideBorder"/>'><fmt:message key="CustomReport.Properties.HideBorder"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideborder" id="hideborder">                        
                </div>
            </div>            
        </div>
    </div>
<!--Default Tab -->
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DefaultTab"/>'><fmt:message key="CustomReport.Properties.DefaultTab"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control input-sm" data-ng-model="propData.defaultTab"  >
                        <option data-ng-repeat="tab in propData.tabs"  value="{{tab.id}}">{{tab.title.text}}</option>
                    </select>
                </div>
            </div>             
        </div>
    </div>       
    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
</div>

<!-- Begin "Tab" group -->
<div data-ng-show="selectedPropertyCategory==='tabs'"  data-ng-if="propData.tabs && propData.tabs.length!=0">
    <div data-ng-repeat="tab in propData.tabs" data-ng-init="collapsed['tab'+$index] = true">
    	<div data-ng-class="{'collapsed': collapsed['tab']}">
	     <div class="row fieldPanel secondary-header inner-panel" id="individual-component">
           <div class="fieldHeader" data-ng-click="collapsed['tab'+$index]=!collapsed['tab'+$index]">                
                 <label class="col-lg-9 noLftRghtPadding ">
                     <span title="{{tab.title.text}}">{{tab.title.text}}</span>
                 </label>
                  <span class="pull-right">
                       <span data-ng-click="deleteTab($index)" class="ico ico-trash2" title='<fmt:message key="DeleteField"/>'></span>
                       <span class="ico inner-panel-expand-icon ico-chevron-right" data-ng-class="{'ico-chevron-down':!collapsed['tab'+$index], 'ico-chevron-right':collapsed['tab'+$index]}" title="Tab Details"></span>
                   </span> 
                   <br style="clear: both;">                                    
           </div>   
	       <div data-ng-class="{'collapsed': collapsed['tab'+$index]}" class="collapsed">                
				<div class="row">
			        <div class="col-xs-12">
			<!-- FIXME: Localize -->
			            <div class="form-group">
			                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
			                <div class="col-sm-8 noLftRghtPadding">
			                    <input class="form-control input-sm"
			                       data-ng-model="tab.title.text"
			                       type="text"
			                       placeholder="<fmt:message key="CustomReport.Properties.Title"/>">
			                </div>
			            </div>                  
			        </div>
    			</div>
		       <div class="row">
		        <div class="col-xs-12">
		<!-- FIXME: Localize -->
		            <div class="form-group">
		                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
		                <div class="col-sm-8 noLftRghtPadding">
		                    <input name="chartid" class="form-control input-sm"
		                   type="text"                   
		                   data-ng-model="tab.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !tab.id}">                
		                </div>
		                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!tab.id">*ID should contain characters,digits and underscore only.</span>
		            </div> 
		        </div>
		    </div>
		    <div class="row">
		    	<div class="col-xs-12">
		<!-- FIXME: Localize -->
		            <div class="form-group">
		                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-12 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisableExpression"/>'><fmt:message key="CustomReport.Properties.DisableExpression"/></label>
		                <div class="col-sm-12 noLftRghtPadding">
		                	<textarea data-ng-model="tab.disableExpression"
										 placeholder="<fmt:message key="CustomReport.Properties.ButtonEnableExpressionResult"/>"
										rows="5"></textarea>
		                </div>
		            </div>
		     	 </div>
   			 </div>  		
		   </div>
		</div>		
		</div> 
    </div>       
</div>


</fmt:bundle>