 <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<fmt:message key="CustomReport.Component.ScatterChart" var="scatter" />
	<div id="{{component.id}}"
		class="clearFloat reportTable reportView previewTable_table"
		data-ng-if="component.chartType =='scatter'">

		<div class="maskLayer full-height"
			data-ng-class="{'isMasked':masked}">
			<div class="tableOptions" data-ng-hide="tableOptions">
				<div class="pivotOptions"
					data-ng-show="reportMode == 'builder' && component.type === 'SCATTER' && !isFullScreen">

					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="scatterX"
						x-on-drop="dropped(dragEl, dropEl)">

						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.Drop.Row">
								<fmt:param value="${scatter}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.scatterX == undefined}">
							<label> ({{component.scatterX.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('scatterX')">&times;</span>
							</label>
							<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->

						</div>
					</fieldset>

					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="scatterY"
						x-on-drop="dropped(dragEl, dropEl)">
						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.Drop.Column">
								<fmt:param value="${scatter}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.scatterY == undefined}">
							<label> ({{component.scatterY.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('scatterY')">&times;</span>
							</label>
						</div>
					</fieldset>
					
					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="scatterLabel"
						x-on-drop="dropped(dragEl, dropEl)">
						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.Drop.Label">
								<fmt:param value="${scatter}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.scatterLabel == undefined}">
							<label> ({{component.scatterLabel.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('scatterLabel')">&times;</span>
							</label>
						</div>
					</fieldset>
				</div>
			</div>
			<div class="clearFloat"></div>
			<div class="noChartDiv" data-ng-show="isShowNoChartDiv()"
				data-ng-click="setActiveComponent()">
				<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message
						key="CustomReport.NoDataAvailable" /></label>
			</div>
			<highchart data-ng-show="!$scope.masked && (component.scatterX && component.scatterY && component.scatterLabel)"
				config="chartConfig"
				data-ng-class="{'viewer-chart-height' : reportMode == 'viewer' && isDcubeEnabledInCustomReports ,'builder-chart-height' : reportMode == 'builder' && isDcubeEnabledInCustomReports}">
			</highchart>
		</div>
	</div>
</fmt:bundle>