//Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app
	.directive("scatterChart",
			[
			 'customReportSvc',
			 '$timeout',
			 "dataSource",
			 function(customReportSvc, $timeout, $dataSource) {
				 return {
					 restrict : "AEC",
					 scope : false,
					 link : function(scope, elem, attr) {

					 },
					 templateUrl : customReports.contextPath +
					 '/reportsplus/components/scatter/scatterChart.jsp',
					 controller : ['$scope', function($scope) {
						 var componentTitleHeight = 53;
						 customReportSvc.registerCallback("redrawAllComponents", function(data) {
							 $scope.loadComponent();
						 });
						 var numberTypes = [ "Double", "Float", "Integer", "Long", "Short", "Decimal" ];
						 function getScatterConfig() {
							 var chartConfig = {
									 options : {
										 exporting : {
											 enabled : false
										 },
										 credits : {
											 enabled : false
										 },
										 chart : {
											 type : 'scatter',
											 zoomType : 'xy',
											 events : {
											 	redraw : function(event) {
														$scope.$emit('chartRedraw', [ $scope.component.id ]);
												}
											 }
										 },
										 legend : {
											 enabled : false,
											 align : 'right',
											 layout : 'vertical',
											 verticalAlign : 'middle',
											 itemStyle : {
												 fontWeight : 'normal',
											 },
											 labelFormatter : function() {
												 var label = this.name;
												 if (this.y) {
													 label = label + " (" + this.y + ")";
												 }
												 return label;
											 }
										 },
										 tooltip : {

										 }
									 },
									 title : {
										 text : ''
									 },
									 xAxis : {
										 title : {
											 enabled : true,
											 text : ''
										 },
										 startOnTick : true,
										 endOnTick : true,
										 showLastLabel : true
									 },
									 yAxis : {
										 title : {
											 text : ''
										 }
									 },
									 plotOptions : {
										 scatter : {
											 lineWidth : 1,
											 states : {
												 hover : {
													 marker : {
														 enabled : false
													 }
												 }
											 }
										 }
									 },
									 series : []
							 }
							 return chartConfig;
						 }

						 $scope.loadComponent = function() {

							 if (!$scope.component.scatterX || !$scope.component.scatterY ||
									 !$scope.component.scatterLabel) {
								 $scope.component.isComponentLoading = false;
								 return;
							 }
							 $scope.showNoDataDiv = false;
							 // show loading on top
							 $scope.component.isComponentLoading = true;
							 $scope.loadingButton();
							 $scope.chartConfig = getScatterConfig();
							 if (!$scope.component.scatterProps) {
								 $scope.component.scatterProps = {
										 scatterY : $scope.component.scatterY.name,
										 scatterX : $scope.component.scatterX.name
								 };
							 }
							 $scope.chartConfig.options.legend.enabled = $scope.component.scatterProps.isShowLegend;
							 var legend = $scope.chartConfig.options.legend;

							 if (legend.enabled === true) {
								 $scope.chartConfig.options.legend = onLegendPositionSelection(legend);
							 }
							 $scope.chartConfig.yAxis.title.text = $scope.component.scatterY.column;
							 $scope.chartConfig.xAxis.title.text = $scope.component.scatterX.column;
							 
							 var limit = 999999;
							 var additionalDimensionProperties = {
									 'numPointsToDisplay' : {
										 'includeAll' : false,
										 'maxPoints' : 15
									 }
							 };
							 if ($.isEmptyObject($scope.component.scatterLabel.numPointsToDisplay)) {
								 $scope.component.scatterLabel = $.extend({},
										 $scope.component.scatterLabel,
										 additionalDimensionProperties);
							 }
							 if (!$.isEmptyObject($scope.dataSet) &&
									 $scope.dataSet.endpoint === 'DATACUBE') {
								 var dimensionDataField = [], measureDataField = [];
							
								 var scatterYColumn = {
										 'column' : $scope.component.scatterY.name,
										 'dataField' : $scope.component.scatterY.dataField,
										 'sortOrder' : "NONE",
										 'aggrType' : 'None'
								 };
								 var scatterXColumn = {
										 'column' : $scope.component.scatterX.name,
										 'dataField' : $scope.component.scatterX.dataField,
										 'sortOrder' : "Asc"
								 };
								 var scatterLabel = {
										 'column' : $scope.component.scatterLabel.name,
										 'dataField' : $scope.component.scatterLabel.dataField,
										 'sortOrder' : "Asc"
								 };
								 dimensionDataField.push(scatterXColumn);
								 dimensionDataField.push(scatterLabel);
								 measureDataField.push(scatterYColumn);
								 limit = $scope.component.scatterLabel.numPointsToDisplay.includeAll ? limit
										 : $scope.component.scatterLabel.numPointsToDisplay.maxPoints;

								 var columns = dimensionDataField;
								 columns = columns.concat(measureDataField);
								 var tableParams = {
										 columns : customReportSvc
										 .getSelectedColumnsDefn($scope.dataSet.fields, columns),
										 offset : 0,
										 limit : limit
								 };

								 $dataSource.getDataSource($scope.dataSet.endpoint).getMapData({
									 dataSet : $scope.dataSet,
									 componentType : $scope.component.type,
									 measureDataField : measureDataField,
									 dimensionDataField : dimensionDataField,
									 sortOptions : undefined,
															tableParams : tableParams,
															inputParams : customReportSvc
																	.applyInputsToDataSet($scope.dataSet,
																			$scope.page.inputs)
														},
																function(response) {
									 onSuccessGetScatterData(response);
								 });
							 } else {
								 $scope.component.pageSize = $scope.component.scatterLabel.numPointsToDisplay.includeAll ? undefined
										 : $scope.component.scatterLabel.numPointsToDisplay.maxPoints;
								 $scope.getData().then(function(resultData) {
									 onSuccessGetScatterData(resultData);
								 }, function(error) {
									 console.log(error);
									 $scope.component.isComponentLoading = false;
								 });
							 }
						 }

						 var onSuccessGetScatterData = function(resultData) {
							 var response = resultData;
							 var records = response.records;

							 if (!records && response.data) {
								 var columns = response.data.columns;								 
								 records = response.data.records;
								 angular.forEach(records, function(value, key) {
									 var obj = {}, j = 0;
									 for (; j < 3; j++) {
										 obj[columns[j].name] = value[j];
									 }
									 records[key] = obj;
								 });								
							 }

							 if (records.length > 0) {
								 $scope.masked = false;
								 var labelName = $scope.component.scatterLabel.name;
								 records = records.reduce(function(result, current) {
									 var label = current[labelName];
									 result[label] = result[label] || [];
									 result[label].push(current);
									 return result;
								 }, {});
								 angular.forEach(records, function(items, key) {
									 var chartSeries = {
											 name : '',
											 data : []
									 };
									 chartSeries.name = key;
									 for (var i = 0; i < items.length; i++) {
										 var pointArray = [];
										 pointArray.push(items[i][$scope.component.scatterX.name]);
										 pointArray.push(items[i][$scope.component.scatterY.name]);
										 chartSeries.data.push(pointArray);
									 }
									 $scope.chartConfig.series.push(chartSeries);
								 });
								 $scope.showNoDataDiv = false;
								 $scope.component.isComponentLoading = false;
								 var seriesCount = 0;

								 $scope.chartConfig.options.tooltip.formatter = function() {
									 var tooltipString = "<b>" + this.point.series.name + "</b><br>";
									 tooltipString += $scope.component.scatterX.column + " : " +
									 this.point.x + "<br>";
									 tooltipString += $scope.component.scatterY.column + " : " +
									 this.point.y + "<br>";
									 return tooltipString;
								 };
								 $scope.chartConfig.options.chart.height = $("li[comp=" +
										 $scope.component.id + "]>div").height();
								 $scope.chartConfig.options.chart.width = $("li[comp=" +
										 $scope.component.id + "]>div").width();
								 if ($scope.reportMode == 'builder') {
									 $scope.chartConfig.options.chart.height = $scope.chartConfig.options.chart.height -
									 componentTitleHeight;
								 }
							 } else {
								 $scope.showNoDataDiv = true;
							 }

							 $scope.component.isComponentLoading = false;
						 }

						 var onLegendPositionSelection = function(legend) {
							 if ($scope.component.scatterProps.legendPosition == "left") {
								 legend.align = "left";
								 legend.layout = "vertical";
								 legend.verticalAlign = "middle";
							 } else if ($scope.component.scatterProps.legendPosition == "right") {
								 legend.align = "right";
								 legend.layout = "vertical";
								 legend.verticalAlign = "middle";
							 } else if ($scope.component.scatterProps.legendPosition == "top") {
								 legend.align = "center";
								 legend.layout = "horizontal";
								 legend.verticalAlign = "top";
							 } else if ($scope.component.scatterProps.legendPosition == "bottom") {
								 legend.align = "center";
								 legend.layout = "horizontal";
								 legend.verticalAlign = "bottom";
							 }

							 if ($scope.gridster.isMobile) {
								 legend.align = "center";
								 legend.layout = "horizontal";
								 legend.verticalAlign = "bottom";
							 }
							 return legend;
						 }

						 $scope.reloadComponent = function(refreshCache) {
							 $scope.loadComponent();
						 };

						 $scope.dropped = function(dragEl, dropEl) {
							 var source = document.getElementById(dragEl);
							 if ($scope.reportMode == "viewer") {
								 return;
							 }

							 if (!$scope.component.isSelected) {
								 customReportSvc.errorToast('Select the component to add a column.');
								 return;
							 }

							 var dest = document.getElementById(dropEl);
							 var src = document.getElementById(dragEl);
							 var drag = angular.element(src);
							 var drop = angular.element(dest);
							 var dropType = drop.data('droptype');

							 var columnName = drag.attr("data-name");
							 var columnType = drag.attr("data-type");
							 var origType = drag.attr("data-origtype");
							 var dataField = drag.attr("data-datafield");
							 var dataSetEntity = drag.data("datasetentity");
							 var dataSetName = dataSetEntity.dataSetName;

							 if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
								 $scope.associateDataSetToComponent(dataSetEntity);
							 } else if ($scope.component.dataSet.dataSetName != dataSetName) {
								 alert("Mismatched data Sets");
								 return;
							 }

							 if ((drop.data('droptype') == "scatterX" || drop.data('droptype') == "scatterY") &&
									 !$scope.isNumberColumn(columnType)) {
								 customReportSvc
								 .errorToast("Please drop a field of type Double, Float, Integer, Long, Short or Decimal");
								 return;
							 }

							 var column = {
									 column : columnName,
									 name : columnName,
									 dataField : dataField,
									 type : columnType,
									 id : dataField.replace(/\s/g, ""),
									 aggrType : 'None'
							 };
							 if (!$scope.component.scatterProps) {
								 $scope.component.scatterProps = {};
							 }
							 if (drop.data('droptype') == "scatterX") {
								 $scope.component.scatterX = column;
								 $scope.component.scatterProps.scatterX = column.name;
							 } else if (drop.data('droptype') == "scatterY") {
								 $scope.component.scatterY = column;
								 $scope.component.scatterProps.scatterY = column.name;
							 } else if (drop.data('droptype') == "scatterLabel") {
								 $scope.component.scatterLabel = column;
							 }

							 $scope.loadComponent();
							 $scope.$apply();
						 };

						 if ($scope.component.scatterY && $scope.component.scatterX &&
								 $scope.component.scatterLabel) {
							 $scope.loadComponent();
						 }

						 $scope.deleteColumn = function(index) {
							 if (index === 'scatterX') {
								 $scope.component.scatterX = undefined;
							 } else if (index === 'scatterY') {
								 $scope.component.scatterY = undefined;
							 } else if (index === 'scatterLabel') {
								 $scope.component.scatterLabel = undefined;
							 }

							 $scope.loadComponent();
						 }

						 $scope.isNumberColumn = function(type) {
							 return numberTypes.indexOf(type) != -1;
						 }

						 customReportSvc.registerCallback("updateChart", function() {
							 $scope.loadComponent();
						 }, $scope.component.id);

						 customReportSvc.registerCallback("refreshComponent", function(componentId) {
							 if ($scope.component.id === componentId) {
								 $scope.loadComponent();
							 }
						 }, $scope.component.id);

						 $scope.$on('resize', function(sizes, gridster) {
							 if (gridster && gridster.length > 1) {
								 var componentResizedScope = angular
								 .element(gridster[1]).scope();
								 var component = componentResizedScope.$parent.component;
								 var currentCompId = component.id;
								 if ($scope.component.id == currentCompId) {
									 if (component.chartType === 'scatter' && $scope.chartConfig) {
										 $timeout(function() {
											 var chart = angular.element('li[comp=' +
													 currentCompId +
											 '] .highcharts-container').parent()
											 .highcharts();
											 chart.options.chart.height = $("li[comp=" +
													 $scope.component.id + "]>div")
													 .height();
											 if ($scope.reportMode == 'builder') {
												 chart.options.chart.height = chart.options.chart.height -
												 componentTitleHeight;
											 }
											 chart.options.chart.width = $("li[comp=" +
													 $scope.component.id + "]>div")
													 .width();
											 chart.reflow();
										 },
										 50);
									 }
								 }
							 }
						 });

						  $scope.$on('chartRedraw', function(e, componentId) {
						 	if ($scope.chartConfig && typeof $scope.chartConfig.getHighcharts === 'function' &&
						 			$scope.isLayoutAvailable && $scope.component.id == componentId && $scope.component.chartType === 'scatter') {
						 		$timeout(function(){
						 			if (typeof $scope.chartConfig.getHighcharts === 'function') {
								 		var chart = $scope.chartConfig.getHighcharts();	
								 		var chartHeight = $("li[comp=" + $scope.component.id + "]>div").height();
								 		if ($scope.reportMode == 'builder') {
								 			chart.options.chart.height = chartHeight - 90;
								 		} else {
								 			if ($scope.isFullScreen) {
								 				chart.options.chart.height = chartHeight - 100;
								 			} else {
								 				chart.options.chart.height = chartHeight - 60;
								 			}						 			
								 		}
								 		chart.reflow();						 					 
								 	}					 					 
						 		});
							 }
						 });

						 $scope.$on('gridsterItemWidthChanged', function(event, isLeftPanelToggle,
								 componentId) {
							 if ($scope.chartConfig) {
								 $timeout(function() {
									 if (!isLeftPanelToggle && $scope.component.id == componentId &&
											 $scope.component.chartType === 'scatter') {
										 var chart = angular.element('li[comp=' + componentId +
										 '] .highcharts-container').parent().highcharts();
										 chart.options.chart.height = $("li[comp=" +
												 $scope.component.id + "]>div").height() -
												 componentTitleHeight;
										 chart.options.chart.width = $("li[comp=" + $scope.component.id +
										 "]>div").width();
										 chart.reflow();
									 }
								 }, 500);
							 }
						 });

						 $scope.$watch('component.scatterProps.scatterX',
								 function() {
							 if (!$scope.chartConfig ||
									 $scope.component.isComponentLoading) {
								 return;
							 }

							 $scope.chartConfig.xAxis.title.text = $scope.component.scatterProps.scatterX;
						 },
						 true);

						 $scope.$watch('component.scatterProps.scatterY',
								 function() {
							 if (!$scope.chartConfig ||
									 $scope.component.isComponentLoading) {
								 return;
							 }
							 $scope.chartConfig.yAxis.title.text = $scope.component.scatterProps.scatterY;
						 },
						 true);

						 $scope.$watch('component.scatterProps.isShowLegend',
								 function() {
							 if (!$scope.chartConfig ||
									 $scope.component.isComponentLoading) {
								 return;
							 }
							 $scope.chartConfig.options.legend.enabled = $scope.component.scatterProps.isShowLegend;
						 },
						 true);

						 $scope.$watch('component.scatterProps.legendPosition', function() {
							 if (!$scope.chartConfig || $scope.component.isComponentLoading) {
								 return;
							 }
							 var legend = $scope.chartConfig.options.legend;

							 if (legend.enabled === true) {
								 $scope.chartConfig.options.legend = onLegendPositionSelection(legend);
							 }
						 }, true);

					 }]
				 }
			 } ]);

})();
