// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");

	reports.directive("panelComponent", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/panel-components/panel-component.jsp',
			scope : {
				component : '=',
				args : '&'
			},
			controller : 'panelComponentCtrl'

		};
	});

	reports.directive("menuItem", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/panel-components/menu-component.jsp',
			scope : {
				component : '=',
				args : '&'
			},
			controller : 'panelComponentCtrl'

		};
	});

	reports.controller('panelComponentCtrl', [
			"$scope",
			"reportService",
			"$uibModal",
			"customReportSvc",
			function($scope, reportService, $uibModal, customReportSvc) {
				var data = $scope.args();
				
				if (!$scope.component) {
					return;
				}
				
				$scope.evalExpression = function(itemExpression) {
					if (itemExpression) {
						data["expression"] = itemExpression;
						var value = rpt.evalExpression(data);
						return value;
					}
				}

				$scope.evalTitleExpression = function(itemExpression) {
					return $scope.evalExpression(customReportSvc.checkExpressionToLocalize(itemExpression));
				}

				$scope.click = $scope.component.events['onClick'];

				$scope.getExpression = function() {
					var generatedExpression;
					var clickParams = $scope.click;
					if (clickParams.action === "Custom") {
						generatedExpression = clickParams.customExpression;
					} else if (clickParams.action === "Link") {
						generatedExpression = "=document.location.href='" + $scope.evalExpression(clickParams.URL) +
								"'";
					} else if (clickParams.action === "Workflow") {
						generatedExpression = "=openForm({'workflowName':'" + clickParams.name + "'";
						var inputs = [];
						for (var i = 0; i < clickParams.inputs.length; i++) {
							if (clickParams.inputs[i].value) {
								inputs.push("'" + clickParams.inputs[i].id + "': \'" +
										$scope.evalExpression(clickParams.inputs[i].value) + "\'");
							}
						}
						if (inputs.length !== 0) {
							generatedExpression += ", inputs:{";
							for (var i = 0; i < inputs.length; i++) {
								generatedExpression += inputs[i] + ",";
							}
							generatedExpression = generatedExpression.substring(0, generatedExpression.length - 1) +
									"}";
						}

						var autoSubmit = false;
						if (clickParams.autoSubmit) {
							autoSubmit = clickParams.autoSubmit;
						}

						var refresh = false;
						if (clickParams.refreshOnSuccess) {
							refresh = clickParams.refreshOnSuccess;
						}
						
						generatedExpression += ",_submit:" + autoSubmit + ",refreshOnSuccess:" + refresh; 
						
						if (clickParams.fullPage != undefined && clickParams.fullPage === true) {
							generatedExpression += ", fullPage:true";
						}
					
						generatedExpression += ", targetElement:'#reportArea'";
						
						generatedExpression += "})";

					} else if (clickParams.action === "Report") {
						var baseUrl = window.location.origin + customReports.contextPath +
								"/reportsplus/reportViewer.jsp?";
						var urlParams = [];
						var url = "";
						urlParams.push("reportId=" + encodeURIComponent(clickParams.reportId));
						if (clickParams.pageName) {
							urlParams.push("pageName=" + encodeURIComponent(clickParams.pageName));
						}
						if (clickParams.inputs.length !== 0) {
							for (var i = 0; i < clickParams.inputs.length; i++) {
								if (clickParams.inputs[i].value) {
									urlParams.push("input." +
											clickParams.inputs[i].id +
											"=" +
											$scope.getReportInputValue(clickParams.inputs[i].isMulti, $scope
													.evalExpression(clickParams.inputs[i].value)));
								}
							}
						}
						for (var i = 0; i < urlParams.length; i++) {
							url += urlParams[i] + "&";
						}
						url = url.substring(0, url.length - 1);
						if (clickParams.openInNewTab) {
							generatedExpression = "=window.open(\'" + baseUrl + url + "\',\'_blank\')";
						} else {
							generatedExpression = "=document.location.href=\'" + baseUrl + url + "\'";
						}

					} else if (clickParams.action === "EditTableRecords") {
						// var baseUrl = window.location.origin + customReports.contextPath + "/tableForm.do?";
						// var urlParams = [];
						// var url = ""
						// urlParams.push("tableId=" + encodeURIComponent(clickParams.tableId));
						// if (clickParams.pageName) {
						// 	urlParams.push("pageName=" + encodeURIComponent(clickParams.pageName));
						// }
						// if (clickParams.rowId) {
						// 	urlParams.push("sysRowId=" + encodeURIComponent($scope.evalExpression(clickParams.rowId)));
						// }
						// angular.forEach(urlParams, function(param, idx) {
						// 	url += param + "&";
						// })
						// url = url.substring(0, url.length - 1);
						// if (clickParams.openInNewTab) {
						// 	generatedExpression = "=window.open(\'" + baseUrl + url + "\',\'_blank\')";
						// } else {
						// 	generatedExpression = "=document.location.href=\'" + baseUrl + url + "\'";
						// }
						generatedExpression = "=openTableForm({'tableId':'" + clickParams.tableId + "', 'sysRowId':'"
						generatedExpression += $scope.evalExpression(clickParams.rowId) + "'";
						
						if (clickParams.fullPage != undefined && clickParams.fullPage === true) {
							generatedExpression += ", fullPage:true";
						}
						else
						{
							if(clickParams.pageMode != undefined)
							{
								if(clickParams.pageMode === "POPUP")
									generatedExpression += ", fullPage:false";
								else if(clickParams.pageMode === "FULL_PAGE")
									generatedExpression += ", fullPage:true";
							}
						}

						if(clickParams.tableFormId != undefined && clickParams.tableFormId != "")
						{
							generatedExpression += " ,formId:'" + clickParams.tableFormId + "'";
						}
						
						generatedExpression += ", targetElement:'#reportArea'});";
					}
					return generatedExpression;
				}

				$scope.getReportInputValue = function(isMulti, value) {
					if (isMulti) {
						return "%5B\"" + value + "\"%5D";
					} else {
						return value;
					}
				}

				$scope.evalClickEvent = function() {
					return $scope.evalExpression(rpt.getButtonExpression($scope.click, $scope.evalExpression));
				}

				$scope.style = $scope.evalExpression($scope.component.style);
				$scope.evaluatedTiltle = $scope.evalTitleExpression($scope.component.title.text);

				$scope.$watch('component.title.text', function() {
					$scope.evaluatedTiltle = $scope.evalTitleExpression($scope.component.title.text);
				});

				$scope.isDisabled = function() {
					var disabled = false;
					if ($scope.component.enable === 'custom') {
						disabled = $scope.evalExpression($scope.component.enableExpression)
					}
					return disabled;
				}

				$scope.getHref = function() {
					if ($scope.click.action === 'Link') {
						return $scope.click.URL;
					} else if ($scope.click.action === 'Report') {
						return $scope.getExpression();
					}
				}

				$scope.isVisible = function() {
					var visible = true;
					if ($scope.component.visible === 'custom') {
						visible = $scope.evalExpression($scope.component.visibleExpression)
					}
					return visible;
				}

				$scope.showDropdownMenu = function(event) {
					var targetElement = event.target.parentElement;
					var menuSelector = $(targetElement).find('.dropdown-selector-menu');
					if ($(menuSelector).hasClass('show')) {
						$(menuSelector).removeClass('show').addClass('hide');
					} else {
						$(menuSelector).removeClass('hide').addClass('show');

						$(targetElement).find('[data-toggle="dropdown-selector"]').focusout(function() {
							setTimeout(function() {
								$(menuSelector).removeClass('show').addClass('hide');
							}, 500);
						});
					}

					event.stopPropagation();
					event.preventDefault();
				}

			} ]);

})();